/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.infinityraider.agricraft.api.v1.event.AgriRegistryEvent;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.impl.v1.AgriRegistryAbstract;
import com.infinityraider.agricraft.impl.v1.genetics.GeneSpecies;
import com.infinityraider.agricraft.impl.v1.genetics.GeneStat;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AgriGeneRegistry
extends AgriRegistryAbstract<IAgriGene<?>>
implements IAgriGeneRegistry {
    private static final AgriGeneRegistry INSTANCE = new AgriGeneRegistry();
    public final IAgriGene<IAgriPlant> gene_species = GeneSpecies.getInstance();

    public static AgriGeneRegistry getInstance() {
        return INSTANCE;
    }

    private AgriGeneRegistry() {
        this.directAdd(this.gene_species);
    }

    @Override
    public boolean add(@Nullable IAgriGene<?> element) {
        if (element instanceof GeneStat) {
            return this.addGeneForStat(((GeneStat)element).getStat());
        }
        return super.add(element);
    }

    @Override
    public boolean remove(@Nullable IAgriGene<?> element) {
        if (element == this.gene_species) {
            return false;
        }
        if (element instanceof GeneStat) {
            return this.removeGeneForStat(((GeneStat)element).getStat());
        }
        return super.remove(element);
    }

    @Override
    @Nonnull
    public IAgriGene<IAgriPlant> getPlantGene() {
        return this.gene_species;
    }

    @Override
    public Optional<IAgriGene<Integer>> get(@Nullable IAgriStat stat) {
        return stat == null ? Optional.empty() : this.get(stat.getId()).map(gene -> gene);
    }

    @Override
    public boolean addGeneForStat(@Nullable IAgriStat stat) {
        return this.get(stat).map(gene -> false).orElseGet(() -> {
            boolean result = super.add(new GeneStat(stat));
            if (result) {
                AgriStatRegistry.getInstance().add(stat);
            }
            return result;
        });
    }

    @Override
    public boolean removeGeneForStat(@Nullable IAgriStat stat) {
        return this.get(stat).map(gene -> {
            boolean result = super.remove(gene);
            if (result) {
                AgriStatRegistry.getInstance().remove(stat);
            }
            return result;
        }).orElse(false);
    }

    @Override
    public Optional<IAgriStat> getStatForGene(@Nullable IAgriGene<Integer> gene) {
        return Optional.ofNullable(gene).flatMap(g -> AgriStatRegistry.getInstance().get(g.getId()));
    }

    @Override
    @Nullable
    protected AgriRegistryEvent<IAgriGene<?>> createEvent(IAgriGene<?> element) {
        return new AgriRegistryEvent.Gene(this, element);
    }
}

