/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.log.AgriLogger;
import com.agricraft.agricore.plant.AgriMutation;
import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.plant.AgriSoil;
import com.agricraft.agricore.plant.AgriWeed;
import com.agricraft.agricore.plant.fertilizer.AgriFertilizer;
import com.google.common.collect.UnmodifiableIterator;
import com.infinityraider.agricraft.capability.CapabilityResearchedPlants;
import com.infinityraider.agricraft.content.tools.ItemMagnifyingGlass;
import com.infinityraider.agricraft.network.json.MessageNotifySyncComplete;
import com.infinityraider.agricraft.network.json.MessageSyncFertilizerJson;
import com.infinityraider.agricraft.network.json.MessageSyncMutationJson;
import com.infinityraider.agricraft.network.json.MessageSyncPlantJson;
import com.infinityraider.agricraft.network.json.MessageSyncSoilJson;
import com.infinityraider.agricraft.network.json.MessageSyncWeedJson;
import java.util.Iterator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class JsonSyncHandler {
    private static final AgriLogger LOG = AgriCore.getLogger("agricraft-net");
    private static final JsonSyncHandler INSTANCE = new JsonSyncHandler();

    public static JsonSyncHandler getInstance() {
        return INSTANCE;
    }

    private JsonSyncHandler() {
    }

    @SubscribeEvent
    public void onConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player;
        MinecraftServer server;
        if (event.getPlayer() instanceof ServerPlayerEntity && (server = (player = (ServerPlayerEntity)event.getPlayer()).func_184102_h()) != null) {
            if (server.func_71262_S()) {
                this.syncJsons(player);
            } else if (server.func_71344_c()) {
                this.syncJsons(player);
            }
        }
    }

    protected void syncJsons(ServerPlayerEntity player) {
        this.syncSoils(player);
        this.syncPlants(player);
        this.syncWeeds(player);
        this.syncMutations(player);
        this.syncFertilizers(player);
        new MessageNotifySyncComplete().sendTo(player);
        ItemMagnifyingGlass.setObserving((PlayerEntity)player, false);
        CapabilityResearchedPlants.getInstance().configureJei((PlayerEntity)player);
    }

    protected void syncSoils(ServerPlayerEntity player) {
        LOG.debug("Sending soils to player: " + player.func_145748_c_().getString(), new Object[0]);
        int count = AgriCore.getSoils().getAll().size();
        Iterator<AgriSoil> it = AgriCore.getSoils().getAll().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriSoil soil = it.next();
            LOG.debug("Sending Soil: {0} ({1} of {2})", soil, i + 1, count);
            new MessageSyncSoilJson(soil, i, count).sendTo(player);
            ++i;
        }
        LOG.debug("Finished sending soils to player: " + player.func_145748_c_().getString(), new Object[0]);
    }

    protected void syncPlants(ServerPlayerEntity player) {
        LOG.debug("Sending plants to player: " + player.func_145748_c_().getString(), new Object[0]);
        int count = AgriCore.getPlants().getAllElements().size();
        UnmodifiableIterator it = AgriCore.getPlants().getAllElements().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriPlant plant = (AgriPlant)it.next();
            LOG.debug("Sending plant: {0} ({1} of {2})", plant.getId(), i + 1, count);
            new MessageSyncPlantJson(plant, i, count).sendTo(player);
            ++i;
        }
        LOG.debug("Finished sending plants to player: " + player.func_145748_c_().getString(), new Object[0]);
    }

    protected void syncWeeds(ServerPlayerEntity player) {
        LOG.debug("Sending weeds to player: " + player.func_145748_c_().getString(), new Object[0]);
        int count = AgriCore.getWeeds().getAllElements().size();
        UnmodifiableIterator it = AgriCore.getWeeds().getAllElements().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriWeed weed = (AgriWeed)it.next();
            LOG.debug("Sending weed: {0} ({1} of {2})", weed.getId(), i + 1, count);
            new MessageSyncWeedJson(weed, i, count).sendTo(player);
            ++i;
        }
        LOG.debug("Finished sending plants to player: " + player.func_145748_c_().getString(), new Object[0]);
    }

    protected void syncMutations(ServerPlayerEntity player) {
        LOG.debug("Sending mutations to player: " + player.func_145748_c_().getString(), new Object[0]);
        int count = AgriCore.getMutations().getAll().size();
        Iterator<AgriMutation> it = AgriCore.getMutations().getAll().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriMutation mutation = it.next();
            LOG.debug("Sending mutation: ({0} of {1})", i + 1, count);
            new MessageSyncMutationJson(mutation, i, count).sendTo(player);
            ++i;
        }
        LOG.debug("Finished sending mutations to player: " + player.func_145748_c_().getString(), new Object[0]);
    }

    protected void syncFertilizers(ServerPlayerEntity player) {
        LOG.debug("Sending fertilizers to player: " + player.func_145748_c_().getString(), new Object[0]);
        int count = AgriCore.getFertilizers().getAll().size();
        Iterator<AgriFertilizer> it = AgriCore.getFertilizers().getAll().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriFertilizer fertilizer = it.next();
            LOG.debug("Sending fertilizer: ({0} of {1})", i + 1, count);
            new MessageSyncFertilizerJson(fertilizer, i, count).sendTo(player);
            ++i;
        }
        LOG.debug("Finished sending fertilizers to player: " + player.func_145748_c_().getString(), new Object[0]);
    }
}

