/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.infinityraider.agricraft.api.v1.client.AgriPlantRenderType;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class PlantQuadBakeEvent
extends Event {
    private final IAgriPlantQuadGenerator quadGenerator;
    private final IAgriGrowable plant;
    private final IAgriGrowthStage stage;
    private final Direction face;
    private final List<ResourceLocation> textures;
    private final IntFunction<TextureAtlasSprite> spriteFunc;
    private final AgriPlantRenderType renderType;
    private final ImmutableList<BakedQuad> originalQuads;
    private final List<BakedQuad> quads;

    public PlantQuadBakeEvent(IAgriPlantQuadGenerator quadGenerator, IAgriGrowable plant, IAgriGrowthStage stage, @Nullable Direction face, List<ResourceLocation> textures, IntFunction<TextureAtlasSprite> spriteFunc, AgriPlantRenderType renderType, List<BakedQuad> quads) {
        this.quadGenerator = quadGenerator;
        this.plant = plant;
        this.stage = stage;
        this.face = face;
        this.textures = textures;
        this.spriteFunc = spriteFunc;
        this.renderType = renderType;
        this.originalQuads = ImmutableList.copyOf(quads);
        this.quads = Lists.newArrayList(quads);
    }

    public IAgriPlantQuadGenerator getQuadGenerator() {
        return this.quadGenerator;
    }

    public IAgriGrowable getPlant() {
        return this.plant;
    }

    public IAgriGrowthStage getGrowthStage() {
        return this.stage;
    }

    @Nullable
    public Direction getCullFace() {
        return this.face;
    }

    public List<ResourceLocation> getTextures() {
        return this.textures;
    }

    public TextureAtlasSprite getSprite(int index) {
        return this.spriteFunc.apply(index);
    }

    public AgriPlantRenderType getRenderType() {
        return this.renderType;
    }

    public ImmutableList<BakedQuad> getOriginalQuads() {
        return this.originalQuads;
    }

    public List<BakedQuad> getOutputQuads() {
        return this.quads;
    }

    public PlantQuadBakeEvent injectQuads(BakedQuad ... quads) {
        return this.injectQuads(Arrays.asList(quads));
    }

    public PlantQuadBakeEvent injectQuads(Collection<BakedQuad> quads) {
        this.getOutputQuads().addAll(quads);
        return this;
    }

    public PlantQuadBakeEvent removeQuads(BakedQuad ... quads) {
        return this.removeQuads(Arrays.asList(quads));
    }

    public PlantQuadBakeEvent removeQuads(Collection<BakedQuad> quads) {
        this.getOutputQuads().removeAll(quads);
        return this;
    }

    public PlantQuadBakeEvent clearQuads() {
        this.getOutputQuads().clear();
        return this;
    }
}

