/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbbackups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class FTBBackupsConfig {
    public static boolean auto;
    public static boolean silent;
    public static int backupsToKeep;
    public static long backupTimer;
    public static int compressionLevel;
    public static String folder;
    public static boolean displayFileSize;
    public static List<String> extraFiles;
    public static long maxTotalSize;
    public static boolean onlyIfPlayersOnline;
    public static boolean forceOnShutdown;
    public static int bufferSize;
    private static Pair<CommonConfig, ForgeConfigSpec> common;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FTBBackupsConfig::reload);
        common = new ForgeConfigSpec.Builder().configure(x$0 -> new CommonConfig((ForgeConfigSpec.Builder)x$0));
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)common.getRight());
    }

    public static void reload(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == common.getRight()) {
            FTBBackupsConfig.reloadCommon();
        }
    }

    public static void reloadCommon() {
        CommonConfig cfg = (CommonConfig)common.getLeft();
        auto = (Boolean)cfg.auto.get();
        silent = (Boolean)cfg.silent.get();
        backupsToKeep = (Integer)cfg.backupsToKeep.get();
        backupTimer = (long)((Integer)cfg.backupTimer.get()).intValue() * 60000L;
        compressionLevel = (Integer)cfg.compressionLevel.get();
        folder = (String)cfg.folder.get();
        displayFileSize = (Boolean)cfg.displayFileSize.get();
        extraFiles = new ArrayList<String>((Collection)cfg.extraFiles.get());
        String mts = (String)cfg.maxTotalSize.get();
        maxTotalSize = mts.endsWith("TB") ? Long.parseLong(mts.substring(0, mts.length() - 2).trim()) * 0x10000000000L : (mts.endsWith("GB") ? Long.parseLong(mts.substring(0, mts.length() - 2).trim()) * 0x40000000L : (mts.endsWith("MB") ? Long.parseLong(mts.substring(0, mts.length() - 2).trim()) * 0x100000L : (mts.endsWith("KB") ? Long.parseLong(mts.substring(0, mts.length() - 2).trim()) * 1024L : Long.parseLong(mts.trim()))));
        onlyIfPlayersOnline = (Boolean)cfg.onlyIfPlayersOnline.get();
        forceOnShutdown = (Boolean)cfg.forceOnShutdown.get();
        bufferSize = (Integer)cfg.bufferSize.get();
    }

    private static class CommonConfig {
        private final ForgeConfigSpec.BooleanValue auto;
        private final ForgeConfigSpec.BooleanValue silent;
        private final ForgeConfigSpec.IntValue backupsToKeep;
        private final ForgeConfigSpec.IntValue backupTimer;
        private final ForgeConfigSpec.IntValue compressionLevel;
        private final ForgeConfigSpec.ConfigValue<String> folder;
        private final ForgeConfigSpec.BooleanValue displayFileSize;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> extraFiles;
        private final ForgeConfigSpec.ConfigValue<String> maxTotalSize;
        private final ForgeConfigSpec.BooleanValue onlyIfPlayersOnline;
        private final ForgeConfigSpec.BooleanValue forceOnShutdown;
        private final ForgeConfigSpec.IntValue bufferSize;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            this.auto = builder.comment("Enables backups to run automatically.").translation("ftbbackups.general.auto").define("auto", true);
            this.silent = builder.comment("If set to true, no messages will be displayed in chat/status bar.").translation("ftbbackups.general.silent").define("silent", false);
            this.backupsToKeep = builder.comment(new String[]{"The number of backup files to keep.", "More backups = more space used", "0 - Infinite"}).translation("ftbbackups.general.backups_to_keep").defineInRange("backups_to_keep", 12, 0, 32000);
            this.backupTimer = builder.comment(new String[]{"Timer in minutes.", "5 - backups every 5 minutes", "60 - backups every hour", "360 - backups every 6 hours", "1440 - backups once every day"}).translation("ftbbackups.general.backup_timer").defineInRange("backup_timer", 120, 1, 43800);
            this.compressionLevel = builder.comment(new String[]{"0 - Disabled (output = folders)", "1 - Best speed", "9 - Smallest file size"}).translation("ftbbackups.general.compression_level").defineInRange("compression_level", 1, 0, 9);
            this.folder = builder.comment("Absolute path to backups folder.").translation("ftbbackups.general.folder").define("folder", (Object)"");
            this.displayFileSize = builder.comment("Prints (current size | total size) when backup is done.").translation("ftbbackups.general.display_file_size").define("display_file_size", true);
            this.extraFiles = builder.comment("Add extra files that will be placed in backup _extra_/ folder.").translation("ftbbackups.general.extra_files").defineList("extra_files", new ArrayList(), o -> true);
            this.maxTotalSize = builder.comment("Maximum total size that is allowed in backups folder. Older backups will be deleted to free space for newer ones.").translation("ftbbackups.general.max_total_size").define("max_total_size", (Object)"50 GB");
            this.onlyIfPlayersOnline = builder.comment("Only create backups when players have been online.").translation("ftbbackups.general.only_if_players_online").define("only_if_players_online", true);
            this.forceOnShutdown = builder.comment("Create a backup when server is stopped.").translation("ftbbackups.general.force_on_shutdown").define("force_on_shutdown", false);
            builder.comment("Advanced features that shouldn't be changed unless you know what you are doing.").push("advanced");
            this.bufferSize = builder.comment("Buffer size for writing files.").translation("ftbbackups.general.buffer_size").defineInRange("buffer_size", 4096, 256, 65536);
            builder.pop();
        }
    }
}

