/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;

public class ShortPos {
    private BlockPos relativeTo;

    public ShortPos(BlockPos relativeTo) {
        this.relativeTo = relativeTo;
    }

    public static int getIntPos(BlockPos position, BlockPos relativeTo) {
        if (position.func_177956_o() > 255) {
            position = new BlockPos(position.func_177958_n(), 255, position.func_177956_o());
        } else if (position.func_177956_o() < 0) {
            position = new BlockPos(position.func_177958_n(), 0, position.func_177956_o());
        }
        int xp = position.func_177958_n() - relativeTo.func_177958_n() + 2048;
        int yp = position.func_177956_o();
        int zp = position.func_177952_p() - relativeTo.func_177952_p() + 2048;
        return yp << 24 | xp << 12 | zp;
    }

    public static int getIntPos(Vector3f position, BlockPos relativeTo) {
        if (position.func_195900_b() > 255.0f) {
            position.setY(255.0f);
        } else if (position.func_195900_b() < 0.0f) {
            position.setY(0.0f);
        }
        int xp = (int)position.func_195899_a() - relativeTo.func_177958_n() + 2048;
        int yp = (int)position.func_195900_b();
        int zp = (int)position.func_195902_c() - relativeTo.func_177952_p() + 2048;
        return yp << 24 | xp << 12 | zp;
    }

    public static BlockPos getBlockPos(int intPos, BlockPos relativeTo) {
        int yp = intPos >> 24 & 0xFF;
        int xp = (intPos >> 12 & 0xFFF) - 2048;
        int zp = (intPos & 0xFFF) - 2048;
        int finalX = relativeTo.func_177958_n() + xp;
        int finalZ = relativeTo.func_177952_p() + zp;
        return new BlockPos(finalX, yp, finalZ);
    }

    public BlockPos getRelativeTo() {
        return this.relativeTo;
    }

    public void setRelativeTo(BlockPos relativeTo) {
        this.relativeTo = relativeTo;
    }

    public int getIntPos(BlockPos pos) {
        return ShortPos.getIntPos(pos, this.relativeTo);
    }

    public int getIntPos(Vector3f pos) {
        return ShortPos.getIntPos(pos, this.relativeTo);
    }

    public BlockPos getActualPos(int intPos) {
        return ShortPos.getBlockPos(intPos, this.relativeTo);
    }
}

