/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.plugin.FeaturePlugin;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.plugin.FeaturePluginInstance;
import com.hrznstudio.titanium.plugin.PluginPhase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vectorwing.farmersdelight.blocks.RiceCropBlock;
import vectorwing.farmersdelight.blocks.TomatoesBlock;

@FeaturePlugin(value="farmersdelight", type=FeaturePlugin.FeaturePluginType.MOD)
public class FarmersDelightPlugin
implements FeaturePluginInstance {
    public void execute(PluginPhase phase) {
        if (phase == PluginPhase.CONSTRUCTION) {
            EventManager.modGeneric(RegistryEvent.Register.class, PlantRecollectable.class).process(register -> ((RegistryEvent.Register)register).getRegistry().registerAll(new IForgeRegistryEntry[]{new TomatoesPlantRecollectable(), new RiceRecollectable()})).subscribe();
        }
    }

    public class TomatoesPlantRecollectable
    extends PlantRecollectable {
        public TomatoesPlantRecollectable() {
            super("fd_tomatoes");
        }

        @Override
        public boolean canBeHarvested(World world, BlockPos pos, BlockState blockState) {
            return blockState.func_177230_c() instanceof TomatoesBlock && ((TomatoesBlock)blockState.func_177230_c()).isMaxAge(blockState);
        }

        @Override
        public List<ItemStack> doHarvestOperation(World world, BlockPos pos, BlockState blockState) {
            NonNullList stacks = NonNullList.func_191196_a();
            stacks.addAll(BlockUtils.getBlockDrops(world, pos));
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return stacks;
        }

        @Override
        public boolean shouldCheckNextPlant(World world, BlockPos pos, BlockState blockState) {
            return true;
        }
    }

    private class RiceRecollectable
    extends PlantRecollectable {
        public RiceRecollectable() {
            super("fd_rice");
        }

        @Override
        public boolean canBeHarvested(World world, BlockPos pos, BlockState blockState) {
            return blockState.func_177230_c() instanceof RiceCropBlock && ((RiceCropBlock)blockState.func_177230_c()).isMaxAge(blockState);
        }

        @Override
        public List<ItemStack> doHarvestOperation(World world, BlockPos pos, BlockState blockState) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(BlockUtils.getBlockDrops(world, pos));
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            return itemStacks;
        }

        @Override
        public boolean shouldCheckNextPlant(World world, BlockPos pos, BlockState blockState) {
            return true;
        }
    }
}

