/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils.color;

import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;

public class RainbowColor {
    private static int r = 255;
    private static int g = 0;
    private static int b = 0;

    private RainbowColor() {
        throw new IllegalStateException("Utility Class");
    }

    public static void init() {
        new Timer().scheduleAtFixedRate((TimerTask)new ColorChange(), 0L, 40L);
    }

    public static Color getColor() {
        return new Color(r, g, b);
    }

    public static float[] getColorFloats() {
        return RainbowColor.getColor().getColorComponents(null);
    }

    public static int getRGB() {
        return RainbowColor.getColor().getRGB();
    }

    private static class ColorChange
    extends TimerTask {
        private ColorChange() {
        }

        private static void incrementRed() {
            r++;
        }

        private static void decrementRed() {
            r--;
        }

        private static void incrementGreen() {
            g++;
        }

        private static void decrementGreen() {
            g--;
        }

        private static void incrementBlue() {
            b++;
        }

        private static void decrementBlue() {
            b--;
        }

        @Override
        public void run() {
            if (r > 0 && b == 0) {
                ColorChange.decrementRed();
                ColorChange.incrementGreen();
            }
            if (g > 0 && r == 0) {
                ColorChange.decrementGreen();
                ColorChange.incrementBlue();
            }
            if (b > 0 && g == 0) {
                ColorChange.incrementRed();
                ColorChange.decrementBlue();
            }
        }
    }
}

