/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.utils.RenderCuboid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderUtils {
    private RenderUtils() {
        throw new IllegalStateException("Utility Class");
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(spriteLocation);
    }

    public static TextureAtlasSprite getStillFluidTexture(FluidStack fluidStack) {
        return RenderUtils.getSprite(fluidStack.getFluid().getAttributes().getStillTexture(fluidStack));
    }

    public static void resetColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTiledSprite(MatrixStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uMaxLocal = uMax - uDif * (float)maskRight / (float)textureWidth;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                float y = (float)yStart - ((float)yTile + 1.0f) * (float)textureHeight;
                int maskTop = textureHeight - height;
                float vMaxLocal = vMax - vDif * (float)maskTop / (float)textureHeight;
                vertexBuffer.func_227888_a_(matrix4f, (float)x, y + (float)textureHeight, (float)zLevel).func_225583_a_(uMin, vMaxLocal).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)shiftedX, y + (float)textureHeight, (float)zLevel).func_225583_a_(uMaxLocal, vMaxLocal).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)shiftedX, y + (float)maskTop, (float)zLevel).func_225583_a_(uMaxLocal, vMin).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)x, y + (float)maskTop, (float)zLevel).func_225583_a_(uMin, vMin).func_181675_d();
            }
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void renderFluid(MatrixStack matrix, FluidTank fluidTank, int tankNumber, int xPos, int yPos, int width, int height, int zOffset) {
        FluidStack stack = fluidTank.getFluidInTank(tankNumber);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(stack.getFluid().getAttributes().getStillTexture());
        int color = stack.getFluid().getAttributes().getColor();
        float red = RenderCuboid.getRed(color);
        float green = RenderCuboid.getGreen(color);
        float blue = RenderCuboid.getBlue(color);
        float alpha = RenderCuboid.getAlpha(color);
        int effectiveHeight = (int)((float)stack.getAmount() / (float)fluidTank.getTankCapacity(tankNumber) * (float)height);
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        RenderUtils.drawTiledSprite(matrix, xPos, yPos, height, width, effectiveHeight, sprite, 16, 16, zOffset);
        RenderUtils.resetColor();
    }

    public static void renderFluid(MatrixStack matrix, FluidTank fluidTank, int xPos, int yPos, int width, int height, int zOffset) {
        RenderUtils.renderFluid(matrix, fluidTank, 0, xPos, yPos, width, height, zOffset);
    }

    public static void renderFluid(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos, int width, int height, int zOffset) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStack.getFluid().getAttributes().getStillTexture());
        int color = fluidStack.getFluid().getAttributes().getColor();
        float red = RenderCuboid.getRed(color);
        float green = RenderCuboid.getGreen(color);
        float blue = RenderCuboid.getBlue(color);
        float alpha = RenderCuboid.getAlpha(color);
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        RenderUtils.drawTiledSprite(matrix, xPos, yPos, height, width, height, sprite, 16, 16, zOffset);
        RenderUtils.resetColor();
    }

    public static void renderFluid(MatrixStack matrix, FluidStack fluidStack, int xPos, int yPos, int zOffset) {
        RenderUtils.renderFluid(matrix, fluidStack, xPos, yPos, 16, 16, zOffset);
    }

    public static void renderEntity(MatrixStack matrixStack, Entity entity, World world, float x, float y, float rotation, float renderScale) {
        if (world == null) {
            return;
        }
        float scaledSize = 20.0f;
        Minecraft mc = Minecraft.func_71410_x();
        if (entity instanceof LivingEntity) {
            if (mc.field_71439_g != null) {
                entity.field_70173_aa = mc.field_71439_g.field_70173_aa;
            }
            scaledSize = entity instanceof CustomBeeEntity ? 20.0f / ((CustomBeeEntity)entity).getBeeData().getSizeModifier() : 20.0f / (entity.func_213311_cf() > entity.func_213302_cg() ? entity.func_213311_cf() : entity.func_213302_cg());
        }
        if (mc.field_71439_g != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(10.0, (double)(20.0f * renderScale), 0.5);
            matrixStack.func_227861_a_((double)x, (double)y, 1.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
            matrixStack.func_227862_a_(-(scaledSize * renderScale), scaledSize * renderScale, 30.0f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            EntityRendererManager entityrenderermanager = mc.func_175598_ae();
            IRenderTypeBuffer.Impl renderTypeBuffer = mc.func_228019_au_().func_228487_b_();
            entityrenderermanager.func_229084_a_(entity, 0.0, 0.0, 0.0, mc.func_184121_ak(), 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
            renderTypeBuffer.func_228461_a_();
        }
        matrixStack.func_227865_b_();
    }
}

