/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import org.jetbrains.annotations.Nullable;

public class RandomPositionGenerator {
    private RandomPositionGenerator() {
        throw new IllegalArgumentException("Utility Class");
    }

    @Nullable
    public static Vector3d findAirTarget(CreatureEntity creatureEntity, int i, int i1, Vector3d vector3d) {
        return RandomPositionGenerator.findTarget(creatureEntity, i, i1, 0, vector3d, false, arg_0 -> ((CreatureEntity)creatureEntity).func_180484_a(arg_0));
    }

    @Nullable
    public static Vector3d findGroundTarget(CreatureEntity creatureEntity, int i, int i1, int i2, @Nullable Vector3d vector3d) {
        return RandomPositionGenerator.findTarget(creatureEntity, i, i1, i2, vector3d, true, arg_0 -> ((CreatureEntity)creatureEntity).func_180484_a(arg_0));
    }

    @Nullable
    private static Vector3d findTarget(CreatureEntity bee, int horizontalOffset, int verticalOffset, int zero, @Nullable Vector3d vector3d, boolean pathOnWater, ToDoubleFunction<BlockPos> blockWeightOfBeePOS) {
        PathNavigator pathnavigator = bee.func_70661_as();
        Random random = bee.func_70681_au();
        boolean inDistanceOfHome = bee.func_213394_dL() && bee.func_213384_dI().func_218137_a((IPosition)bee.func_213303_ch(), (double)(bee.func_213391_dJ() + (float)horizontalOffset) + 1.0);
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos beePos = bee.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            double d1;
            PathNodeType pathnodetype;
            BlockPos targetPos;
            BlockPos randomBlockpos = RandomPositionGenerator.getRandomOffset(random, horizontalOffset, verticalOffset, zero, vector3d);
            if (randomBlockpos == null) continue;
            int rndPosX = randomBlockpos.func_177958_n();
            int rndPosY = randomBlockpos.func_177956_o();
            int rndPosZ = randomBlockpos.func_177952_p();
            if (bee.func_213394_dL() && horizontalOffset > 1) {
                BlockPos beeHomePosition = bee.func_213384_dI();
                int nextInt = random.nextInt(horizontalOffset / 2);
                rndPosX = bee.func_226277_ct_() > (double)beeHomePosition.func_177958_n() ? rndPosX - nextInt : rndPosX + nextInt;
                int nextInt1 = random.nextInt(horizontalOffset / 2);
                int n = rndPosZ = bee.func_226281_cx_() > (double)beeHomePosition.func_177952_p() ? rndPosZ - nextInt1 : rndPosZ + nextInt1;
            }
            if (!MathUtils.inRangeInclusive((targetPos = new BlockPos((double)rndPosX + bee.func_226277_ct_(), (double)rndPosY + bee.func_226278_cu_(), (double)rndPosZ + bee.func_226281_cx_())).func_177956_o(), 0, bee.field_70170_p.func_217301_I()) || inDistanceOfHome && !bee.func_213389_a(targetPos) || !pathnavigator.func_188555_b(targetPos)) continue;
            targetPos = random.nextBoolean() && bee.field_70170_p.func_175623_d(bee.func_233580_cy_().func_177984_a()) ? RandomPositionGenerator.findValidPositionAbove(targetPos, random.nextInt(3) + 1, bee.field_70170_p.func_217301_I(), pos -> bee.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a()) : RandomPositionGenerator.findValidPositionBelow(targetPos, random.nextInt(3) + 1, pos -> bee.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a());
            if (!pathOnWater && bee.field_70170_p.func_204610_c(targetPos).func_206884_a((ITag)FluidTags.field_206959_a) || bee.func_184643_a(pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)bee.field_70170_p, (BlockPos.Mutable)targetPos.func_239590_i_())) != 0.0f || !((d1 = blockWeightOfBeePOS.applyAsDouble(targetPos)) > d0)) continue;
            d0 = d1;
            beePos = targetPos;
            flag1 = true;
        }
        return flag1 ? Vector3d.func_237492_c_((Vector3i)beePos) : null;
    }

    private static BlockPos getRandomOffset(Random random, int horizontalOffset, int verticalOffset, int minusTwo, @Nullable Vector3d directionVec) {
        if (directionVec != null) {
            double d3 = MathHelper.func_181159_b((double)directionVec.field_72449_c, (double)directionVec.field_72450_a) - 1.5707963267948966;
            double d4 = d3 + (double)(2.0f * random.nextFloat() - 1.0f) * 1.5707963267948966;
            double d0 = Math.sqrt(random.nextDouble()) * (double)MathHelper.field_180189_a * (double)horizontalOffset;
            double d1 = -d0 * Math.sin(d4);
            double d2 = d0 * Math.cos(d4);
            if (Math.abs(d1) <= (double)horizontalOffset && Math.abs(d2) <= (double)horizontalOffset) {
                int l = random.nextInt(2 * verticalOffset + 1) - verticalOffset + minusTwo;
                return new BlockPos(d1, (double)l, d2);
            }
            return null;
        }
        int i = random.nextInt(2 * horizontalOffset + 1) - horizontalOffset;
        int j = random.nextInt(2 * verticalOffset + 1) - verticalOffset + minusTwo;
        int k = random.nextInt(2 * horizontalOffset + 1) - horizontalOffset;
        return new BlockPos(i, j, k);
    }

    static BlockPos findValidPositionAbove(BlockPos blockPos3, int randInt3, int worldHeight, Predicate<BlockPos> posPredicate) {
        BlockPos blockpos2;
        if (randInt3 < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + randInt3 + ", expected >= 0");
        }
        if (!posPredicate.test(blockPos3)) {
            return blockPos3;
        }
        BlockPos blockpos = blockPos3.func_177984_a();
        while (blockpos.func_177956_o() < worldHeight && posPredicate.test(blockpos)) {
            blockpos = blockpos.func_177984_a();
        }
        BlockPos blockpos1 = blockpos;
        while (blockpos1.func_177956_o() < worldHeight && blockpos1.func_177956_o() - blockpos.func_177956_o() < randInt3 && !posPredicate.test(blockpos2 = blockpos1.func_177984_a())) {
            blockpos1 = blockpos2;
        }
        return blockpos1;
    }

    static BlockPos findValidPositionBelow(BlockPos blockPos3, int randInt3, Predicate<BlockPos> posPredicate) {
        BlockPos blockpos2;
        if (randInt3 < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + randInt3 + ", expected >= 0");
        }
        if (!posPredicate.test(blockPos3)) {
            return blockPos3;
        }
        BlockPos blockpos = blockPos3.func_177977_b();
        while (blockpos.func_177956_o() > 0 && posPredicate.test(blockpos)) {
            blockpos = blockpos.func_177977_b();
        }
        BlockPos blockpos1 = blockpos;
        while (blockpos1.func_177956_o() > 0 && blockpos.func_177956_o() - blockpos1.func_177956_o() < randInt3 && !posPredicate.test(blockpos2 = blockpos1.func_177977_b())) {
            blockpos1 = blockpos2;
        }
        return blockpos1;
    }
}

