/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryBlock;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PreviewHandler {
    private static BlockPos apiaryPos = null;
    private static final List<BlockPos> STRUCTURE_PREVIEW_POS = new ArrayList<BlockPos>();
    private static boolean enabled;

    private PreviewHandler() {
        throw new IllegalStateException("Utility Class");
    }

    public static void setPreview(BlockPos apiary, MutableBoundingBox box, boolean enabled) {
        STRUCTURE_PREVIEW_POS.clear();
        if (enabled) {
            apiaryPos = apiary;
            BlockPos.func_229383_a_((MutableBoundingBox)box).forEach(blockPos -> {
                if (!(blockPos.func_177958_n() != box.field_78897_a && blockPos.func_177958_n() != box.field_78893_d && blockPos.func_177956_o() != box.field_78895_b && blockPos.func_177956_o() != box.field_78894_e && blockPos.func_177952_p() != box.field_78896_c && blockPos.func_177952_p() != box.field_78892_f || apiary.equals((Object)blockPos.func_185334_h()))) {
                    BlockPos savedPos = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                    STRUCTURE_PREVIEW_POS.add(savedPos);
                }
            });
        } else {
            apiaryPos = null;
        }
        PreviewHandler.enabled = enabled;
    }

    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MatrixStack ms = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder buffer = buffers.getBuffer(RenderType.func_228645_f_());
        if (apiaryPos != null && enabled) {
            if (world != null && world.func_180495_p(apiaryPos).func_177230_c() instanceof ApiaryBlock) {
                ApiaryTileEntity apiaryTE;
                if (world.func_175625_s(apiaryPos) instanceof ApiaryTileEntity && (apiaryTE = (ApiaryTileEntity)world.func_175625_s(apiaryPos)) != null && apiaryTE.isPreviewed()) {
                    for (BlockPos pos : STRUCTURE_PREVIEW_POS) {
                        if (world.func_180495_p(pos).equals(Blocks.field_150350_a.func_176223_P())) {
                            PreviewHandler.renderBlockAt(ms, buffer, ((Block)ModBlocks.PREVIEW_BLOCK.get()).func_176223_P(), pos);
                            continue;
                        }
                        if (BeeInfoUtils.getBlockTag("resourcefulbees:valid_apiary") == null || world.func_180495_p(pos).func_235714_a_(BeeInfoUtils.getBlockTag("resourcefulbees:valid_apiary"))) continue;
                        PreviewHandler.renderBlockAt(ms, buffer, ((Block)ModBlocks.ERRORED_PREVIEW_BLOCK.get()).func_176223_P(), pos);
                    }
                }
            } else {
                STRUCTURE_PREVIEW_POS.clear();
                apiaryPos = null;
                enabled = false;
            }
        }
        buffers.func_228462_a_(RenderType.func_228645_f_());
    }

    private static void renderBlockAt(MatrixStack ms, IVertexBuilder buffer, BlockState state, BlockPos pos) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-renderPosX, -renderPosY, -renderPosZ);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        IBakedModel model = brd.func_184389_a(state);
        int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        brd.func_175019_b().renderModel(ms.func_227866_c_(), buffer, state, model, r, g, b, 0xFFFFFF, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        ms.func_227865_b_();
    }
}

