/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.resourcefulbees.resourcefulbees.api.ICustomBee;
import com.resourcefulbees.resourcefulbees.api.beedata.BreedData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.fluids.HoneyFlowingFluid;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.item.CustomHoneyBottleItem;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.lib.BeeConstants;
import com.resourcefulbees.resourcefulbees.lib.LightLevels;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModFluids;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import com.resourcefulbees.resourcefulbees.utils.validation.ValidatorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeInfoUtils {
    private static final ResourceLocation VALID_APIARY = new ResourceLocation("resourcefulbees:valid_apiary");

    private BeeInfoUtils() {
        throw new IllegalStateException("Utility Class");
    }

    public static void buildFamilyTree(CustomBeeData bee) {
        if (bee.getBreedData().hasParents()) {
            Iterator parent1 = Splitter.on((String)",").trimResults().split((CharSequence)bee.getBreedData().getParent1()).iterator();
            Iterator parent2 = Splitter.on((String)",").trimResults().split((CharSequence)bee.getBreedData().getParent2()).iterator();
            while (parent1.hasNext() && parent2.hasNext()) {
                String p1 = (String)parent1.next();
                String p2 = (String)parent2.next();
                BeeRegistry.getRegistry().familyTree.computeIfAbsent(BeeInfoUtils.sortParents(p1, p2), k -> new RandomCollection()).add(bee.getBreedData().getBreedWeight(), bee);
            }
        }
        BeeRegistry.getRegistry().familyTree.computeIfAbsent((Pair<String, String>)Pair.of((Object)bee.getName(), (Object)bee.getName()), k -> new RandomCollection()).add(bee.getBreedData().getBreedWeight(), bee);
    }

    public static Pair<String, String> sortParents(String parent1, String parent2) {
        return parent1.compareTo(parent2) > 0 ? Pair.of((Object)parent1, (Object)parent2) : Pair.of((Object)parent2, (Object)parent1);
    }

    public static void parseBiomes(CustomBeeData bee) {
        if (!bee.getSpawnData().getBiomeWhitelist().isEmpty()) {
            HashSet<ResourceLocation> whitelist = new HashSet<ResourceLocation>(BeeInfoUtils.getBiomeSet(bee.getSpawnData().getBiomeWhitelist()));
            Set<ResourceLocation> blacklist = new HashSet<ResourceLocation>();
            if (!bee.getSpawnData().getBiomeBlacklist().isEmpty()) {
                blacklist = BeeInfoUtils.getBiomeSet(bee.getSpawnData().getBiomeBlacklist());
            }
            BeeInfoUtils.updateSpawnableBiomes(whitelist, blacklist, bee);
        }
    }

    private static Set<ResourceLocation> getBiomeSet(String list) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        if (list.contains("tag:")) {
            set.addAll(BeeInfoUtils.parseBiomeListFromTag(list));
        } else {
            set.addAll(BeeInfoUtils.parseBiomeList(list));
        }
        return set;
    }

    private static Set<ResourceLocation> parseBiomeListFromTag(String list) {
        HashSet<ResourceLocation> biomeSet = new HashSet<ResourceLocation>();
        if (((Boolean)Config.USE_FORGE_DICTIONARIES.get()).booleanValue()) {
            Splitter.on((String)",").trimResults().split((CharSequence)list.replace("tag:", "")).forEach(s -> BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).forEach(biomeRegistryKey -> biomeSet.add(biomeRegistryKey.func_240901_a_())));
        } else {
            Splitter.on((String)",").trimResults().split((CharSequence)list.replace("tag:", "")).forEach(s -> {
                if (com.resourcefulbees.resourcefulbees.registry.BiomeDictionary.getTypes().containsKey(s)) {
                    biomeSet.addAll((Collection)com.resourcefulbees.resourcefulbees.registry.BiomeDictionary.getTypes().get(s));
                }
            });
        }
        return biomeSet;
    }

    private static Set<ResourceLocation> parseBiomeList(String list) {
        HashSet<ResourceLocation> biomeSet = new HashSet<ResourceLocation>();
        Splitter.on((char)',').trimResults().split((CharSequence)list).forEach(s -> biomeSet.add(new ResourceLocation(s)));
        return biomeSet;
    }

    private static void updateSpawnableBiomes(Set<ResourceLocation> whitelist, Set<ResourceLocation> blacklist, CustomBeeData bee) {
        whitelist.stream().filter(resourceLocation -> !blacklist.contains(resourceLocation)).forEach(resourceLocation -> BeeRegistry.getSpawnableBiomes().computeIfAbsent((ResourceLocation)resourceLocation, k -> new RandomCollection()).add(bee.getSpawnData().getSpawnWeight(), bee));
    }

    public static ResourceLocation getResource(String resource) {
        return new ResourceLocation(resource);
    }

    public static boolean isValidBlock(Block block) {
        return block != null && block != Blocks.field_150350_a;
    }

    public static boolean isValidFluid(Fluid fluid) {
        return fluid != null && fluid != Fluids.field_204541_a;
    }

    public static boolean isValidItem(Item item) {
        return item != null && item != Items.field_190931_a;
    }

    public static boolean isValidEntityType(EntityType<?> entityType) {
        return entityType != null;
    }

    public static Item getItem(String itemName) {
        return (Item)ForgeRegistries.ITEMS.getValue(BeeInfoUtils.getResource(itemName));
    }

    public static Block getBlock(String blockName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(BeeInfoUtils.getResource(blockName));
    }

    public static Fluid getFluid(String fluidName) {
        return (Fluid)ForgeRegistries.FLUIDS.getValue(BeeInfoUtils.getResource(fluidName));
    }

    public static Biome getBiome(String biomeName) {
        return (Biome)ForgeRegistries.BIOMES.getValue(BeeInfoUtils.getResource(biomeName));
    }

    @Nullable
    public static EntityType<?> getEntityType(String entityName) {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(BeeInfoUtils.getResource(entityName));
    }

    @Nullable
    public static EntityType<?> getEntityType(ResourceLocation entityId) {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(entityId);
    }

    public static ITag<Item> getItemTag(String itemTag) {
        return ItemTags.func_199903_a().func_199910_a(BeeInfoUtils.getResource(itemTag));
    }

    public static ITag<Fluid> getFluidTag(String fluidTag) {
        return FluidTags.func_226157_a_().func_199910_a(BeeInfoUtils.getResource(fluidTag));
    }

    public static ITag<Block> getBlockTag(String blockTag) {
        return BlockTags.func_199896_a().func_199910_a(BeeInfoUtils.getResource(blockTag));
    }

    public static ITag<Block> getValidApiaryTag() {
        return BlockTags.func_199896_a().func_199910_a(VALID_APIARY);
    }

    public static void makeValidApiaryTag() {
        BlockTags.func_199894_a((String)"resourcefulbees:valid_apiary");
    }

    public static boolean isTag(String input) {
        if (ValidatorUtils.TAG_RESOURCE_PATTERN.matcher(input).matches()) {
            return true;
        }
        if (input.equals("tall")) {
            return true;
        }
        if (input.equals("small")) {
            return true;
        }
        return input.equals("all");
    }

    public static boolean isValidBreedItem(@NotNull ItemStack stack, BreedData breedData) {
        return breedData.getFeedItems().contains(stack.func_77973_b());
    }

    public static void flagBeesInRange(BlockPos pos, World world) {
        MutableBoundingBox box = MutableBoundingBox.func_175899_a((int)(pos.func_177958_n() + 10), (int)(pos.func_177956_o() + 10), (int)(pos.func_177952_p() + 10), (int)(pos.func_177958_n() - 10), (int)(pos.func_177956_o() - 10), (int)(pos.func_177952_p() - 10));
        AxisAlignedBB aabb = AxisAlignedBB.func_216363_a((MutableBoundingBox)box);
        if (world != null) {
            List list = world.func_217357_a(CustomBeeEntity.class, aabb);
            list.forEach(customBeeEntity -> customBeeEntity.setHasHiveInRange(true));
        }
    }

    public static List<String> getLoreLines(CompoundNBT outputNBT) {
        if (outputNBT.isEmpty()) {
            return new LinkedList<String>();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(outputNBT.toString());
        String nbtString = "NBT: " + gson.toJson(je);
        return Arrays.asList(nbtString.split("\n"));
    }

    public static boolean isShiftPressed() {
        long windowID = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)windowID, (int)340) || InputMappings.func_216506_a((long)windowID, (int)344);
    }

    public static TranslationTextComponent getSizeName(float sizeModifier) {
        if ((double)sizeModifier < 0.75) {
            return new TranslationTextComponent("bees.resourcefulbees.size.tiny");
        }
        if (sizeModifier < 1.0f) {
            return new TranslationTextComponent("bees.resourcefulbees.size.small");
        }
        if (sizeModifier == 1.0f) {
            return new TranslationTextComponent("bees.resourcefulbees.size.regular");
        }
        if ((double)sizeModifier <= 1.5) {
            return new TranslationTextComponent("bees.resourcefulbees.size.large");
        }
        return new TranslationTextComponent("bees.resourcefulbees.size.giant");
    }

    public static List<Block> getFlowers(String flower) {
        LinkedList<Block> flowers = new LinkedList<Block>();
        if (flower.equals("all")) {
            ITag.INamedTag itemTag = BlockTags.field_226149_I_;
            if (itemTag != null) {
                flowers.addAll(itemTag.func_230236_b_());
            }
        } else if (flower.equals("small")) {
            ITag.INamedTag itemTag = BlockTags.field_219746_E;
            if (itemTag != null) {
                flowers.addAll(itemTag.func_230236_b_());
            }
        } else if (flower.equals("tall")) {
            ITag.INamedTag itemTag = BlockTags.field_226148_H_;
            if (itemTag != null) {
                flowers.addAll(itemTag.func_230236_b_());
            }
        } else if (flower.startsWith("tag:")) {
            ITag<Block> itemTag = BeeInfoUtils.getBlockTag(flower.replace("tag:", ""));
            if (itemTag != null) {
                flowers.addAll(itemTag.func_230236_b_());
            }
        } else {
            flowers.add(BeeInfoUtils.getBlock(flower));
        }
        return flowers;
    }

    public static ITextComponent getYesNo(boolean bool) {
        if (bool) {
            return new TranslationTextComponent("gui.resourcefulbees.yes");
        }
        return new TranslationTextComponent("gui.resourcefulbees.no");
    }

    public static TranslationTextComponent getLightName(LightLevels light) {
        switch (light) {
            case DAY: {
                return new TranslationTextComponent("gui.resourcefulbees.light.day");
            }
            case NIGHT: {
                return new TranslationTextComponent("gui.resourcefulbees.light.night");
            }
        }
        return new TranslationTextComponent("gui.resourcefulbees.light.any");
    }

    public static List<ItemStack> getBreedItems(CustomBeeData parent1Data) {
        if (!parent1Data.getBreedData().hasFeedItems()) {
            return Collections.emptyList();
        }
        return parent1Data.getBreedData().getFeedItems().stream().map(f -> new ItemStack((IItemProvider)f, parent1Data.getBreedData().getFeedAmount())).collect(Collectors.toList());
    }

    public static void ageBee(int ticksInHive, BeeEntity beeEntity) {
        int i = beeEntity.func_70874_b();
        if (i < 0) {
            beeEntity.func_70873_a(Math.min(0, i + ticksInHive));
        } else if (i > 0) {
            beeEntity.func_70873_a(Math.max(0, i - ticksInHive));
        }
        if (beeEntity instanceof CustomBeeEntity) {
            ((CustomBeeEntity)beeEntity).setLoveTime(Math.max(0, beeEntity.func_234178_eO_() - ticksInHive));
        } else {
            beeEntity.func_204700_e(Math.max(0, beeEntity.func_234178_eO_() - ticksInHive));
        }
        beeEntity.func_226426_eu_();
    }

    public static void setEntityLocationAndAngle(BlockPos blockpos, Direction direction, Entity entity) {
        EntitySize size = entity.func_213305_a(Pose.STANDING);
        double d0 = 0.65 + (double)(size.field_220315_a / 2.0f);
        double d1 = (double)blockpos.func_177958_n() + 0.5 + d0 * (double)direction.func_82601_c();
        double d2 = (double)blockpos.func_177956_o() + Math.max(0.5 - (double)(size.field_220316_b / 2.0f), 0.0);
        double d3 = (double)blockpos.func_177952_p() + 0.5 + d0 * (double)direction.func_82599_e();
        entity.func_70012_b(d1, d2, d3, entity.field_70177_z, entity.field_70125_A);
    }

    @NotNull
    public static CompoundNBT createJarBeeTag(BeeEntity beeEntity, String nbtTagID) {
        String type = EntityType.func_200718_a((EntityType)beeEntity.func_200600_R()).toString();
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(nbtTagID, type);
        beeEntity.func_189511_e(nbt);
        String beeColor = "#edc343";
        if (beeEntity instanceof ICustomBee) {
            ICustomBee iCustomBee = (ICustomBee)beeEntity;
            nbt.func_74778_a("BeeType", iCustomBee.getBeeType());
            if (iCustomBee.getBeeData().getColorData().hasPrimaryColor()) {
                beeColor = iCustomBee.getBeeData().getColorData().getPrimaryColor();
            } else if (iCustomBee.getBeeData().getColorData().isRainbowBee()) {
                beeColor = "rainbow";
            } else if (iCustomBee.getBeeData().getColorData().hasHoneycombColor()) {
                beeColor = iCustomBee.getBeeData().getColorData().getHoneycombColor();
            }
        }
        nbt.func_74778_a("Color", beeColor);
        return nbt;
    }

    public static boolean isBeeInJarOurs(@NotNull ItemStack stack) {
        return stack.func_77973_b() instanceof BeeJar && BeeJar.isFilled(stack) && stack.func_77978_p().func_74779_i("Entity").startsWith("resourcefulbees");
    }

    public static Fluid getFluidFromBottle(ItemStack bottleOutput) {
        Item item = bottleOutput.func_77973_b();
        if (item == Items.field_226638_pX_) {
            return ((FlowingFluid)ModFluids.HONEY_STILL.get()).func_210198_f();
        }
        if (item == ModItems.CATNIP_HONEY_BOTTLE.get()) {
            return ((FlowingFluid)ModFluids.CATNIP_HONEY_STILL.get()).func_210198_f();
        }
        if (item instanceof CustomHoneyBottleItem) {
            CustomHoneyBottleItem honey = (CustomHoneyBottleItem)item;
            return ((FlowingFluid)honey.getHoneyData().getHoneyStillFluidRegistryObject().get()).func_210198_f();
        }
        return Fluids.field_204541_a;
    }

    public static Item getHoneyBottle(Fluid fluid) {
        if (fluid == ModFluids.CATNIP_HONEY_STILL.get()) {
            return (Item)ModItems.CATNIP_HONEY_BOTTLE.get();
        }
        if (fluid instanceof HoneyFlowingFluid) {
            HoneyFlowingFluid customfluid = (HoneyFlowingFluid)fluid;
            return (Item)customfluid.getHoneyData().getHoneyBottleRegistryObject().get();
        }
        return Items.field_226638_pX_;
    }

    public static Item getHoneyBucket(Fluid fluid) {
        if (fluid == ModFluids.CATNIP_HONEY_STILL.get()) {
            return (Item)ModItems.CATNIP_HONEY_FLUID_BUCKET.get();
        }
        if (fluid instanceof HoneyFlowingFluid) {
            HoneyFlowingFluid customfluid = (HoneyFlowingFluid)fluid;
            return (Item)customfluid.getHoneyData().getHoneyBucketItemRegistryObject().get();
        }
        return (Item)ModItems.HONEY_FLUID_BUCKET.get();
    }

    public static Item getHoneyBlock(Fluid fluid) {
        if (fluid == ModFluids.CATNIP_HONEY_STILL.get()) {
            return (Item)ModItems.CATNIP_HONEY_BLOCK_ITEM.get();
        }
        if (fluid instanceof HoneyFlowingFluid) {
            HoneyFlowingFluid customfluid = (HoneyFlowingFluid)fluid;
            if (!customfluid.getHoneyData().doGenerateHoneyBlock()) {
                return Items.field_190931_a;
            }
            return (Item)customfluid.getHoneyData().getHoneyBlockItemRegistryObject().get();
        }
        return Items.field_226639_pY_;
    }

    public static Predicate<FluidStack> getHoneyPredicate() {
        return fluidStack -> fluidStack.getFluid().func_207185_a(BeeInfoUtils.getFluidTag("forge:honey"));
    }

    public static ApiaryOutput[] getDefaultApiaryTypes() {
        return new ApiaryOutput[]{(ApiaryOutput)((Object)Config.T1_APIARY_OUTPUT.get()), (ApiaryOutput)((Object)Config.T2_APIARY_OUTPUT.get()), (ApiaryOutput)((Object)Config.T3_APIARY_OUTPUT.get()), (ApiaryOutput)((Object)Config.T4_APIARY_OUTPUT.get())};
    }

    public static List<ITextComponent> getBeeLore(EntityType<?> entityType, World world) {
        Entity entity = entityType.func_200721_a(world);
        if (entity instanceof CustomBeeEntity) {
            return BeeInfoUtils.getBeeLore(((CustomBeeEntity)entity).getBeeData());
        }
        return new ArrayList<ITextComponent>();
    }

    public static List<ITextComponent> getBeeLore(Entity entity) {
        if (entity instanceof CustomBeeEntity) {
            return BeeInfoUtils.getBeeLore(((CustomBeeEntity)entity).getBeeData());
        }
        return new ArrayList<ITextComponent>();
    }

    public static List<ITextComponent> getBeeLore(CustomBeeData beeData) {
        LinkedList<ITextComponent> tooltip = new LinkedList<ITextComponent>();
        if (beeData.getLore() != null && !beeData.getLore().isEmpty()) {
            String[] loreTooltip;
            String lore = beeData.getLore();
            for (String s : loreTooltip = lore.split("\\r?\\n")) {
                tooltip.add((ITextComponent)new StringTextComponent(s).func_240703_c_(beeData.getLoreColor()));
            }
        }
        if (beeData.getCreator() != null && !beeData.getLore().isEmpty()) {
            tooltip.add((ITextComponent)BeeConstants.CREATOR_LORE_PREFIX.func_230532_e_().func_240702_b_(beeData.getCreator()).func_240699_a_(TextFormatting.GRAY));
        }
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

