/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge;

import com.resourcefulbees.resourcefulbees.block.multiblocks.centrifuge.EliteCentrifugeCasingBlock;
import com.resourcefulbees.resourcefulbees.capabilities.CustomEnergyStorage;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.EliteCentrifugeMultiblockContainer;
import com.resourcefulbees.resourcefulbees.registry.ModContainers;
import com.resourcefulbees.resourcefulbees.tileentity.CentrifugeTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge.CentrifugeControllerTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge.EliteCentrifugeCasingTileEntity;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EliteCentrifugeControllerTileEntity
extends CentrifugeControllerTileEntity {
    private static final int INPUTS = 6;
    private static final int TANK_CAPACITY = 50000;
    private final IIntArray times = new CentrifugeTileEntity.TimesArray(6);

    public EliteCentrifugeControllerTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Override
    public int getNumberOfInputs() {
        return 6;
    }

    @Override
    public int getMaxTankCapacity() {
        return 50000;
    }

    @Override
    public int getRecipeTime(int i) {
        return this.getRecipe(i) != null ? Math.max(5, (int)((double)this.getRecipe((int)i).multiblockTime * 0.5)) : (Integer)Config.GLOBAL_CENTRIFUGE_RECIPE_TIME.get();
    }

    @Override
    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage((Integer)Config.MAX_CENTRIFUGE_RF.get() * 10, 1000, 0){

            @Override
            protected void onEnergyChanged() {
                EliteCentrifugeControllerTileEntity.this.func_70296_d();
            }
        };
    }

    @Override
    protected Predicate<BlockPos> validBlocks() {
        return blockPos -> {
            assert (this.field_145850_b != null) : "Validating Centrifuge - How is world null??";
            Block block = this.field_145850_b.func_180495_p(blockPos).func_177230_c();
            TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
            if (block instanceof EliteCentrifugeCasingBlock && tileEntity instanceof EliteCentrifugeCasingTileEntity) {
                EliteCentrifugeCasingTileEntity casing = (EliteCentrifugeCasingTileEntity)tileEntity;
                return !casing.isLinked() || casing.getController() != null && ((Object)((Object)casing.getController())).equals((Object)this);
            }
            return false;
        };
    }

    @Override
    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new EliteCentrifugeMultiblockContainer((ContainerType)ModContainers.ELITE_CENTRIFUGE_MULTIBLOCK_CONTAINER.get(), id, this.field_145850_b, this.field_174879_c, playerInventory, this.times);
    }
}

