/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge;

import com.resourcefulbees.resourcefulbees.block.multiblocks.centrifuge.CentrifugeCasingBlock;
import com.resourcefulbees.resourcefulbees.block.multiblocks.centrifuge.CentrifugeControllerBlock;
import com.resourcefulbees.resourcefulbees.capabilities.CustomEnergyStorage;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.CentrifugeMultiblockContainer;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.ModContainers;
import com.resourcefulbees.resourcefulbees.tileentity.CentrifugeTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.MultiBlockHelper;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge.CentrifugeCasingTileEntity;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CentrifugeControllerTileEntity
extends CentrifugeTileEntity {
    private static final int TANK_CAPACITY = 10000;
    private static final int INPUTS = 3;
    protected int validateTime = MathUtils.nextInt(10) + 10;
    protected boolean validStructure;
    protected final List<BlockPos> structureBlocks = new ArrayList<BlockPos>();
    private final IIntArray times = new CentrifugeTileEntity.TimesArray(3);

    public CentrifugeControllerTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Override
    public int getNumberOfInputs() {
        return 3;
    }

    public void checkHoneycombSlots() {
        for (int i = 0; i < this.honeycombSlots.length; ++i) {
            this.recipes.set(i, this.getRecipe(i));
            if (this.canStartCentrifugeProcess(i)) {
                this.isProcessing[i] = true;
            }
            if (this.isProcessing[i] && !this.processCompleted[i]) {
                this.processRecipe(i);
            }
            if (!this.processCompleted[i]) continue;
            this.completeProcess(i);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (this.isValidStructure() && (!this.requiresRedstone || this.isPoweredByRedstone)) {
                this.checkHoneycombSlots();
            }
            ++this.validateTime;
            if (this.validateTime >= 20) {
                this.validateStructure(this.field_145850_b);
            }
            if (this.dirty) {
                this.dirty = false;
                this.func_70296_d();
            }
        }
    }

    @Override
    public int getMaxTankCapacity() {
        return 10000;
    }

    @Override
    public int getRecipeTime(int i) {
        return this.getRecipe(i) != null ? Math.max(5, this.getRecipe((int)i).multiblockTime) : (Integer)Config.GLOBAL_CENTRIFUGE_RECIPE_TIME.get();
    }

    @Override
    protected boolean canProcessRecipe(int i) {
        return this.recipes.get(i) != null && ((Boolean)Config.MULTIBLOCK_RECIPES_ONLY.get() == false || ((CentrifugeRecipe)this.recipes.get((int)i)).multiblock);
    }

    @Override
    protected void setPoweredBlockState(boolean powered) {
    }

    @Override
    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT tag) {
        super.func_189515_b(tag);
        return this.saveToNBT(tag);
    }

    @Override
    protected CompoundNBT saveToNBT(CompoundNBT tag) {
        tag.func_74757_a("valid", this.validStructure);
        return super.saveToNBT(tag);
    }

    @Override
    protected void loadFromNBT(CompoundNBT tag) {
        this.validStructure = tag.func_74767_n("valid");
        super.loadFromNBT(tag);
    }

    @Override
    public void dropInventory(World world, @NotNull BlockPos pos) {
    }

    @Override
    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new CentrifugeMultiblockContainer((ContainerType)ModContainers.CENTRIFUGE_MULTIBLOCK_CONTAINER.get(), id, this.field_145850_b, this.field_174879_c, playerInventory, this.times);
    }

    @Override
    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.centrifuge");
    }

    @Override
    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage((Integer)Config.MAX_CENTRIFUGE_RF.get() * 5, 500, 0){

            @Override
            protected void onEnergyChanged() {
                CentrifugeControllerTileEntity.this.func_70296_d();
            }
        };
    }

    protected MutableBoundingBox getBounds() {
        return MultiBlockHelper.buildStructureBounds(this.func_174877_v(), 3, 4, 3, -1, -1, -2, (Direction)this.func_195044_w().func_177229_b((Property)CentrifugeControllerBlock.FACING));
    }

    protected Predicate<BlockPos> validBlocks() {
        return blockPos -> {
            assert (this.field_145850_b != null) : "Validating Centrifuge - How is world null??";
            Block block = this.field_145850_b.func_180495_p(blockPos).func_177230_c();
            TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
            if (block instanceof CentrifugeCasingBlock && tileEntity instanceof CentrifugeCasingTileEntity) {
                CentrifugeCasingTileEntity casing = (CentrifugeCasingTileEntity)tileEntity;
                return !casing.isLinked() || casing.getController() != null && ((Object)((Object)casing.getController())).equals((Object)this);
            }
            return false;
        };
    }

    protected void validateStructure(World world) {
        this.validateTime = 0;
        MultiBlockHelper.buildStructureList(this.getBounds(), this.structureBlocks, blockPos -> true, this.func_174877_v());
        this.validStructure = MultiBlockHelper.validateStructure(this.structureBlocks, this.validBlocks(), 35);
        world.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CentrifugeControllerBlock.PROPERTY_VALID, (Comparable)Boolean.valueOf(this.validStructure)));
        if (this.validStructure) {
            this.linkCasings(world);
        }
    }

    protected void linkCasings(World world) {
        if (!world.field_72995_K) {
            this.structureBlocks.stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).filter(CentrifugeCasingTileEntity.class::isInstance).forEach(tileEntity -> ((CentrifugeCasingTileEntity)((Object)tileEntity)).setControllerPos(this.field_174879_c));
        }
    }

    protected void unlinkCasings(World world) {
        if (!world.field_72995_K) {
            this.structureBlocks.stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).filter(CentrifugeCasingTileEntity.class::isInstance).forEach(tileEntity -> ((CentrifugeCasingTileEntity)((Object)tileEntity)).setControllerPos(null));
        }
    }

    public void invalidateStructure() {
        assert (this.field_145850_b != null);
        this.validStructure = false;
        this.unlinkCasings(this.field_145850_b);
    }

    public boolean isValidStructure() {
        return this.validStructure;
    }

    public void func_145843_s() {
        assert (this.field_145850_b != null);
        this.unlinkCasings(this.field_145850_b);
        super.func_145843_s();
    }
}

