/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary;

import com.resourcefulbees.resourcefulbees.api.ICustomBee;
import com.resourcefulbees.resourcefulbees.block.HoneyGlass;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryBlock;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.container.UnvalidatedApiaryContainer;
import com.resourcefulbees.resourcefulbees.container.ValidatedApiaryContainer;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.lib.ApiaryTabs;
import com.resourcefulbees.resourcefulbees.mixin.BlockAccessor;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.UpdateClientApiaryMessage;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.MultiBlockHelper;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryBreederTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryStorageTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.IApiaryMultiblock;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiaryTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
IApiaryMultiblock {
    public static final int IMPORT = 0;
    public static final int EXPORT = 2;
    public static final int EMPTY_JAR = 1;
    public final Map<String, ApiaryBee> bees = new LinkedHashMap<String, ApiaryBee>();
    private final List<BlockPos> structureBlocks = new ArrayList<BlockPos>();
    protected int tier;
    private boolean isValidApiary;
    private boolean previewed;
    private final TileStackHandler tileStackHandler = new TileStackHandler(3);
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getTileStackHandler);
    private int horizontalOffset = 0;
    private int verticalOffset = 0;
    private int numPlayersUsing;
    private int ticksSinceValidation;
    private int ticksSinceSync;
    private BlockPos storagePos;
    private BlockPos breederPos;
    private ApiaryStorageTileEntity apiaryStorage;
    private ApiaryBreederTileEntity apiaryBreeder;
    protected int ticksSinceBeesFlagged;

    public ApiaryTileEntity() {
        super((TileEntityType)ModTileEntityTypes.APIARY_TILE_ENTITY.get());
    }

    public ApiaryTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public static int calculatePlayersUsingSync(World world, ApiaryTileEntity apiaryTileEntity, int ticksSinceSync, int posX, int posY, int posZ, int numPlayersUsing) {
        if (!world.field_72995_K && numPlayersUsing != 0 && (ticksSinceSync + posX + posY + posZ) % 200 == 0) {
            numPlayersUsing = ApiaryTileEntity.calculatePlayersUsing(world, apiaryTileEntity, posX, posY, posZ);
        }
        return numPlayersUsing;
    }

    public static int calculatePlayersUsing(World world, ApiaryTileEntity apiaryTileEntity, int posX, int posY, int posZ) {
        int i = 0;
        float f = 5.0f;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)posX - f), (double)((float)posY - f), (double)((float)posZ - f), (double)((float)(posX + 1) + f), (double)((float)(posY + 1) + f), (double)((float)(posZ + 1) + f)))) {
            ApiaryTileEntity apiaryTileEntity1;
            if (!(playerentity.field_71070_bA instanceof ValidatedApiaryContainer) || (apiaryTileEntity1 = ((ValidatedApiaryContainer)playerentity.field_71070_bA).getApiaryTileEntity()) != apiaryTileEntity) continue;
            ++i;
        }
        return i;
    }

    public static void syncApiaryToPlayersUsing(World world, BlockPos pos, CompoundNBT data) {
        NetPacketHandler.sendToAllLoaded(new UpdateClientApiaryMessage(pos, data), world, pos);
    }

    public boolean isValidApiary(boolean runValidation) {
        if (runValidation) {
            this.runStructureValidation(null);
        }
        return this.isValidApiary;
    }

    public int getTier() {
        return this.tier;
    }

    public int getMaxBees() {
        return (Integer)Config.APIARY_MAX_BEES.get();
    }

    public int getBeeCount() {
        return this.bees.size();
    }

    public ApiaryStorageTileEntity getApiaryStorage() {
        TileEntity tile;
        if (this.field_145850_b != null && this.getStoragePos() != null && (tile = this.field_145850_b.func_175625_s(this.getStoragePos())) instanceof ApiaryStorageTileEntity) {
            return (ApiaryStorageTileEntity)tile;
        }
        this.setStoragePos(null);
        return null;
    }

    public ApiaryBreederTileEntity getApiaryBreeder() {
        TileEntity tile;
        if (this.field_145850_b != null && this.getBreederPos() != null && (tile = this.field_145850_b.func_175625_s(this.getBreederPos())) instanceof ApiaryBreederTileEntity) {
            return (ApiaryBreederTileEntity)tile;
        }
        this.setBreederPos(null);
        return null;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean releaseBee(@NotNull BlockState state, ApiaryBee apiaryBee, boolean exportBee) {
        BlockPos blockPos = this.func_174877_v();
        Direction direction = (Direction)state.func_177229_b((Property)BeehiveBlock.field_226872_b_);
        BlockPos blockPos1 = blockPos.func_177972_a(direction);
        CompoundNBT nbt = apiaryBee.entityData;
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(blockPos1).func_196952_d((IBlockReader)this.field_145850_b, blockPos1).func_197766_b()) {
            nbt.func_82580_o("Passengers");
            nbt.func_82580_o("Leash");
            nbt.func_82580_o("UUID");
            Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)this.field_145850_b, entity1 -> entity1);
            if (entity == null) {
                return true;
            }
            BeeInfoUtils.setEntityLocationAndAngle(blockPos, direction, entity);
            if (entity instanceof BeeEntity) {
                BeeEntity vanillaBeeEntity = (BeeEntity)entity;
                if (nbt.func_74767_n("HasNectar")) {
                    vanillaBeeEntity.func_226413_eG_();
                    if (!exportBee && this.isValidApiary(true)) {
                        this.getApiaryStorage().deliverHoneycomb((BeeEntity)entity, this.getTier());
                    }
                }
                this.ageBee(apiaryBee.getTicksInHive(), vanillaBeeEntity);
                if (exportBee) {
                    this.exportBee(vanillaBeeEntity);
                } else {
                    BlockPos hivePos = this.func_174877_v();
                    this.field_145850_b.func_184148_a(null, (double)hivePos.func_177958_n(), (double)hivePos.func_177956_o(), (double)hivePos.func_177952_p(), SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.field_145850_b.func_217376_c(entity);
                }
            }
            return true;
        }
        return false;
    }

    private void ageBee(int ticksInHive, BeeEntity beeEntity) {
        BeeInfoUtils.ageBee(ticksInHive, beeEntity);
    }

    public boolean tryEnterHive(Entity bee, boolean hasNectar, boolean imported) {
        if (this.isValidApiary(true)) {
            return this.tryEnterHive(bee, hasNectar, 0, imported);
        }
        return false;
    }

    public boolean tryEnterHive(@NotNull Entity bee, boolean hasNectar, int ticksInHive, boolean imported) {
        if (this.field_145850_b != null && bee instanceof BeeEntity) {
            String type = "minecraft";
            String beeColor = "#edc343";
            if (bee instanceof ICustomBee) {
                type = ((ICustomBee)bee).getBeeType();
            }
            if (!this.bees.containsKey(type) && this.bees.size() < this.getMaxBees()) {
                bee.func_184226_ay();
                CompoundNBT nbt = new CompoundNBT();
                bee.func_70039_c(nbt);
                int maxTimeInHive = this.getMaxTimeInHive(2400);
                if (bee instanceof ICustomBee) {
                    ICustomBee iCustomBee = (ICustomBee)bee;
                    maxTimeInHive = this.getMaxTimeInHive(iCustomBee.getBeeData().getMaxTimeInHive());
                    if (iCustomBee.getBeeData().getColorData().hasPrimaryColor()) {
                        beeColor = iCustomBee.getBeeData().getColorData().getPrimaryColor();
                    } else if (iCustomBee.getBeeData().getColorData().isRainbowBee()) {
                        beeColor = "rainbow";
                    } else if (iCustomBee.getBeeData().getColorData().hasHoneycombColor()) {
                        beeColor = iCustomBee.getBeeData().getColorData().getHoneycombColor();
                    }
                }
                int finalMaxTimeInHive = maxTimeInHive;
                String finalType = type;
                String finalBeeColor = beeColor;
                ITextComponent displayName = bee.func_200200_C_();
                this.bees.computeIfAbsent(finalType, k -> new ApiaryBee(nbt, ticksInHive, hasNectar ? finalMaxTimeInHive : 600, finalType, finalBeeColor, displayName));
                BlockPos pos = this.func_174877_v();
                this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (imported) {
                    this.bees.get(type).setLocked(true);
                }
                if (this.getNumPlayersUsing() > 0) {
                    ApiaryTileEntity.syncApiaryToPlayersUsing(this.field_145850_b, this.func_174877_v(), this.saveToNBT(new CompoundNBT()));
                }
                bee.func_70106_y();
                return true;
            }
        }
        return false;
    }

    private int getMaxTimeInHive(int timeInput) {
        if (this.tier != 1) {
            if (this.tier == 0) {
                return (int)((double)timeInput * 1.05);
            }
            return (int)((double)timeInput * (1.0 - (double)this.getTier() * 0.05));
        }
        return timeInput;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            BlockPos blockpos = this.func_174877_v();
            int x = blockpos.func_177958_n();
            int y = blockpos.func_177956_o();
            int z = blockpos.func_177952_p();
            ++this.ticksSinceSync;
            this.setNumPlayersUsing(ApiaryTileEntity.calculatePlayersUsingSync(this.field_145850_b, this, this.ticksSinceSync, x, y, z, this.getNumPlayersUsing()));
            this.tickBees();
            if (!this.field_145850_b.field_72995_K && this.isValidApiary) {
                if (this.ticksSinceValidation >= 20) {
                    this.runStructureValidation(null);
                } else {
                    ++this.ticksSinceValidation;
                }
                if (this.bees.size() > 0 && this.field_145850_b.func_201674_k().nextDouble() < 0.005) {
                    double d0 = (double)blockpos.func_177958_n() + 0.5;
                    double d1 = blockpos.func_177956_o();
                    double d2 = (double)blockpos.func_177952_p() + 0.5;
                    this.field_145850_b.func_184148_a(null, d0, d1, d2, SoundEvents.field_226134_ai_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                ++this.ticksSinceBeesFlagged;
                if (this.ticksSinceBeesFlagged == 80) {
                    BeeInfoUtils.flagBeesInRange(this.field_174879_c, this.field_145850_b);
                    this.ticksSinceBeesFlagged = 0;
                }
            }
        }
    }

    private void tickBees() {
        if (this.field_145850_b != null) {
            Iterator<Map.Entry<String, ApiaryBee>> iterator = this.bees.entrySet().iterator();
            BlockState blockstate = this.func_195044_w();
            while (iterator.hasNext()) {
                Map.Entry<String, ApiaryBee> element = iterator.next();
                ApiaryBee apiaryBee = element.getValue();
                if (!apiaryBee.isLocked() && apiaryBee.getTicksInHive() > apiaryBee.minOccupationTicks && !this.field_145850_b.field_72995_K) {
                    if (!this.releaseBee(blockstate, apiaryBee, false)) continue;
                    iterator.remove();
                    if (this.getNumPlayersUsing() <= 0 || this.field_145850_b.field_72995_K) continue;
                    ApiaryTileEntity.syncApiaryToPlayersUsing(this.field_145850_b, this.func_174877_v(), this.saveToNBT(new CompoundNBT()));
                    continue;
                }
                apiaryBee.setTicksInHive(apiaryBee.getTicksInHive() + 1);
                apiaryBee.setTicksInHive(Math.min(apiaryBee.getTicksInHive(), 0x7FFFFFFE));
            }
        }
    }

    public boolean isFullOfBees() {
        return this.bees.size() >= this.getMaxBees();
    }

    public boolean isAllowedBee() {
        Block hive = this.func_195044_w().func_177230_c();
        return this.isValidApiary(false) && hive instanceof ApiaryBlock;
    }

    public void lockOrUnlockBee(String beeType) {
        this.bees.get(beeType).setLocked(!this.bees.get(beeType).isLocked());
        ApiaryTileEntity.syncApiaryToPlayersUsing(this.field_145850_b, this.func_174877_v(), this.saveToNBT(new CompoundNBT()));
    }

    @NotNull
    public ListNBT writeBees() {
        ListNBT listnbt = new ListNBT();
        this.bees.forEach((key, apiaryBee) -> {
            apiaryBee.entityData.func_82580_o("UUID");
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_218657_a("EntityData", (INBT)apiaryBee.entityData);
            compoundnbt.func_74768_a("TicksInHive", apiaryBee.getTicksInHive());
            compoundnbt.func_74768_a("MinOccupationTicks", apiaryBee.minOccupationTicks);
            compoundnbt.func_74757_a("Locked", apiaryBee.isLocked());
            compoundnbt.func_74778_a("BeeType", apiaryBee.beeType);
            compoundnbt.func_74778_a("Color", apiaryBee.beeColor);
            compoundnbt.func_74778_a("DisplayName", ITextComponent.Serializer.func_150696_a((ITextComponent)apiaryBee.displayName));
            listnbt.add((Object)compoundnbt);
        });
        return listnbt;
    }

    public void loadBees(CompoundNBT nbt) {
        ListNBT listnbt = nbt.func_150295_c("Bees", 10);
        if (!listnbt.isEmpty()) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT data = listnbt.func_150305_b(i);
                String beeType = data.func_74779_i("BeeType");
                String beeColor = data.func_74764_b("Color") ? data.func_74779_i("Color") : "#edc343";
                StringTextComponent displayName = data.func_74764_b("DisplayName") ? ITextComponent.Serializer.func_240643_a_((String)data.func_74779_i("DisplayName")) : new StringTextComponent("Temp Bee Name");
                this.bees.computeIfAbsent(data.func_74779_i("BeeType"), arg_0 -> ApiaryTileEntity.lambda$loadBees$3(data, beeType, beeColor, (ITextComponent)displayName, arg_0));
                this.bees.get(beeType).setLocked(data.func_74767_n("Locked"));
            }
        }
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadFromNBT(nbt);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        return this.saveToNBT(nbt);
    }

    public void loadFromNBT(CompoundNBT nbt) {
        this.loadBees(nbt);
        if (nbt.func_74764_b("isValid")) {
            this.isValidApiary = nbt.func_74767_n("isValid");
        }
        if (nbt.func_74764_b("verticalOffset")) {
            this.setVerticalOffset(nbt.func_74762_e("verticalOffset"));
        }
        if (nbt.func_74764_b("horizontalOffset")) {
            this.setHorizontalOffset(nbt.func_74762_e("horizontalOffset"));
        }
        CompoundNBT invTag = nbt.func_74775_l("inv");
        this.getTileStackHandler().deserializeNBT(invTag);
        if (nbt.func_74764_b("StoragePos")) {
            this.setStoragePos(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("StoragePos")));
        }
        if (nbt.func_74764_b("BreederPos")) {
            this.setBreederPos(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("BreederPos")));
        }
        if (nbt.func_74764_b("Tier")) {
            this.setTier(nbt.func_74762_e("Tier"));
        }
        this.validateBees();
    }

    private void validateBees() {
        if (this.field_145850_b == null) {
            return;
        }
        this.bees.forEach((s, apiaryBee) -> {
            String id = apiaryBee.entityData.func_74779_i("id");
            EntityType<?> type = BeeInfoUtils.getEntityType(id);
            if (type == EntityType.field_200784_X) {
                this.bees.remove(s);
            }
        });
    }

    public CompoundNBT saveToNBT(CompoundNBT nbt) {
        CompoundNBT inv = this.getTileStackHandler().serializeNBT();
        nbt.func_218657_a("inv", (INBT)inv);
        nbt.func_218657_a("Bees", (INBT)this.writeBees());
        nbt.func_74757_a("isValid", this.isValidApiary);
        nbt.func_74768_a("verticalOffset", this.getVerticalOffset());
        nbt.func_74768_a("horizontalOffset", this.getHorizontalOffset());
        if (this.getStoragePos() != null) {
            nbt.func_218657_a("StoragePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getStoragePos()));
        }
        if (this.getBreederPos() != null) {
            nbt.func_218657_a("BreederPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBreederPos()));
        }
        nbt.func_74768_a("Tier", this.getTier());
        return nbt;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return super.func_189518_D_();
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(@NotNull BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void importBee(ServerPlayerEntity player) {
        World world = this.field_145850_b;
        boolean imported = false;
        if (world != null && !this.getTileStackHandler().getStackInSlot(0).func_190926_b() && this.getTileStackHandler().getStackInSlot(1).func_190916_E() < 16) {
            ItemStack filledJar = this.getTileStackHandler().getStackInSlot(0);
            ItemStack emptyJar = this.getTileStackHandler().getStackInSlot(1);
            if (filledJar.func_77973_b() instanceof BeeJar) {
                BeeEntity beeEntity;
                BeeJar jarItem = (BeeJar)filledJar.func_77973_b();
                Entity entity = BeeJar.getEntityFromStack(filledJar, world, true);
                if (entity instanceof BeeEntity && (imported = this.tryEnterHive((Entity)(beeEntity = (BeeEntity)entity), beeEntity.func_226411_eD_(), true))) {
                    filledJar.func_190918_g(1);
                    if (emptyJar.func_190926_b()) {
                        this.getTileStackHandler().setStackInSlot(1, new ItemStack((IItemProvider)jarItem));
                    } else {
                        emptyJar.func_190917_f(1);
                    }
                }
            }
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.apiary.import." + imported), true);
    }

    public void exportBee(ServerPlayerEntity player, String beeType) {
        boolean exported = false;
        ApiaryBee bee = this.bees.get(beeType);
        if (bee.isLocked() && this.getTileStackHandler().getStackInSlot(2).func_190926_b() && !this.getTileStackHandler().getStackInSlot(1).func_190926_b()) {
            exported = this.releaseBee(this.func_195044_w(), bee, true);
        }
        if (exported) {
            this.bees.remove(beeType);
            this.getTileStackHandler().getStackInSlot(1).func_190918_g(1);
            if (this.getNumPlayersUsing() > 0 && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                ApiaryTileEntity.syncApiaryToPlayersUsing(this.field_145850_b, this.func_174877_v(), this.saveToNBT(new CompoundNBT()));
            }
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.apiary.export." + exported), true);
    }

    public void exportBee(BeeEntity beeEntity) {
        ItemStack beeJar = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
        beeJar.func_77982_d(BeeInfoUtils.createJarBeeTag(beeEntity, "Entity"));
        BeeJar.renameJar(beeJar, beeEntity);
        this.getTileStackHandler().setStackInSlot(2, beeJar);
    }

    public void runStructureValidation(@Nullable ServerPlayerEntity validatingPlayer) {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (!this.isValidApiary || this.structureBlocks.isEmpty()) {
                this.buildStructureBlockList();
            }
            this.isValidApiary = this.validateStructure(this.field_145850_b, validatingPlayer);
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)ApiaryBlock.VALIDATED, (Comparable)Boolean.valueOf(this.isValidApiary)));
            if (validatingPlayer != null && this.isValidApiary) {
                NetworkHooks.openGui((ServerPlayerEntity)validatingPlayer, (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
            this.ticksSinceValidation = 0;
        }
    }

    public boolean validateStructure(World worldIn, @Nullable ServerPlayerEntity validatingPlayer) {
        AtomicBoolean isStructureValid = new AtomicBoolean(true);
        this.apiaryStorage = this.getApiaryStorage();
        this.apiaryBreeder = this.getApiaryBreeder();
        this.validateLinks();
        isStructureValid.set(this.validateBlocks(isStructureValid, worldIn, validatingPlayer));
        if (this.apiaryStorage == null) {
            isStructureValid.set(false);
            if (validatingPlayer != null) {
                validatingPlayer.func_146105_b((ITextComponent)new StringTextComponent("Missing Apiary Storage Block!"), false);
            }
        }
        if (validatingPlayer != null) {
            validatingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.apiary.validated." + isStructureValid.get()), true);
        }
        return isStructureValid.get();
    }

    private boolean validateBlocks(AtomicBoolean isStructureValid, World worldIn, @Nullable ServerPlayerEntity validatingPlayer) {
        this.structureBlocks.forEach(pos -> {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            if (((BlockAccessor)block).getHasCollision() || block.func_203417_a(BeeInfoUtils.getValidApiaryTag()) || block instanceof HoneyGlass) {
                TileEntity tile = worldIn.func_175625_s(pos);
                this.linkStorageAndBreeder(tile);
            } else {
                isStructureValid.set(false);
                if (validatingPlayer != null) {
                    validatingPlayer.func_146105_b((ITextComponent)new StringTextComponent(String.format("Block at position (X: %1$s Y: %2$s Z: %3$s) is invalid!", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), false);
                }
            }
        });
        return isStructureValid.get();
    }

    public MutableBoundingBox buildStructureBounds(int horizontalOffset, int verticalOffset) {
        return MultiBlockHelper.buildStructureBounds(this.func_174877_v(), 7, 5, 7, -horizontalOffset - 3, -verticalOffset - 1, 0, (Direction)this.func_195044_w().func_177229_b((Property)ApiaryBlock.FACING));
    }

    private void buildStructureBlockList() {
        if (this.field_145850_b != null) {
            MutableBoundingBox box = this.buildStructureBounds(this.getHorizontalOffset(), this.getVerticalOffset());
            this.structureBlocks.clear();
            BlockPos.func_229383_a_((MutableBoundingBox)box).filter(blockPos -> ApiaryTileEntity.isStructurePosition(blockPos, box)).forEach(blockPos -> this.structureBlocks.add(blockPos.func_185334_h()));
        }
    }

    private static boolean isStructurePosition(BlockPos blockPos, MutableBoundingBox box) {
        return blockPos.func_177958_n() == box.field_78897_a || blockPos.func_177958_n() == box.field_78893_d || blockPos.func_177956_o() == box.field_78894_e || blockPos.func_177952_p() == box.field_78896_c || blockPos.func_177952_p() == box.field_78892_f;
    }

    public void runCreativeBuild(ServerPlayerEntity player) {
        if (this.field_145850_b != null) {
            this.buildStructureBlockList();
            AtomicBoolean addedStorage = new AtomicBoolean(false);
            this.structureBlocks.stream().filter(this::blockAtPosIsNotApiary).forEach(blockPos -> {
                if (addedStorage.get()) {
                    this.field_145850_b.func_175656_a(blockPos, Blocks.field_150359_w.func_176223_P());
                } else {
                    this.field_145850_b.func_175656_a(blockPos, ((Block)ModBlocks.APIARY_STORAGE_BLOCK.get()).func_176223_P());
                    addedStorage.set(true);
                }
            });
            this.runStructureValidation(player);
        }
    }

    private boolean blockAtPosIsNotApiary(BlockPos blockPos) {
        return this.field_145850_b != null && !(this.field_145850_b.func_180495_p(blockPos).func_177230_c() instanceof ApiaryBlock);
    }

    private boolean linkStorageAndBreeder(TileEntity tile) {
        if (tile instanceof ApiaryStorageTileEntity && this.apiaryStorage == null && ((ApiaryStorageTileEntity)tile).getApiaryPos() == null) {
            this.apiaryStorage = (ApiaryStorageTileEntity)tile;
            this.setStoragePos(this.apiaryStorage.func_174877_v());
            this.apiaryStorage.setApiaryPos(this.field_174879_c);
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.getStoragePos(), this.apiaryStorage.func_195044_w(), this.apiaryStorage.func_195044_w(), 2);
            }
            return true;
        }
        if (tile instanceof ApiaryBreederTileEntity && this.apiaryBreeder == null && ((ApiaryBreederTileEntity)tile).getApiaryPos() == null) {
            this.apiaryBreeder = (ApiaryBreederTileEntity)tile;
            this.setBreederPos(this.apiaryBreeder.func_174877_v());
            this.apiaryBreeder.setApiaryPos(this.field_174879_c);
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.getBreederPos(), this.apiaryBreeder.func_195044_w(), this.apiaryBreeder.func_195044_w(), 2);
            }
            return true;
        }
        return false;
    }

    private boolean validateLinks() {
        boolean linksValid = true;
        if (this.apiaryStorage != null && (this.apiaryStorage.getApiaryPos() == null || this.positionsMismatch(this.apiaryStorage.getApiaryPos()))) {
            this.apiaryStorage = null;
            this.setStoragePos(null);
            linksValid = false;
        }
        if (this.apiaryBreeder != null && (this.apiaryBreeder.getApiaryPos() == null || this.positionsMismatch(this.apiaryBreeder.getApiaryPos()))) {
            this.apiaryBreeder = null;
            this.setBreederPos(null);
            linksValid = false;
        }
        if (!linksValid) {
            this.func_70296_d();
        }
        return linksValid;
    }

    private boolean positionsMismatch(BlockPos pos) {
        return pos.compareTo((Vector3i)this.field_174879_c) != 0;
    }

    @Nullable
    public Container createMenu(int i, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        if (this.field_145850_b != null) {
            this.setNumPlayersUsing(this.getNumPlayersUsing() + 1);
            if (this.isValidApiary(true)) {
                return new ValidatedApiaryContainer(i, this.field_145850_b, this.field_174879_c, playerInventory);
            }
            return new UnvalidatedApiaryContainer(i, this.field_145850_b, this.field_174879_c, playerInventory);
        }
        return null;
    }

    @Override
    public void switchTab(ServerPlayerEntity player, ApiaryTabs tab) {
        if (this.field_145850_b != null) {
            if (tab == ApiaryTabs.STORAGE) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this.getApiaryStorage(), (BlockPos)this.getStoragePos());
            }
            if (tab == ApiaryTabs.BREED) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this.getApiaryBreeder(), (BlockPos)this.getBreederPos());
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.getLazyOptional().cast() : super.getCapability(cap, side);
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0 || slot == 1;
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 2;
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.apiary");
    }

    public boolean isPreviewed() {
        return this.previewed;
    }

    public void setPreviewed(boolean previewed) {
        this.previewed = previewed;
    }

    @NotNull
    public TileStackHandler getTileStackHandler() {
        return this.tileStackHandler;
    }

    public LazyOptional<IItemHandler> getLazyOptional() {
        return this.lazyOptional;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public void setVerticalOffset(int verticalOffset) {
        this.verticalOffset = verticalOffset;
    }

    public int getNumPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void setNumPlayersUsing(int numPlayersUsing) {
        this.numPlayersUsing = numPlayersUsing;
    }

    public BlockPos getStoragePos() {
        return this.storagePos;
    }

    public void setStoragePos(BlockPos storagePos) {
        this.storagePos = storagePos;
    }

    public BlockPos getBreederPos() {
        return this.breederPos;
    }

    public void setBreederPos(BlockPos breederPos) {
        this.breederPos = breederPos;
    }

    private static /* synthetic */ ApiaryBee lambda$loadBees$3(CompoundNBT data, String beeType, String beeColor, ITextComponent displayName, String k) {
        return new ApiaryBee(data.func_74775_l("EntityData"), data.func_74762_e("TicksInHive"), data.func_74762_e("MinOccupationTicks"), beeType, beeColor, displayName);
    }

    public class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots) {
            super(slots);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.func_77973_b() instanceof BeeJar && BeeJar.isFilled(stack);
            }
            if (slot == 1) {
                return stack.func_77973_b() instanceof BeeJar && !BeeJar.isFilled(stack);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        @Override
        public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
            return ApiaryTileEntity.this.getAcceptor();
        }

        @Override
        public AutomationSensitiveItemStackHandler.IRemover getRemover() {
            return ApiaryTileEntity.this.getRemover();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ApiaryTileEntity.this.func_70296_d();
        }
    }

    public static class ApiaryBee {
        public final CompoundNBT entityData;
        public final int minOccupationTicks;
        public final String beeType;
        private int ticksInHive;
        private boolean isLocked = false;
        public final String beeColor;
        public final ITextComponent displayName;

        public ApiaryBee(CompoundNBT nbt, int ticksInHive, int minOccupationTicks, String beeType, String beeColor, ITextComponent displayName) {
            nbt.func_82580_o("UUID");
            this.entityData = nbt;
            this.setTicksInHive(ticksInHive);
            this.minOccupationTicks = minOccupationTicks;
            this.beeType = beeType;
            this.beeColor = beeColor;
            this.displayName = displayName;
        }

        public int getTicksInHive() {
            return this.ticksInHive;
        }

        public void setTicksInHive(int ticksInHive) {
            this.ticksInHive = ticksInHive;
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        public void setLocked(boolean locked) {
            this.isLocked = locked;
        }
    }

    public static enum State {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }
}

