/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity.multiblocks;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;

public class MultiBlockHelper {
    private MultiBlockHelper() {
        throw new IllegalStateException("Utility Class");
    }

    public static MutableBoundingBox buildStructureBounds(BlockPos startPos, int width, int height, int depth, int hOffset, int vOffset, int dOffset, Direction direction) {
        int x = startPos.func_177958_n();
        int y = startPos.func_177956_o();
        int z = startPos.func_177952_p();
        --width;
        --height;
        --depth;
        switch (direction) {
            case NORTH: {
                return new MutableBoundingBox(x + hOffset, y + vOffset, z - dOffset, x + width + hOffset, y + height + vOffset, z - depth - dOffset);
            }
            case EAST: {
                return new MutableBoundingBox(x + dOffset, y + vOffset, z + hOffset, x + depth + dOffset, y + height + vOffset, z + width + hOffset);
            }
            case SOUTH: {
                return new MutableBoundingBox(x - hOffset, y + vOffset, z + dOffset, x - width - hOffset, y + height + vOffset, z + depth + dOffset);
            }
        }
        return new MutableBoundingBox(x - dOffset, y + vOffset, z - hOffset, x - depth - dOffset, y + height + vOffset, z - width - hOffset);
    }

    public static void buildStructureList(MutableBoundingBox box, List<BlockPos> list, Predicate<BlockPos> predicate, BlockPos validatorPosition) {
        list.clear();
        BlockPos.func_229383_a_((MutableBoundingBox)box).filter(blockPos -> !blockPos.equals((Object)validatorPosition)).filter(predicate).forEach(blockPos -> list.add(blockPos.func_185334_h()));
    }

    public static boolean validateStructure(List<BlockPos> list, Predicate<BlockPos> predicate, int totalBlocks) {
        return list.size() == totalBlocks && list.stream().allMatch(predicate);
    }
}

