/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyPipeTileEntity
extends TileEntity
implements ITickableTileEntity {
    private Direction inputSide = null;
    FluidTank tank = new FluidTank(((Integer)Config.MAX_PIPE_FLOW.get()).intValue(), BeeInfoUtils.getHoneyPredicate());
    private LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(this::getFluidTank);

    public HoneyPipeTileEntity() {
        super((TileEntityType)ModTileEntityTypes.HONEY_PIPE_TILE_ENTITY.get());
    }

    public Direction getInputSide() {
        return this.inputSide;
    }

    public void setInputSide(Direction inputSide) {
        this.inputSide = inputSide;
    }

    public void func_73660_a() {
        if (this.inputSide == null) {
            return;
        }
    }

    @NotNull
    public FluidTank getFluidTank() {
        return this.tank;
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.readNBT(tag);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeNBT(tag);
        return tag;
    }

    protected void invalidateCaps() {
        this.fluidOptional.invalidate();
        super.invalidateCaps();
    }

    public CompoundNBT writeNBT(CompoundNBT tag) {
        if (this.getFluidTank().isEmpty()) {
            return tag;
        }
        tag.func_218657_a("fluid", (INBT)this.getFluidTank().writeToNBT(new CompoundNBT()));
        return tag;
    }

    public void readNBT(CompoundNBT tag) {
        this.getFluidTank().readFromNBT(tag.func_74775_l("fluid"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.writeNBT(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.readNBT(nbt);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        return this.writeNBT(nbt);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.readNBT(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || side == this.inputSide)) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

