/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.EnderBeeconContainer;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.SyncGUIMessage;
import com.resourcefulbees.resourcefulbees.network.packets.UpdateClientBeeconMessage;
import com.resourcefulbees.resourcefulbees.registry.ModEffects;
import com.resourcefulbees.resourcefulbees.tileentity.AbstractHoneyTankContainer;
import com.resourcefulbees.resourcefulbees.tileentity.InternalFluidTank;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderBeeconTileEntity
extends AbstractHoneyTankContainer
implements ITickableTileEntity,
INamedContainerProvider {
    private boolean updateBeecon = true;
    private boolean beeconActive = false;
    private boolean playSound = true;
    private boolean showBeam = true;
    private static final int FLUID_PULL_RATE = (Integer)Config.BEECON_PULL_AMOUNT.get();
    private List<BeeconEffect> effects;

    public EnderBeeconTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.setFluidTank(new BeeconFluidTank(16000, EnderBeeconTileEntity.honeyFluidPredicate(), this));
        this.setFluidOptional((LazyOptional<IFluidHandler>)LazyOptional.of(this::getFluidTank));
        this.effects = this.readEffectsFromNBT(new CompoundNBT());
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.ender_beecon");
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new EnderBeeconContainer(id, this.field_145850_b, this.field_174879_c, playerInventory);
    }

    @Override
    public CompoundNBT writeNBT(CompoundNBT tag) {
        CompoundNBT inv = this.getTileStackHandler().serializeNBT();
        tag.func_218657_a("inv", (INBT)inv);
        tag.func_74757_a("showBeam", this.isShowBeam());
        tag.func_74757_a("playSound", this.playSound);
        if (this.effects != null && !this.effects.isEmpty()) {
            tag.func_218657_a("active_effects", (INBT)this.writeEffectsToNBT(new CompoundNBT()));
        }
        return super.writeNBT(tag);
    }

    @Override
    public void readNBT(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getTileStackHandler().deserializeNBT(invTag);
        this.getFluidTank().readFromNBT(tag.func_74775_l("fluid"));
        this.effects = this.readEffectsFromNBT(tag.func_74775_l("active_effects"));
        if (tag.func_74764_b("showBeam")) {
            this.setShowBeam(tag.func_74767_n("showBeam"));
        }
        if (tag.func_74764_b("playSound")) {
            this.playSound = tag.func_74767_n("playSound");
        }
        super.readNBT(tag);
    }

    @Override
    public void func_73660_a() {
        boolean flag;
        if (this.field_145850_b == null) {
            return;
        }
        if (this.doEffects()) {
            this.getFluidTank().drain(this.getDrain(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L && !this.getFluidTank().isEmpty()) {
            AxisAlignedBB box = this.getEffectBox();
            List bees = this.field_145850_b.func_217357_a(BeeEntity.class, box);
            bees.stream().filter(CustomBeeEntity.class::isInstance).map(CustomBeeEntity.class::cast).forEach(CustomBeeEntity::setHasDisruptorInRange);
            this.addEffectsToBees(bees);
            if (this.playSound) {
                this.playSound(SoundEvents.field_206939_L);
            }
        }
        this.doPullProcess();
        boolean bl = flag = this.getFluidTank().getFluidAmount() > 0;
        if (!this.field_145850_b.field_72995_K) {
            if (flag && this.updateBeecon && !this.beeconActive) {
                this.playSound(SoundEvents.field_206938_K);
                this.beeconActive = true;
            } else if (!flag && this.updateBeecon && this.beeconActive) {
                this.playSound(SoundEvents.field_206940_M);
                this.beeconActive = false;
            }
            this.updateBeecon = false;
        }
        super.func_73660_a();
    }

    private void pullFluid(Fluid i, IFluidHandler handler) {
        int remainingSpace = this.getFluidTank().getSpace();
        FluidStack amountDrained = FLUID_PULL_RATE > remainingSpace ? handler.drain(new FluidStack(i, remainingSpace), IFluidHandler.FluidAction.EXECUTE) : handler.drain(new FluidStack(i, FLUID_PULL_RATE), IFluidHandler.FluidAction.EXECUTE);
        this.getFluidTank().fill(amountDrained, IFluidHandler.FluidAction.EXECUTE);
    }

    private void doPullProcess() {
        assert (this.field_145850_b != null);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileEntity == null) {
            return;
        }
        LazyOptional fluidCap = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP);
        fluidCap.map(iFluidHandler -> {
            int tanks = iFluidHandler.getTanks();
            for (int i = 0; i < tanks; ++i) {
                if (iFluidHandler.getFluidInTank(i).isEmpty() || !iFluidHandler.getFluidInTank(i).getFluid().func_207185_a(HONEY_FLUID_TAG) || !this.getFluidTank().isEmpty() && iFluidHandler.getFluidInTank(i).getFluid() != this.getFluidTank().getFluid().getFluid()) continue;
                this.pullFluid(iFluidHandler.getFluidInTank(i).getFluid(), (IFluidHandler)iFluidHandler);
                return true;
            }
            return false;
        });
    }

    public void toggleSound() {
        boolean bl = this.playSound = !this.playSound;
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
        this.setDirty();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 255.0, (double)this.field_174879_c.func_177952_p());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    public void sendGUINetworkPacket(IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            buffer.writeFluidStack(this.getFluidTank().getFluid());
            NetPacketHandler.sendToPlayer(new SyncGUIMessage(this.field_174879_c, buffer), (ServerPlayerEntity)player);
        }
    }

    public static void syncApiaryToPlayersUsing(World world, BlockPos pos, CompoundNBT data) {
        NetPacketHandler.sendToAllLoaded(new UpdateClientBeeconMessage(pos, data), world, pos);
    }

    public List<BeeconEffect> getEffects() {
        return this.effects;
    }

    public AxisAlignedBB getEffectBox() {
        assert (this.field_145850_b != null);
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getRange()).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
    }

    public void toggleBeam() {
        this.setShowBeam(!this.isShowBeam());
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
        this.setDirty();
    }

    public boolean isShowBeam() {
        return this.showBeam;
    }

    public void setShowBeam(boolean showBeam) {
        this.showBeam = showBeam;
    }

    private void addEffectsToBees(List<BeeEntity> bees) {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K && this.doEffects()) {
            for (BeeEntity mob : bees) {
                for (BeeconEffect effect : this.effects) {
                    if (!effect.isActive()) continue;
                    mob.func_195064_c(new EffectInstance(effect.getEffect(), 120, 0, false, false));
                }
            }
        }
    }

    public int getRange() {
        int range = (Integer)Config.BEECON_RANGE_PER_EFFECT.get();
        for (BeeconEffect effect : this.effects) {
            if (!effect.isActive()) continue;
            range += ((Integer)Config.BEECON_RANGE_PER_EFFECT.get()).intValue();
        }
        return range;
    }

    public boolean doEffects() {
        if (this.getFluidTank().isEmpty()) {
            return false;
        }
        for (BeeconEffect effect : this.effects) {
            if (!effect.isActive()) continue;
            return true;
        }
        return false;
    }

    public void updateBeeconEffect(ResourceLocation effectLocation, boolean active) {
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectLocation);
        for (BeeconEffect e : this.effects) {
            if (e.getEffect() != effect) continue;
            e.setActive(active);
        }
        EnderBeeconTileEntity.syncApiaryToPlayersUsing(this.field_145850_b, this.func_174877_v(), this.writeNBT(new CompoundNBT()));
    }

    public int getDrain() {
        double base = ((Integer)Config.BEECON_BASE_DRAIN.get()).intValue();
        for (BeeconEffect e : this.effects) {
            if (((Boolean)Config.BEECON_DO_MULTIPLIER.get()).booleanValue()) {
                if (!e.isActive()) continue;
                base *= e.getValue();
                continue;
            }
            if (!e.isActive()) continue;
            base += e.getValue();
        }
        return (int)Math.ceil(base);
    }

    public boolean getEffectActive(Effect effect) {
        BeeconEffect e = this.getEffect(effect);
        return e != null && e.isActive();
    }

    public BeeconEffect getEffect(Effect effect) {
        for (BeeconEffect e : this.effects) {
            if (e.getEffect() != effect) continue;
            return e;
        }
        return null;
    }

    public CompoundNBT writeEffectsToNBT(CompoundNBT nbt) {
        nbt.func_74757_a("calming", this.getEffectActive((Effect)ModEffects.CALMING.get()));
        nbt.func_74757_a("water_breathing", this.getEffectActive(Effects.field_76427_o));
        nbt.func_74757_a("fire_resistance", this.getEffectActive(Effects.field_76426_n));
        nbt.func_74757_a("regeneration", this.getEffectActive(Effects.field_76428_l));
        return nbt;
    }

    public List<BeeconEffect> readEffectsFromNBT(CompoundNBT nbt) {
        LinkedList<BeeconEffect> beeconEffects = new LinkedList<BeeconEffect>();
        beeconEffects.add(new BeeconEffect((Effect)ModEffects.CALMING.get(), (Double)Config.BEECON_CALMING_VALUE.get(), nbt.func_74767_n("calming")));
        beeconEffects.add(new BeeconEffect(Effects.field_76427_o, (Double)Config.BEECON_WATER_BREATHING_VALUE.get(), nbt.func_74767_n("water_breathing")));
        beeconEffects.add(new BeeconEffect(Effects.field_76426_n, (Double)Config.BEECON_FIRE_RESISTANCE_VALUE.get(), nbt.func_74767_n("fire_resistance")));
        beeconEffects.add(new BeeconEffect(Effects.field_76428_l, (Double)Config.BEECON_REGENERATION_VALUE.get(), nbt.func_74767_n("regeneration")));
        return beeconEffects;
    }

    public static class BeeconEffect {
        private Effect effect;
        private double value;
        private boolean active;

        public BeeconEffect(Effect effect, double multiplier, boolean active) {
            this.setEffect(effect);
            this.setValue(multiplier);
            this.setActive(active);
        }

        public Effect getEffect() {
            return this.effect;
        }

        public void setEffect(Effect effect) {
            this.effect = effect;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    public class BeeconFluidTank
    extends InternalFluidTank {
        public BeeconFluidTank(int capacity, Predicate<FluidStack> validator, TileEntity tileEntity) {
            super(capacity, validator, tileEntity);
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            EnderBeeconTileEntity.this.updateBeecon = true;
        }
    }
}

