/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.capabilities.CustomEnergyStorage;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeGenTileEntity
extends TileEntity
implements ITickableTileEntity {
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energyOptional = LazyOptional.of(() -> this.energyStorage);

    public CreativeGenTileEntity() {
        super((TileEntityType)ModTileEntityTypes.CREATIVE_GEN_ENTITY.get());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityEnergy.ENERGY)) {
            return this.energyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.energyOptional.invalidate();
    }

    private void sendOutPower() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Arrays.stream(Direction.values()).map(direction -> this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction))).filter(Objects::nonNull).forEach(tileEntity -> tileEntity.getCapability(CapabilityEnergy.ENERGY).map(iEnergyStorage -> {
                if (iEnergyStorage.canReceive()) {
                    return iEnergyStorage.receiveEnergy(Integer.MAX_VALUE, false) != 0;
                }
                return true;
            }));
        }
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(Integer.MAX_VALUE, 0, Integer.MAX_VALUE){

            @Override
            protected void onEnergyChanged() {
                CreativeGenTileEntity.this.func_70296_d();
            }
        };
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.energyStorage.setEnergy(Integer.MAX_VALUE);
            this.sendOutPower();
        }
    }
}

