/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.tileentity.InternalFluidTank;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractHoneyTank
extends TileEntity {
    private FluidTank fluidTank;
    private LazyOptional<IFluidHandler> fluidOptional;

    public AbstractHoneyTank(TileEntityType<?> tileEntityType, int level) {
        super(tileEntityType);
        this.setFluidTank(new InternalFluidTank(level, AbstractHoneyTank.honeyFluidPredicate(), this));
        this.setFluidOptional((LazyOptional<IFluidHandler>)LazyOptional.of(this::getFluidTank));
    }

    public AbstractHoneyTank(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    protected static Predicate<FluidStack> honeyFluidPredicate() {
        return fluidStack -> fluidStack.getFluid().func_207185_a(BeeInfoUtils.getFluidTag("forge:honey"));
    }

    public LazyOptional<IFluidHandler> getFluidOptional() {
        return this.fluidOptional;
    }

    public void setFluidOptional(LazyOptional<IFluidHandler> fluidOptional) {
        this.fluidOptional = fluidOptional;
    }

    @NotNull
    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void setFluidTank(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    public void playSound(SoundEvent soundEvent) {
        assert (this.field_145850_b != null);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.getFluidOptional().cast();
        }
        return super.getCapability(cap, side);
    }

    public int getFluidLevel() {
        float fillPercentage = (float)this.getFluidTank().getFluidAmount() / (float)this.getFluidTank().getTankCapacity(0);
        return (int)Math.ceil(fillPercentage * 100.0f);
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.readNBT(tag);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeNBT(tag);
        return tag;
    }

    protected void invalidateCaps() {
        this.fluidOptional.invalidate();
        super.invalidateCaps();
    }

    public CompoundNBT writeNBT(CompoundNBT tag) {
        if (this.getFluidTank().isEmpty()) {
            return tag;
        }
        tag.func_218657_a("fluid", (INBT)this.getFluidTank().writeToNBT(new CompoundNBT()));
        return tag;
    }

    public void readNBT(CompoundNBT tag) {
        this.getFluidTank().readFromNBT(tag.func_74775_l("fluid"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.writeNBT(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.readNBT(nbt);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        return this.writeNBT(nbt);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.readNBT(tag);
    }

    public void fillBottle(PlayerEntity player, Hand hand) {
        FluidStack fluidStack = new FluidStack(this.getFluidTank().getFluid(), 250);
        ItemStack itemStack = new ItemStack((IItemProvider)BeeInfoUtils.getHoneyBottle(this.getFluidTank().getFluid().getFluid()), 1);
        if (this.getFluidTank().isEmpty()) {
            return;
        }
        if (this.getFluidTank().getFluidAmount() >= 250) {
            this.getFluidTank().drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                player.func_191521_c(itemStack);
            } else {
                player.func_184611_a(hand, itemStack);
            }
            this.playSound(SoundEvents.field_187615_H);
        }
    }

    public void emptyBottle(PlayerEntity player, Hand hand) {
        FluidStack fluidStack = new FluidStack(BeeInfoUtils.getFluidFromBottle(player.func_184586_b(hand)), 250);
        if (!this.getFluidTank().getFluid().isFluidEqual(fluidStack) && !this.getFluidTank().isEmpty()) {
            return;
        }
        if (this.getFluidTank().getFluidAmount() + 250 <= this.getFluidTank().getTankCapacity(0)) {
            this.getFluidTank().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo, 1));
            } else {
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151069_bo, 1));
            }
            this.playSound(SoundEvents.field_191241_J);
        }
    }
}

