/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.registry;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.ITraitRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.data.BeeTrait;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import org.apache.commons.lang3.tuple.Pair;

public class TraitRegistry
implements ITraitRegistry {
    private static final HashMap<String, BeeTrait> TRAIT_REGISTRY = new HashMap();
    private static boolean closed = false;
    private static final TraitRegistry INSTANCE = new TraitRegistry();

    public static TraitRegistry getRegistry() {
        return INSTANCE;
    }

    @Override
    public boolean register(String name, BeeTrait data) {
        if (closed || TRAIT_REGISTRY.containsKey(name)) {
            ResourcefulBees.LOGGER.error("Trait is already registered or registration is closed: {}", (Object)name);
            return false;
        }
        TRAIT_REGISTRY.put(name, data);
        return true;
    }

    @Override
    public BeeTrait getTrait(String name) {
        return TRAIT_REGISTRY.get(name);
    }

    public Map<String, BeeTrait> getTraits() {
        return Collections.unmodifiableMap(TRAIT_REGISTRY);
    }

    public static void setTraitRegistryClosed() {
        closed = true;
    }

    public static void registerDefaultTraits() {
        ResourcefulBees.LOGGER.info("Registering Default Bee Traits...");
        TraitRegistry.getRegistry().register("wither", new BeeTrait.Builder("wither").addPotionImmunity(Effects.field_82731_v).addDamagePotionEffect((Pair<Effect, Integer>)Pair.of((Object)Effects.field_82731_v, (Object)1)).setBeepediaItem(Items.field_221690_bg).build());
        TraitRegistry.getRegistry().register("blaze", new BeeTrait.Builder("blaze").addDamageImmunities(Arrays.asList(DamageSource.field_76371_c.field_76373_n, DamageSource.field_76372_a.field_76373_n, DamageSource.field_76370_b.field_76373_n, DamageSource.field_190095_e.field_76373_n)).addDamageType((Pair<String, Integer>)Pair.of((Object)"setOnFire", (Object)1)).addSpecialAbility("flammable").setParticleEffect(ParticleTypes.field_197631_x).setBeepediaItem(Items.field_151072_bj).build());
        TraitRegistry.getRegistry().register("can_swim", new BeeTrait.Builder("can_swim").addDamageImmunity(DamageSource.field_76369_e.field_76373_n).setBeepediaItem(Items.field_151131_as).build());
        TraitRegistry.getRegistry().register("creeper", new BeeTrait.Builder("creeper").addDamageType((Pair<String, Integer>)Pair.of((Object)"explosive", (Object)4)).setBeepediaItem(Items.field_221649_bM).build());
        TraitRegistry.getRegistry().register("zombie", new BeeTrait.Builder("zombie").addDamagePotionEffect((Pair<Effect, Integer>)Pair.of((Object)Effects.field_76438_s, (Object)20)).setBeepediaItem(Items.field_151078_bh).build());
        TraitRegistry.getRegistry().register("pigman", new BeeTrait.Builder("pigman").addDamagePotionEffect((Pair<Effect, Integer>)Pair.of((Object)Effects.field_76419_f, (Object)0)).setBeepediaItem(Items.field_151074_bl).build());
        TraitRegistry.getRegistry().register("ender", new BeeTrait.Builder("ender").addSpecialAbility("teleport").setParticleEffect(ParticleTypes.field_197599_J).setBeepediaItem(Items.field_151079_bi).build());
        TraitRegistry.getRegistry().register("nether", new BeeTrait.Builder("nether").addDamageImmunities(Arrays.asList(DamageSource.field_76371_c.field_76373_n, DamageSource.field_76372_a.field_76373_n, DamageSource.field_76370_b.field_76373_n, DamageSource.field_190095_e.field_76373_n)).setBeepediaItem(Items.field_221691_cH).build());
        TraitRegistry.getRegistry().register("oreo", new BeeTrait.Builder("oreo").addDamagePotionEffect((Pair<Effect, Integer>)Pair.of((Object)Effects.field_76432_h, (Object)2)).setBeepediaItem((Item)ModItems.OREO_COOKIE.get()).build());
        TraitRegistry.getRegistry().register("kitten", new BeeTrait.Builder("kitten").addDamagePotionEffect((Pair<Effect, Integer>)Pair.of((Object)Effects.field_76424_c, (Object)2)).setBeepediaItem(Items.field_196098_bI).build());
        TraitRegistry.getRegistry().register("slimy", new BeeTrait.Builder("slimy").addSpecialAbility("slimy").setBeepediaItem(Items.field_151123_aH).build());
        TraitRegistry.getRegistry().register("desert", new BeeTrait.Builder("desert").addDamageImmunity(DamageSource.field_76367_g.field_76373_n).setBeepediaItem(Items.field_221774_cw).build());
        TraitRegistry.getRegistry().register("angry", new BeeTrait.Builder("angry").addSpecialAbility("angry").build());
        TraitRegistry.getRegistry().register("spider", new BeeTrait.Builder("spider").addSpecialAbility("spider").setBeepediaItem(Items.field_221672_ax).build());
    }

    public static void applyBeeTraits() {
        BeeRegistry.getRegistry().getBees().values().forEach(beeData -> {
            beeData.getTraitData().initializeTraitSets();
            if (beeData.hasTraitNames()) {
                Arrays.stream(beeData.getTraitNames()).forEach(traitString -> TraitRegistry.addTrait(beeData, traitString));
            }
        });
    }

    private static void addTrait(CustomBeeData customBeeData, String traitString) {
        BeeTrait trait = TraitRegistry.getRegistry().getTrait(traitString);
        if (trait != null) {
            if (customBeeData.getTraitData().hasTraits()) {
                customBeeData.getTraitData().addTrait(trait);
            } else {
                ResourcefulBees.LOGGER.warn("Traits provided but TraitData object does not exist or does not contain \"hasTraits: true\" for '{}'", (Object)customBeeData.getName());
            }
        } else {
            ResourcefulBees.LOGGER.warn("Trait '{}' given to '{}' does not exist in trait registry.", (Object)traitString, (Object)customBeeData.getName());
        }
    }
}

