/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.registry;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.block.ColoredHoneyBlock;
import com.resourcefulbees.resourcefulbees.block.CustomHoneyFluidBlock;
import com.resourcefulbees.resourcefulbees.block.HoneycombBlock;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.entity.passive.ResourcefulBee;
import com.resourcefulbees.resourcefulbees.fluids.HoneyFlowingFluid;
import com.resourcefulbees.resourcefulbees.fluids.HoneyFluidAttributes;
import com.resourcefulbees.resourcefulbees.item.BeeSpawnEggItem;
import com.resourcefulbees.resourcefulbees.item.CustomHoneyBottleItem;
import com.resourcefulbees.resourcefulbees.item.CustomHoneyBucketItem;
import com.resourcefulbees.resourcefulbees.item.HoneycombItem;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ItemGroupResourcefulBees;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.registry.ModContainers;
import com.resourcefulbees.resourcefulbees.registry.ModEffects;
import com.resourcefulbees.resourcefulbees.registry.ModEntities;
import com.resourcefulbees.resourcefulbees.registry.ModFeatures;
import com.resourcefulbees.resourcefulbees.registry.ModFluids;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModPOIs;
import com.resourcefulbees.resourcefulbees.registry.ModPotions;
import com.resourcefulbees.resourcefulbees.registry.ModRecipeSerializers;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.registry.ModVillagerProfessions;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryHandler {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"resourcefulbees");
    private static final Pattern CUSTOM_DROP_REGEX = Pattern.compile("^(\\w+)_honeycomb(_block)?$");
    private static final Map<String, RegistryObject<FlowingFluid>> stillFluids = new HashMap<String, RegistryObject<FlowingFluid>>();
    private static final Map<String, RegistryObject<FlowingFluid>> flowingFluids = new HashMap<String, RegistryObject<FlowingFluid>>();
    private static final Map<String, RegistryObject<Item>> honeyBuckets = new HashMap<String, RegistryObject<Item>>();
    private static final Map<String, RegistryObject<FlowingFluidBlock>> fluidBlocks = new HashMap<String, RegistryObject<FlowingFluidBlock>>();

    private RegistryHandler() {
        throw new IllegalStateException("Utility Class");
    }

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(bus);
        ModEffects.EFFECTS.register(bus);
        ModBlocks.BLOCKS.register(bus);
        ModFluids.FLUIDS.register(bus);
        ENTITY_TYPES.register(bus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(bus);
        ModPOIs.POIS.register(bus);
        ModPotions.POTIONS.register(bus);
        ModContainers.CONTAINER_TYPES.register(bus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ModVillagerProfessions.PROFESSIONS.register(bus);
        ModFeatures.FEATURES.register(bus);
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        ModEntities.getModBees().forEach((s, customBee) -> event.put((EntityType)customBee.get(), CustomBeeEntity.createBeeAttributes(s).func_233813_a_()));
    }

    public static void registerDynamicBees() {
        BeeRegistry.getRegistry().getBees().forEach((name, customBee) -> {
            if (customBee.shouldResourcefulBeesDoForgeRegistration()) {
                if (customBee.hasHoneycomb() && RegistryHandler.checkCustomDrops(customBee)) {
                    RegistryHandler.registerHoneycomb(name, customBee);
                } else if (customBee.hasHoneycomb() && customBee.hasCustomDrop() && !customBee.isEasterEggBee()) {
                    RegistryHandler.fillCustomDrops(customBee);
                }
                RegistryHandler.registerBee(name, customBee);
            }
        });
    }

    private static boolean checkCustomDrops(CustomBeeData customBee) {
        return !customBee.hasCustomDrop();
    }

    public static void registerDynamicHoney() {
        BeeRegistry.getRegistry().getHoneyBottles().forEach((name, honeyData) -> {
            if (honeyData.shouldResourcefulBeesDoForgeRegistration()) {
                RegistryHandler.registerHoneyBottle(name, honeyData);
            }
        });
    }

    private static void registerHoneyBottle(String name, HoneyBottleData honeyData) {
        RegistryObject customHoneyBottle = ModItems.ITEMS.register(name + "_honey_bottle", () -> new CustomHoneyBottleItem(honeyData.getProperties(), honeyData));
        honeyData.setHoneyBottleRegistryObject((RegistryObject<Item>)customHoneyBottle);
        if (((Boolean)Config.HONEY_GENERATE_BLOCKS.get()).booleanValue() && honeyData.doGenerateHoneyBlock()) {
            RegistryObject customHoneyBlock = ModBlocks.BLOCKS.register(name + "_honey_block", () -> new ColoredHoneyBlock(honeyData));
            RegistryObject customHoneyBlockItem = ModItems.ITEMS.register(name + "_honey_block", () -> new BlockItem((Block)customHoneyBlock.get(), new Item.Properties().func_200916_a(ItemGroupResourcefulBees.RESOURCEFUL_BEES)));
            honeyData.setHoneyBlockRegistryObject((RegistryObject<Block>)customHoneyBlock);
            honeyData.setHoneyBlockItemRegistryObject((RegistryObject<Item>)customHoneyBlockItem);
        }
        if (((Boolean)Config.HONEY_GENERATE_FLUIDS.get()).booleanValue() && honeyData.doGenerateHoneyFluid()) {
            stillFluids.put(name, (RegistryObject<FlowingFluid>)ModFluids.FLUIDS.register(name + "_honey", () -> new HoneyFlowingFluid.Source(RegistryHandler.makeProperties(name, honeyData), honeyData)));
            flowingFluids.put(name, (RegistryObject<FlowingFluid>)ModFluids.FLUIDS.register(name + "_honey_flowing", () -> new HoneyFlowingFluid.Flowing(RegistryHandler.makeProperties(name, honeyData), honeyData)));
            honeyBuckets.put(name, (RegistryObject<Item>)ModItems.ITEMS.register(name + "_honey_fluid_bucket", () -> new CustomHoneyBucketItem((Supplier)stillFluids.get(name), new Item.Properties().func_200916_a(ItemGroupResourcefulBees.RESOURCEFUL_BEES).func_200919_a(Items.field_151133_ar).func_200917_a(1), honeyData)));
            fluidBlocks.put(name, (RegistryObject<FlowingFluidBlock>)ModBlocks.BLOCKS.register(name + "_honey", () -> new CustomHoneyFluidBlock((Supplier)stillFluids.get(name), AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e(), honeyData)));
            honeyData.setHoneyStillFluidRegistryObject(stillFluids.get(name));
            honeyData.setHoneyFlowingFluidRegistryObject(flowingFluids.get(name));
            honeyData.setHoneyBucketItemRegistryObject(honeyBuckets.get(name));
            honeyData.setHoneyFluidBlockRegistryObject(fluidBlocks.get(name));
        }
    }

    private static ForgeFlowingFluid.Properties makeProperties(String name, HoneyBottleData honeyData) {
        HoneyFluidAttributes.Builder builder = HoneyFluidAttributes.builder(ModFluids.CUSTOM_FLUID_STILL, ModFluids.CUSTOM_FLUID_FLOWING, honeyData);
        builder.overlay(ModFluids.CUSTOM_FLUID_OVERLAY);
        builder.sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K);
        builder.density(1300);
        builder.temperature(300);
        builder.viscosity(1800);
        return new ForgeFlowingFluid.Properties((Supplier)stillFluids.get(name), (Supplier)flowingFluids.get(name), (FluidAttributes.Builder)builder).bucket((Supplier)honeyBuckets.get(name)).block((Supplier)fluidBlocks.get(name)).tickRate(20);
    }

    private static void registerHoneycomb(String name, CustomBeeData customBeeData) {
        RegistryObject customHoneycombBlock = ModBlocks.BLOCKS.register(name + "_honeycomb_block", () -> new HoneycombBlock(name, customBeeData.getColorData(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_226908_md_)));
        RegistryObject customHoneycomb = ModItems.ITEMS.register(name + "_honeycomb", () -> new HoneycombItem(name, customBeeData.getColorData(), new Item.Properties().func_200916_a(ItemGroupResourcefulBees.RESOURCEFUL_BEES)));
        RegistryObject customHoneycombBlockItem = ModItems.ITEMS.register(name + "_honeycomb_block", () -> new BlockItem((Block)customHoneycombBlock.get(), new Item.Properties().func_200916_a(ItemGroupResourcefulBees.RESOURCEFUL_BEES)));
        customBeeData.setCombBlockRegistryObject((RegistryObject<Block>)customHoneycombBlock);
        customBeeData.setCombRegistryObject((RegistryObject<Item>)customHoneycomb);
        customBeeData.setCombBlockItemRegistryObject((RegistryObject<Item>)customHoneycombBlockItem);
    }

    private static void registerBee(String name, CustomBeeData customBeeData) {
        RegistryObject customBeeEntity = ENTITY_TYPES.register(name + "_bee", () -> EntityType.Builder.func_220322_a((type, world) -> new ResourcefulBee((EntityType<? extends BeeEntity>)type, world, customBeeData), (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f * customBeeData.getSizeModifier(), 0.6f * customBeeData.getSizeModifier()).func_206830_a(name + "_bee"));
        RegistryObject customBeeSpawnEgg = ModItems.ITEMS.register(name + "_bee_spawn_egg", () -> new BeeSpawnEggItem(customBeeEntity, Color.parseInt("#edc343"), 0x303030, customBeeData, new Item.Properties().func_200916_a(ItemGroupResourcefulBees.RESOURCEFUL_BEES)));
        ModEntities.getModBees().put(name, (RegistryObject<EntityType<? extends CustomBeeEntity>>)customBeeEntity);
        customBeeData.setEntityTypeRegistryID(customBeeEntity.getId());
        customBeeData.setSpawnEggItemRegistryObject((RegistryObject<Item>)customBeeSpawnEgg);
    }

    private static void fillCustomDrops(CustomBeeData customBeeData) {
        RegistryObject customComb = RegistryObject.of((ResourceLocation)new ResourceLocation(customBeeData.getCustomCombDrop()), (IForgeRegistry)ForgeRegistries.ITEMS);
        RegistryObject customCombBlock = RegistryObject.of((ResourceLocation)new ResourceLocation(customBeeData.getCustomCombBlockDrop()), (IForgeRegistry)ForgeRegistries.ITEMS);
        customBeeData.setCombRegistryObject((RegistryObject<Item>)customComb);
        customBeeData.setCombBlockItemRegistryObject((RegistryObject<Item>)customCombBlock);
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BeeRegistry.getRegistry().denyRegistration();
    }
}

