/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.registry;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.EntityMutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.ItemMutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.EntityOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import com.resourcefulbees.resourcefulbees.utils.validation.FirstPhaseValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class BeeRegistry
implements IBeeRegistry {
    private static final Map<ResourceLocation, RandomCollection<CustomBeeData>> spawnableBiomes = new HashMap<ResourceLocation, RandomCollection<CustomBeeData>>();
    private static final BeeRegistry INSTANCE = new BeeRegistry();
    private final Map<String, CustomBeeData> beeInfo = new LinkedHashMap<String, CustomBeeData>();
    private final Map<String, HoneyBottleData> honeyInfo = new LinkedHashMap<String, HoneyBottleData>();
    public final Map<Pair<String, String>, RandomCollection<CustomBeeData>> familyTree = new HashMap<Pair<String, String>, RandomCollection<CustomBeeData>>();
    private boolean allowRegistration;

    public static BeeRegistry getRegistry() {
        return INSTANCE;
    }

    public static Map<ResourceLocation, RandomCollection<CustomBeeData>> getSpawnableBiomes() {
        return spawnableBiomes;
    }

    public void allowRegistration() {
        this.allowRegistration = true;
        ResourcefulBees.LOGGER.info("Bee Registration Enabled...");
    }

    public void denyRegistration() {
        this.allowRegistration = false;
        ResourcefulBees.LOGGER.info("Bee Registration Disabled...");
    }

    @Override
    public CustomBeeData getBeeData(String bee) {
        return this.beeInfo.get(bee);
    }

    public HoneyBottleData getHoneyData(String honey) {
        return this.honeyInfo.get(honey);
    }

    @Override
    public boolean canParentsBreed(String parent1, String parent2) {
        return this.familyTree.containsKey(BeeInfoUtils.sortParents(parent1, parent2));
    }

    @Override
    public CustomBeeData getWeightedChild(String parent1, String parent2) {
        return this.familyTree.get(BeeInfoUtils.sortParents(parent1, parent2)).next();
    }

    @Override
    public double getAdjustedWeightForChild(CustomBeeData child, String parent1, String parent2) {
        return this.familyTree.get(BeeInfoUtils.sortParents(parent1, parent2)).getAdjustedWeight(child.getBreedData().getBreedWeight());
    }

    @Override
    public boolean registerBee(String beeType, CustomBeeData customBeeData) {
        if (this.allowRegistration && !this.beeInfo.containsKey(beeType) && FirstPhaseValidator.validate(customBeeData)) {
            this.beeInfo.put(beeType, customBeeData);
            if (customBeeData.getBreedData().isBreedable()) {
                BeeInfoUtils.buildFamilyTree(customBeeData);
            }
            if (customBeeData.getSpawnData().canSpawnInWorld()) {
                BeeInfoUtils.parseBiomes(customBeeData);
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, CustomBeeData> getBees() {
        return Collections.unmodifiableMap(this.beeInfo);
    }

    @Override
    public Set<CustomBeeData> getSetOfBees() {
        return Collections.unmodifiableSet(new HashSet<CustomBeeData>(this.beeInfo.values()));
    }

    @Override
    public Map<String, HoneyBottleData> getHoneyBottles() {
        return Collections.unmodifiableMap(this.honeyInfo);
    }

    public boolean registerHoney(String honeyType, HoneyBottleData honeyData) {
        if (this.allowRegistration && !this.honeyInfo.containsKey(honeyType) && FirstPhaseValidator.validate(honeyData)) {
            this.honeyInfo.put(honeyType, honeyData);
            return true;
        }
        return false;
    }

    public float getBreedChance(String parent1, String parent2, CustomBeeData childData) {
        return parent1.equals(parent2) ? 1.0f : childData.getBreedData().getBreedChance();
    }

    public Map<Pair<String, String>, RandomCollection<CustomBeeData>> getChildren(CustomBeeData parent) {
        return this.familyTree.entrySet().stream().filter(this::registryContainsParents).filter(mapEntry -> this.parentMatchesBee((Pair<String, String>)((Pair)mapEntry.getKey()), parent)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean registryContainsParents(Map.Entry<Pair<String, String>, RandomCollection<CustomBeeData>> mapEntry) {
        return this.getBees().containsKey(mapEntry.getKey().getLeft()) && this.getBees().containsKey(mapEntry.getKey().getRight());
    }

    private boolean parentMatchesBee(Pair<String, String> parents, CustomBeeData beeData) {
        return ((String)parents.getRight()).equals(beeData.getName()) || ((String)parents.getLeft()).equals(beeData.getName());
    }

    public Map<Pair<String, String>, CustomBeeData> getParents(CustomBeeData child) {
        return this.familyTree.entrySet().stream().filter(this::registryContainsParents).filter(entry -> ((RandomCollection)entry.getValue()).getMap().containsValue(child)).collect(Collectors.toMap(Map.Entry::getKey, o -> child));
    }

    public List<EntityMutation> getMutationsContaining(CustomBeeData beeData) {
        LinkedList<EntityMutation> mutations = new LinkedList<EntityMutation>();
        INSTANCE.getBees().forEach((s, beeData1) -> beeData1.getMutationData().getEntityMutations().forEach((entityType, pair) -> {
            if (entityType.getRegistryName() != null && entityType.getRegistryName().equals((Object)beeData.getEntityTypeRegistryID())) {
                mutations.add(new EntityMutation(BeeInfoUtils.getEntityType(beeData1.getEntityTypeRegistryID()), (EntityType<?>)entityType, (Pair<Double, RandomCollection<EntityOutput>>)pair, beeData1.getMutationData().getMutationCount()));
            } else {
                ((RandomCollection)pair.getRight()).forEach(entityOutput -> {
                    if (entityOutput.getEntityType().getRegistryName() != null && entityOutput.getEntityType().getRegistryName().equals((Object)beeData.getEntityTypeRegistryID())) {
                        mutations.add(new EntityMutation(BeeInfoUtils.getEntityType(beeData1.getEntityTypeRegistryID()), (EntityType<?>)entityType, (Pair<Double, RandomCollection<EntityOutput>>)pair, beeData1.getMutationData().getMutationCount()));
                    }
                });
            }
        }));
        return mutations;
    }

    public List<ItemMutation> getItemMutationsContaining(CustomBeeData beeData) {
        LinkedList<ItemMutation> mutations = new LinkedList<ItemMutation>();
        INSTANCE.getBees().forEach((s, beeData1) -> {
            beeData1.getMutationData().getJeiItemMutations().forEach((block, pair) -> ((RandomCollection)pair.getRight()).forEach(itemOutput -> {
                if (itemOutput.getItem() == beeData.getSpawnEggItemRegistryObject().get()) {
                    mutations.add(new ItemMutation(BeeInfoUtils.getEntityType(beeData1.getEntityTypeRegistryID()), (Block)block, (Pair<Double, RandomCollection<ItemOutput>>)pair, beeData1.getMutationData().getMutationCount()));
                }
            }));
            beeData1.getMutationData().getJeiBlockTagItemMutations().forEach((tag, pair) -> ((RandomCollection)pair.getRight()).forEach(itemOutput -> {
                if (itemOutput.getItem() == beeData.getSpawnEggItemRegistryObject().get()) {
                    mutations.add(new ItemMutation(BeeInfoUtils.getEntityType(beeData1.getEntityTypeRegistryID()), (ITag<?>)tag, (Pair<Double, RandomCollection<ItemOutput>>)pair, beeData1.getMutationData().getMutationCount()));
                }
            }));
        });
        return mutations;
    }
}

