/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.recipe;

import com.google.gson.JsonObject;
import com.resourcefulbees.resourcefulbees.block.HoneyTank;
import com.resourcefulbees.resourcefulbees.registry.ModRecipeSerializers;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyTankTileEntity;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class HoneyTankRecipe
extends ShapedRecipe {
    public final ItemStack field_77575_e;

    public HoneyTankRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, "", 3, 3, ingredients, result);
        this.field_77575_e = result;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull CraftingInventory inventory) {
        List<ItemStack> stacks = this.getTanks(inventory);
        CompoundNBT tag = new CompoundNBT();
        HoneyTankTileEntity.TankTier tier = HoneyTankTileEntity.TankTier.getTier(this.field_77575_e.func_77973_b());
        for (ItemStack stack : stacks) {
            if (!stack.func_77942_o() || stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || !stack.func_77978_p().func_74764_b("fluid")) continue;
            CompoundNBT fluid = stack.func_77978_p().func_74775_l("fluid");
            if (tag.func_74764_b("fluid")) {
                FluidTank mainStack = new FluidTank(tier.getMaxFillAmount(), HoneyTankRecipe.honeyFluidPredicate());
                mainStack.readFromNBT(tag.func_74775_l("fluid"));
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluid);
                if (!mainStack.getFluid().containsFluid(fluidStack)) continue;
                mainStack.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                tag.func_218657_a("fluid", (INBT)mainStack.writeToNBT(new CompoundNBT()));
                continue;
            }
            tag.func_218657_a("fluid", (INBT)fluid);
        }
        if (tag.isEmpty()) {
            return this.field_77575_e;
        }
        tag.func_74768_a("tier", tier.getTier());
        ItemStack resultCopy = this.field_77575_e.func_77946_l();
        resultCopy.func_77982_d(tag);
        return resultCopy;
    }

    protected static Predicate<FluidStack> honeyFluidPredicate() {
        return fluidStack -> fluidStack.getFluid().func_207185_a(BeeInfoUtils.getFluidTag("forge:honey"));
    }

    public List<ItemStack> getTanks(CraftingInventory inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (!(Block.func_149634_a((Item)item.func_77973_b()) instanceof HoneyTank)) continue;
            stacks.add(item);
        }
        return stacks;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.HONEY_TANK_RECIPE.get();
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        @NotNull
        public ShapedRecipe func_199425_a_(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ShapedRecipe recipe = super.func_199425_a_(recipeId, json);
            return new HoneyTankRecipe(recipeId, (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }

        public ShapedRecipe func_199426_a_(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            ShapedRecipe recipe = super.func_199426_a_(recipeId, buffer);
            assert (recipe != null);
            return new HoneyTankRecipe(recipeId, (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }
    }
}

