/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.registry.ModRecipeSerializers;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CentrifugeRecipe
implements IRecipe<IInventory> {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IRecipeType<CentrifugeRecipe> CENTRIFUGE_RECIPE_TYPE = IRecipeType.func_222147_a((String)"resourcefulbees:centrifuge");
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final List<Pair<ItemStack, Float>> itemOutputs;
    public final List<Pair<FluidStack, Float>> fluidOutput;
    public final int time;
    public final int multiblockTime;
    public final boolean multiblock;
    public final boolean hasFluidOutput;
    public boolean noBottleInput;
    private static final String INGREDIENT_STRING = "ingredient";

    public CentrifugeRecipe(ResourceLocation id, Ingredient ingredient, List<Pair<ItemStack, Float>> itemOutputs, List<Pair<FluidStack, Float>> fluidOutput, int time, int multiblockTime, boolean multiblock, boolean hasFluidOutput) {
        this.id = id;
        this.ingredient = ingredient;
        this.itemOutputs = itemOutputs;
        this.fluidOutput = fluidOutput;
        this.time = time;
        this.multiblockTime = multiblockTime;
        this.multiblock = multiblock;
        this.hasFluidOutput = hasFluidOutput;
        this.noBottleInput = false;
    }

    public CentrifugeRecipe(ResourceLocation id, Ingredient ingredient, List<Pair<ItemStack, Float>> itemOutputs, List<Pair<FluidStack, Float>> fluidOutput, int time, int multiblockTime, boolean multiblock, boolean hasFluidOutput, boolean noBottleInput) {
        this.id = id;
        this.ingredient = ingredient;
        this.itemOutputs = itemOutputs;
        this.fluidOutput = fluidOutput;
        this.time = time;
        this.multiblockTime = multiblockTime;
        this.multiblock = multiblock;
        this.hasFluidOutput = hasFluidOutput;
        this.noBottleInput = noBottleInput;
    }

    public boolean func_77569_a(IInventory inventory, @NotNull World world) {
        boolean noBottle;
        ItemStack stack = inventory.func_70301_a(0);
        ItemStack bottle = inventory.func_70301_a(1);
        boolean bl = noBottle = bottle.func_190926_b() || bottle.func_77973_b() == Items.field_190931_a || bottle.func_190916_E() == 0;
        if (!this.noBottleInput && noBottle || this.itemOutputs.size() > 2 && bottle.func_190916_E() < ((ItemStack)this.itemOutputs.get(2).getLeft()).func_190916_E()) {
            return false;
        }
        if (this.noBottleInput && bottle.func_190916_E() > 0) {
            return false;
        }
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        ItemStack[] matchingStacks = this.ingredient.func_193365_a();
        if (matchingStacks.length == 0) {
            return false;
        }
        return Arrays.stream(matchingStacks).anyMatch(itemStack -> Container.func_195929_a((ItemStack)stack, (ItemStack)itemStack));
    }

    public boolean func_192399_d() {
        return true;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull IInventory inventory) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.CENTRIFUGE_RECIPE.get();
    }

    @NotNull
    public IRecipeType<?> func_222127_g() {
        return CENTRIFUGE_RECIPE_TYPE;
    }

    public static class Serializer<T extends CentrifugeRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @NotNull
        public T fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)CentrifugeRecipe.INGREDIENT_STRING) ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)CentrifugeRecipe.INGREDIENT_STRING)) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)CentrifugeRecipe.INGREDIENT_STRING));
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
            ArrayList<Pair<ItemStack, Float>> outputs = new ArrayList<Pair<ItemStack, Float>>();
            ArrayList<Pair<FluidStack, Float>> fluidOutput = new ArrayList<Pair<FluidStack, Float>>();
            boolean hasFluidOutput = JSONUtils.func_151209_a((JsonObject)json, (String)"hasFluidOutput", (boolean)false);
            if (!hasFluidOutput) {
                fluidOutput.add(Pair.of((Object)FluidStack.EMPTY, (Object)Float.valueOf(1.0f)));
            }
            jsonArray.forEach(jsonElement -> {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject.has("item")) {
                    String registryName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"item");
                    int count = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"count", (int)1);
                    Float chance = Float.valueOf(JSONUtils.func_151221_a((JsonObject)jsonObject, (String)"chance", (float)1.0f));
                    CompoundNBT nbt = new CompoundNBT();
                    if (jsonObject.has("nbtData")) {
                        JsonObject nbtData = JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"nbtData");
                        nbt = CompoundNBT.field_240597_a_.parse((DynamicOps)JsonOps.INSTANCE, (Object)nbtData).resultOrPartial(arg_0 -> Serializer.lambda$null$0((JsonElement)nbtData, arg_0)).orElse(nbt);
                    }
                    ItemStack stack = new ItemStack((IItemProvider)BeeInfoUtils.getItem(registryName), count);
                    if (!nbt.isEmpty()) {
                        stack.func_77982_d(nbt);
                    }
                    if (registryName.equals("minecraft:potion") && jsonObject.has("potion")) {
                        stack.func_196082_o().func_74778_a("Potion", JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"potion"));
                    }
                    outputs.add(Pair.of((Object)stack, (Object)chance));
                } else if (jsonObject.has("fluid")) {
                    String fluid = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid");
                    int amount = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"amount", (int)1);
                    Float chance = Float.valueOf(JSONUtils.func_151221_a((JsonObject)jsonObject, (String)"chance", (float)1.0f));
                    FluidStack stack = new FluidStack(BeeInfoUtils.getFluid(fluid), amount);
                    fluidOutput.add(Pair.of((Object)stack, (Object)chance));
                }
            });
            int time = JSONUtils.func_151208_a((JsonObject)json, (String)"time", (int)((Integer)Config.GLOBAL_CENTRIFUGE_RECIPE_TIME.get()));
            int multiblockTime = JSONUtils.func_151208_a((JsonObject)json, (String)"multiblockTime", (int)(time - (Integer)Config.MULTIBLOCK_RECIPE_TIME_REDUCTION.get()));
            boolean multiblock = JSONUtils.func_151209_a((JsonObject)json, (String)"multiblock", (boolean)false);
            boolean noBottle = JSONUtils.func_151209_a((JsonObject)json, (String)"noBottleInput", (boolean)false);
            return this.factory.create(id, ingredient, outputs, fluidOutput, time, multiblockTime, multiblock, hasFluidOutput, noBottle);
        }

        public T fromNetwork(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ArrayList<Pair<ItemStack, Float>> itemOutputs = new ArrayList<Pair<ItemStack, Float>>();
            ArrayList<Pair<FluidStack, Float>> fluidOutput = new ArrayList<Pair<FluidStack, Float>>();
            IntStream.range(0, buffer.readInt()).forEach(i -> itemOutputs.add(Pair.of((Object)RecipeUtils.readItemStack(buffer), (Object)Float.valueOf(buffer.readFloat()))));
            IntStream.range(0, buffer.readInt()).forEach(value -> fluidOutput.add(Pair.of((Object)FluidStack.readFromPacket((PacketBuffer)buffer), (Object)Float.valueOf(buffer.readFloat()))));
            int time = buffer.readInt();
            int multiblockTime = buffer.readInt();
            boolean multiblock = buffer.readBoolean();
            boolean hasFluidOutput = buffer.readBoolean();
            boolean noBottle = buffer.readBoolean();
            return this.factory.create(id, ingredient, itemOutputs, fluidOutput, time, multiblockTime, multiblock, hasFluidOutput, noBottle);
        }

        public void toNetwork(@NotNull PacketBuffer buffer, T recipe) {
            ((CentrifugeRecipe)recipe).ingredient.func_199564_a(buffer);
            buffer.writeInt(((CentrifugeRecipe)recipe).itemOutputs.size());
            ((CentrifugeRecipe)recipe).itemOutputs.forEach(itemStackFloatPair -> {
                ItemStack stack = (ItemStack)itemStackFloatPair.getLeft();
                RecipeUtils.writeItemStack(stack, buffer);
                buffer.writeFloat(((Float)itemStackFloatPair.getRight()).floatValue());
            });
            buffer.writeInt(((CentrifugeRecipe)recipe).fluidOutput.size());
            ((CentrifugeRecipe)recipe).fluidOutput.forEach(fluidStackFloatPair -> {
                FluidStack fluidStack = (FluidStack)fluidStackFloatPair.getLeft();
                fluidStack.writeToPacket(buffer);
                buffer.writeFloat(((Float)fluidStackFloatPair.getRight()).floatValue());
            });
            buffer.writeInt(((CentrifugeRecipe)recipe).time);
            buffer.writeInt(((CentrifugeRecipe)recipe).multiblockTime);
            buffer.writeBoolean(((CentrifugeRecipe)recipe).multiblock);
            buffer.writeBoolean(((CentrifugeRecipe)recipe).hasFluidOutput);
            buffer.writeBoolean(((CentrifugeRecipe)recipe).noBottleInput);
        }

        private static /* synthetic */ void lambda$null$0(JsonElement nbtData, String e) {
            LOGGER.warn(String.format("Could not deserialize NBT: [%s]", nbtData.toString()));
        }

        public static interface IRecipeFactory<T extends CentrifugeRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, List<Pair<ItemStack, Float>> var3, List<Pair<FluidStack, Float>> var4, int var5, int var6, boolean var7, boolean var8, boolean var9);
        }
    }
}

