/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.patreon;

import com.resourcefulbees.resourcefulbees.utils.color.Color;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public class BeeRewardData {
    private final Color color;
    private final boolean rainbow;
    private final BeeTextures textures;

    public BeeRewardData(Color colors, boolean rainbow, BeeTextures textures) {
        this.color = colors;
        this.rainbow = rainbow;
        this.textures = textures;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public BeeTextures getTextures() {
        return this.textures;
    }

    public static enum BeeTextures {
        SLIME(new ResourceLocation("resourcefulbees:textures/entity/slime/slime_bee.png")),
        OREO(new ResourceLocation("resourcefulbees:textures/entity/oreo/oreo_bee.png")),
        PIGMAN(new ResourceLocation("resourcefulbees:textures/entity/pigman/pigman_bee.png")),
        SKELETON(new ResourceLocation("resourcefulbees:textures/entity/skeleton/skeleton_bee.png")),
        WITHER(new ResourceLocation("resourcefulbees:textures/entity/wither/wither_bee.png")),
        CREEPER(new ResourceLocation("resourcefulbees:textures/entity/creeper/creeper_bee.png")),
        VANILLA(new ResourceLocation("minecraft:textures/entity/bee/bee.png")),
        BASE(new ResourceLocation("resourcefulbees:textures/entity/custom/bee.png"), new ResourceLocation("resourcefulbees:textures/entity/custom/primary_layer.png")),
        KITTEN(new ResourceLocation("resourcefulbees:textures/entity/kitten/kitten_base.png")),
        GILDED(new ResourceLocation("resourcefulbees:textures/entity/gilded/gilded_alchemist_bee.png")),
        GOLDEN(new ResourceLocation("resourcefulbees:textures/entity/gilded/golden_flower_bee.png")),
        NETHER(new ResourceLocation("resourcefulbees:textures/entity/mushroom/nether_wart_bee.png")),
        CRIMSON(new ResourceLocation("resourcefulbees:textures/entity/mushroom/crimson_alchemist_bee.png")),
        WARPED(new ResourceLocation("resourcefulbees:textures/entity/mushroom/warped_alchemist_bee.png")),
        GHAST(new ResourceLocation("resourcefulbees:textures/entity/ghast/ghast_bee.png")),
        YETI(new ResourceLocation("resourcefulbees:textures/entity/yeti/yeti_bee"));

        ResourceLocation resourceLocation;
        ResourceLocation secondaryResourceLocation;
        boolean hasSecondaryLayer;

        private BeeTextures(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
            this.hasSecondaryLayer = false;
        }

        private BeeTextures(ResourceLocation resourceLocation, ResourceLocation secondaryResourceLocation) {
            this.resourceLocation = resourceLocation;
            this.secondaryResourceLocation = secondaryResourceLocation;
            this.hasSecondaryLayer = true;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public ResourceLocation getSecondaryResourceLocation() {
            return this.secondaryResourceLocation;
        }

        public boolean hasSecondaryLayer() {
            return this.hasSecondaryLayer;
        }

        public static BeeTextures getTexture(String input) {
            try {
                return BeeTextures.valueOf(input.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ignored) {
                return BASE;
            }
        }
    }
}

