/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.network.packets;

import com.resourcefulbees.resourcefulbees.tileentity.EnderBeeconTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateBeeconMessage {
    private final ResourceLocation effectLocation;
    private final boolean active;
    private final BlockPos blockPos;

    public UpdateBeeconMessage(ResourceLocation effectName, boolean active, BlockPos blockPos) {
        this.effectLocation = effectName;
        this.active = active;
        this.blockPos = blockPos;
    }

    public static void encode(UpdateBeeconMessage message, PacketBuffer buffer) {
        buffer.func_192572_a(message.effectLocation);
        buffer.writeBoolean(message.active);
        buffer.func_179255_a(message.blockPos);
    }

    public static UpdateBeeconMessage decode(PacketBuffer buffer) {
        return new UpdateBeeconMessage(buffer.func_192575_l(), buffer.readBoolean(), buffer.func_179259_c());
    }

    public static void handle(UpdateBeeconMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null && player.field_70170_p.func_195588_v(message.blockPos) && (tileEntity = player.field_70170_p.func_175625_s(message.blockPos)) instanceof EnderBeeconTileEntity) {
                EnderBeeconTileEntity beecon = (EnderBeeconTileEntity)tileEntity;
                beecon.updateBeeconEffect(message.effectLocation, message.active);
            }
        });
        context.get().setPacketHandled(true);
    }
}

