/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.item;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyDipper
extends Item {
    @Nullable
    private BeeEntity selectedBee;

    public HoneyDipper(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ActionResultType func_195939_a(@NotNull ItemUseContext useContext) {
        if (!useContext.func_195991_k().func_201670_d()) {
            Block clickedBlock = useContext.func_195991_k().func_180495_p(useContext.func_195995_a()).func_177230_c();
            if (this.selectedBee instanceof CustomBeeEntity) {
                CustomBeeData beeData = ((CustomBeeEntity)this.selectedBee).getBeeData();
                if (beeData.hasBlockFlowers() && beeData.getBlockFlowers().contains(clickedBlock)) {
                    this.setFlowerPosition(useContext);
                    return ActionResultType.SUCCESS;
                }
            } else if (this.selectedBee != null && clickedBlock.func_203417_a((ITag)BlockTags.field_226149_I_)) {
                this.setFlowerPosition(useContext);
                return ActionResultType.SUCCESS;
            }
            TileEntity clickedTile = useContext.func_195991_k().func_175625_s(useContext.func_195995_a());
            if (this.selectedBee != null && (clickedTile instanceof BeehiveTileEntity || clickedTile instanceof ApiaryTileEntity)) {
                this.selectedBee.field_226369_bI_ = useContext.func_195995_a();
                this.sendMessageToPlayer(useContext.func_195999_j(), MessageTypes.HIVE, useContext.func_195995_a());
                this.selectedBee = null;
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(useContext);
    }

    private void setFlowerPosition(ItemUseContext useContext) {
        assert (this.selectedBee != null) : "setFlowerPos method called when selected bee was null";
        if (this.selectedBee.field_226370_bJ_.func_226503_k_()) {
            this.selectedBee.field_226370_bJ_.func_226504_l_();
        }
        this.selectedBee.func_226431_g_(useContext.func_195995_a());
        this.sendMessageToPlayer(useContext.func_195999_j(), MessageTypes.FLOWER, useContext.func_195995_a());
        this.selectedBee = null;
    }

    private void sendMessageToPlayer(PlayerEntity playerEntity, MessageTypes messageTypes, BlockPos pos) {
        assert (this.selectedBee != null) : "bee went null before message was sent to player";
        switch (messageTypes) {
            case HIVE: {
                playerEntity.func_146105_b((ITextComponent)new StringTextComponent(String.format("Hive position for [%1$s] has been set to %2$s", this.selectedBee.func_145748_c_().getString(), NBTUtil.func_186859_a((BlockPos)pos))), false);
                break;
            }
            case FLOWER: {
                playerEntity.func_146105_b((ITextComponent)new StringTextComponent(String.format("Flower position for [%1$s] has been set to %2$s", this.selectedBee.func_145748_c_().getString(), NBTUtil.func_186859_a((BlockPos)pos))), false);
                break;
            }
            case BEE_CLEARED: {
                playerEntity.func_146105_b((ITextComponent)new StringTextComponent("Bee Selection Cleared!"), false);
                break;
            }
            case BEE_SELECTED: {
                playerEntity.func_146105_b((ITextComponent)new StringTextComponent(String.format("[%1$s] has been selected!", this.selectedBee.func_145748_c_().getString())), false);
                break;
            }
        }
    }

    @NotNull
    public ActionResultType func_111207_a(@NotNull ItemStack stack, @NotNull PlayerEntity player, @NotNull LivingEntity entity, @NotNull Hand hand) {
        if (!player.field_70170_p.func_201670_d()) {
            if (entity instanceof BeeEntity && this.selectedBee == null) {
                this.selectedBee = (BeeEntity)entity;
                this.sendMessageToPlayer(player, MessageTypes.BEE_SELECTED, null);
                return ActionResultType.SUCCESS;
            }
            if (this.setEntityFlowerPos(player, entity)) {
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_111207_a(stack, player, entity, hand);
    }

    private boolean setEntityFlowerPos(PlayerEntity player, LivingEntity entity) {
        CustomBeeEntity customBee;
        if (this.selectedBee instanceof CustomBeeEntity && (customBee = (CustomBeeEntity)this.selectedBee).getBeeData().hasEntityFlower()) {
            ResourceLocation resourceLocation = customBee.getBeeData().getEntityFlower();
            if (entity.func_200600_R().getRegistryName() != null && entity.func_200600_R().getRegistryName().equals((Object)resourceLocation)) {
                customBee.setFlowerEntityID(entity.func_145782_y());
                customBee.func_226431_g_(entity.func_233580_cy_());
                this.sendMessageToPlayer(player, MessageTypes.FLOWER, entity.func_233580_cy_());
                this.selectedBee = null;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        if (!world.func_201670_d() && player.func_225608_bj_() && this.selectedBee != null) {
            this.selectedBee = null;
            this.sendMessageToPlayer(player, MessageTypes.BEE_CLEARED, null);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> textComponents, @NotNull ITooltipFlag flag) {
        if (this.selectedBee != null) {
            textComponents.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.honey_dipper.tooltip").func_230529_a_((ITextComponent)new StringTextComponent(this.selectedBee.func_145748_c_().getString())).func_240699_a_(TextFormatting.GOLD));
        }
    }

    private static enum MessageTypes {
        FLOWER,
        HIVE,
        BEE_SELECTED,
        BEE_CLEARED;

    }
}

