/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.item;

import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeepediaUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Beepedia
extends Item {
    public static final String COMPLETE_TAG = "Complete";
    public static final String CREATIVE_TAG = "Creative";

    public Beepedia(Item.Properties properties) {
        super(properties);
    }

    public void checkAndAddBees(ItemStack stack, CustomBeeEntity entity) {
        CompoundNBT nbt;
        CompoundNBT compoundNBT = nbt = stack.func_77942_o() && stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
        if (nbt.func_74767_n(CREATIVE_TAG)) {
            return;
        }
        ListNBT listNBT = nbt.func_74764_b("Bees") ? nbt.func_150295_c("Bees", 8).func_74737_b() : new ListNBT();
        if (entity != null) {
            if (!listNBT.contains((Object)StringNBT.func_229705_a_((String)entity.getBeeType()))) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)entity.getBeeType()));
            }
            listNBT.removeIf(b -> BeeRegistry.getRegistry().getBeeData(b.func_150285_a_()) == null);
            listNBT = listNBT.stream().distinct().collect(Collectors.toCollection(ListNBT::new));
            nbt.func_74757_a(COMPLETE_TAG, listNBT.size() == BeeRegistry.getRegistry().getBees().size());
            nbt.func_218657_a("Bees", (INBT)listNBT);
            stack.func_77982_d(nbt);
        }
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, @NotNull Hand hand) {
        ItemStack itemstack = playerEntity.func_184586_b(hand);
        this.checkAndAddBees(itemstack, null);
        if (world.field_72995_K) {
            BeepediaUtils.loadBeepedia(itemstack, null);
        }
        return ActionResult.func_233538_a_((Object)itemstack, (boolean)world.func_201670_d());
    }

    @NotNull
    public ActionResultType func_111207_a(@NotNull ItemStack stack, PlayerEntity player, @NotNull LivingEntity entity, @NotNull Hand hand) {
        if (entity instanceof CustomBeeEntity) {
            this.checkAndAddBees(stack, (CustomBeeEntity)entity);
            if (player.field_70170_p.field_72995_K) {
                BeepediaUtils.loadBeepedia(stack, (Entity)entity);
            }
            player.func_184611_a(hand, stack);
            return ActionResultType.SUCCESS;
        }
        return super.func_111207_a(stack, player, entity, hand);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p() != null && !stack.func_77978_p().isEmpty()) {
            if (stack.func_77978_p().func_74767_n(CREATIVE_TAG)) {
                return new TranslationTextComponent("item.resourcefulbees.creative_beepedia").func_240699_a_(TextFormatting.LIGHT_PURPLE);
            }
            if (stack.func_77978_p().func_74767_n(COMPLETE_TAG)) {
                return new StringTextComponent("\u2726 ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)super.func_200295_i(stack).func_230532_e_().func_240699_a_(TextFormatting.WHITE));
            }
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.resourcefulbees.information.beepedia").func_240699_a_(TextFormatting.GREEN));
        if (stack.func_77942_o() && stack.func_77978_p() != null && !stack.func_77978_p().isEmpty()) {
            boolean complete = stack.func_77978_p().func_74767_n(COMPLETE_TAG) || stack.func_77978_p().func_74767_n(CREATIVE_TAG);
            int total = BeeRegistry.getRegistry().getBees().size();
            int count = stack.func_77978_p().func_150295_c("Bees", 8).size();
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.home.progress").func_240699_a_(TextFormatting.GRAY).func_240702_b_(String.format("%d / %d", complete ? total : count, total)).func_240699_a_(TextFormatting.GOLD));
        }
    }

    public static boolean isCreative(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74767_n(CREATIVE_TAG);
    }
}

