/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.init;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.data.BeeTrait;
import com.resourcefulbees.resourcefulbees.data.JsonBeeTrait;
import com.resourcefulbees.resourcefulbees.init.ModSetup;
import com.resourcefulbees.resourcefulbees.registry.TraitRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import net.minecraft.item.Item;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class TraitSetup {
    private static Path dictionaryPath;

    private TraitSetup() {
        throw new IllegalStateException("Utility Class");
    }

    public static void buildCustomTraits() {
        ResourcefulBees.LOGGER.info("Registering Custom Traits...");
        TraitSetup.addTraits();
    }

    private static void parseType(Reader reader, String name) {
        Gson gson = new Gson();
        name = name.toLowerCase(Locale.ENGLISH).replace(" ", "_");
        try {
            JsonBeeTrait.JsonTrait jsonTrait = (JsonBeeTrait.JsonTrait)gson.fromJson(reader, JsonBeeTrait.JsonTrait.class);
            BeeTrait.Builder builder = new BeeTrait.Builder(name);
            TraitSetup.parseDamageImmunities(jsonTrait, builder);
            TraitSetup.parseDamageTypes(jsonTrait, builder);
            TraitSetup.parseSpecialAbilities(jsonTrait, builder);
            TraitSetup.parseParticle(jsonTrait, builder);
            TraitSetup.parsePotionImmunities(jsonTrait, builder);
            TraitSetup.parsePotionDamageEffects(jsonTrait, builder);
            TraitSetup.parseBeepediaItem(jsonTrait, builder);
            TraitRegistry.getRegistry().register(name, builder.build());
        }
        catch (JsonSyntaxException e) {
            String exception = String.format("Error was found trying to parse trait: %s. Json is invalid, validate it here : https://jsonlint.com/", name);
            throw new JsonSyntaxException(exception);
        }
    }

    private static void parseDamageImmunities(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        if (jsonTrait.getDamageImmunities() != null && jsonTrait.getDamageImmunities().length > 0) {
            Arrays.stream(jsonTrait.getDamageImmunities()).forEach(builder::addDamageImmunity);
        }
    }

    private static void parseDamageTypes(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        if (jsonTrait.getDamageTypes() != null && !jsonTrait.getDamageTypes().isEmpty()) {
            jsonTrait.getDamageTypes().forEach(damageType -> builder.addDamageType((Pair<String, Integer>)Pair.of((Object)damageType.getDamageType(), (Object)damageType.getAmplifier())));
        }
    }

    private static void parseSpecialAbilities(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        if (jsonTrait.getSpecialAbilities() != null && jsonTrait.getSpecialAbilities().length > 0) {
            for (String ability : jsonTrait.getSpecialAbilities()) {
                builder.addSpecialAbility(ability);
            }
        }
    }

    private static void parseParticle(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        if (jsonTrait.getParticleName() != null && !jsonTrait.getParticleName().isEmpty() && ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(jsonTrait.getParticleName())) instanceof BasicParticleType) {
            builder.setParticleEffect((BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(jsonTrait.getParticleName())));
        }
    }

    private static void parsePotionImmunities(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        if (jsonTrait.getPotionImmunities() != null && jsonTrait.getPotionImmunities().length > 0) {
            for (String immunity : jsonTrait.getPotionImmunities()) {
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(immunity));
                if (potion == null) continue;
                builder.addPotionImmunity(potion);
            }
        }
    }

    private static void parsePotionDamageEffects(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        if (jsonTrait.getPotionDamageEffects() != null && !jsonTrait.getPotionDamageEffects().isEmpty()) {
            jsonTrait.getPotionDamageEffects().forEach(traitPotionDamageEffect -> {
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(traitPotionDamageEffect.getEffectID()));
                if (potion != null) {
                    builder.addDamagePotionEffect((Pair<Effect, Integer>)Pair.of((Object)potion, (Object)MathHelper.func_76125_a((int)traitPotionDamageEffect.getStrength(), (int)0, (int)255)));
                }
            });
        }
    }

    private static void parseBeepediaItem(JsonBeeTrait.JsonTrait jsonTrait, BeeTrait.Builder builder) {
        Item item;
        if (jsonTrait.getBeepediaItemID() != null && !jsonTrait.getBeepediaItemID().isEmpty() && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonTrait.getBeepediaItemID()))) != null) {
            builder.setBeepediaItem(item);
        }
    }

    private static void addTraits() {
        try (Stream<Path> zipStream = Files.walk(dictionaryPath, new FileVisitOption[0]);
             Stream<Path> jsonStream = Files.walk(dictionaryPath, new FileVisitOption[0]);){
            zipStream.filter(f -> f.getFileName().toString().endsWith(".zip")).forEach(TraitSetup::addZippedType);
            jsonStream.filter(f -> f.getFileName().toString().endsWith(".json")).forEach(TraitSetup::addType);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Could not stream custom traits!!", (Throwable)e);
        }
    }

    private static void addType(Path file) {
        File f = file.toFile();
        try {
            ModSetup.parseType(f, TraitSetup::parseType);
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("File not found when parsing biome types");
        }
    }

    private static void addZippedType(Path file) {
        try (ZipFile zf = new ZipFile(file.toString());){
            zf.stream().forEach(zipEntry -> {
                if (zipEntry.getName().endsWith(".json")) {
                    try {
                        ModSetup.parseType(zf, zipEntry, TraitSetup::parseType);
                    }
                    catch (IOException e) {
                        String name = zipEntry.getName();
                        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
                        ResourcefulBees.LOGGER.error("Could not parse {} biome type from ZipFile", (Object)name);
                    }
                }
            });
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.warn("Could not read ZipFile! ZipFile: {}", (Object)file.getFileName());
        }
    }

    public static void setDictionaryPath(Path dictionaryPath) {
        TraitSetup.dictionaryPath = dictionaryPath;
    }
}

