/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.init;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.init.BeeSetup;
import com.resourcefulbees.resourcefulbees.init.BiomeDictionarySetup;
import com.resourcefulbees.resourcefulbees.init.TraitSetup;
import com.resourcefulbees.resourcefulbees.item.dispenser.ScraperDispenserBehavior;
import com.resourcefulbees.resourcefulbees.item.dispenser.ShearsDispenserBehavior;
import com.resourcefulbees.resourcefulbees.mixin.DispenserBlockInvoker;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModSetup {
    private ModSetup() {
        throw new IllegalStateException("Utility Class");
    }

    public static void initialize() {
        ModSetup.setupPaths();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ModSetup::loadResources);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> RainbowColor::init);
    }

    private static void setupPaths() {
        ResourcefulBees.LOGGER.info("Setting up config paths...");
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path rbBeesPath = Paths.get(configPath.toAbsolutePath().toString(), "resourcefulbees", "bees");
        Path rbBiomePath = Paths.get(configPath.toAbsolutePath().toString(), "resourcefulbees", "biome_dictionary");
        Path rbTraitPath = Paths.get(configPath.toAbsolutePath().toString(), "resourcefulbees", "bee_traits");
        Path rbAssetsPath = Paths.get(configPath.toAbsolutePath().toString(), "resourcefulbees", "resources");
        Path rbHoneyPath = Paths.get(configPath.toAbsolutePath().toString(), "resourcefulbees", "honey");
        BeeSetup.setBeePath(rbBeesPath);
        BeeSetup.setResourcePath(rbAssetsPath);
        BeeSetup.setHoneyPath(rbHoneyPath);
        BiomeDictionarySetup.setDictionaryPath(rbBiomePath);
        TraitSetup.setDictionaryPath(rbTraitPath);
        try {
            Files.createDirectories(rbBeesPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("failed to create \"bees\" directory");
        }
        try {
            Files.createDirectories(rbBiomePath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("failed to create \"biome_dictionary\" directory");
        }
        try {
            Files.createDirectories(rbTraitPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("failed to create \"bee_traits\" directory");
        }
        try {
            Files.createDirectory(rbAssetsPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Failed to create \"assets\" directory");
        }
        try {
            Files.createDirectories(rbHoneyPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("failed to create \"honey\" directory");
        }
        try (FileWriter file2 = new FileWriter(Paths.get(rbAssetsPath.toAbsolutePath().toString(), "pack.mcmeta").toFile());){
            String mcMetaContent = "{\"pack\":{\"pack_format\":6,\"description\":\"Resourceful Bees resource pack used for lang purposes for the user to add lang for bee/items.\"}}";
            file2.write(mcMetaContent);
        }
        catch (FileAlreadyExistsException file2) {
        }
        catch (IOException e) {
            ResourcefulBees.LOGGER.error("Failed to create pack.mcmeta file for resource loading");
        }
    }

    public static void registerDispenserBehaviors() {
        ShearsDispenserBehavior.setDefaultShearsDispenseBehavior(((DispenserBlockInvoker)Blocks.field_150367_z).invokeGetBehavior(new ItemStack((IItemProvider)Items.field_151097_aZ)));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151097_aZ.func_199767_j(), (IDispenseItemBehavior)new ShearsDispenserBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((Item)ModItems.SCRAPER.get()).func_199767_j(), (IDispenseItemBehavior)new ScraperDispenserBehavior());
    }

    public static void loadResources() {
        Minecraft.func_71410_x().func_195548_H().addPackFinder((consumer, factory) -> {
            ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)"resourcefulbees", (boolean)true, () -> new FolderPack(BeeSetup.getResourcePath().toFile()){

                public boolean isHidden() {
                    return true;
                }
            }, (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
            if (packInfo == null) {
                ResourcefulBees.LOGGER.error("Failed to load resource pack, some things may not work.");
                return;
            }
            consumer.accept(packInfo);
        });
    }

    public static void parseType(File file, BiConsumer<Reader, String> consumer) throws IOException {
        String name = file.getName();
        name = name.substring(0, name.indexOf(46));
        BufferedReader r = Files.newBufferedReader(file.toPath());
        consumer.accept(r, name);
    }

    public static void parseType(ZipFile zf, ZipEntry zipEntry, BiConsumer<Reader, String> consumer) throws IOException {
        String name = zipEntry.getName();
        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
        InputStream input = zf.getInputStream(zipEntry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        consumer.accept(reader, name);
    }
}

