/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.init;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.validation.ValidatorUtils;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowerSetup {
    public static final Logger LOGGER = LogManager.getLogger();

    private FlowerSetup() {
        throw new IllegalStateException("Utility Class");
    }

    public static void setupFlowers() {
        BeeRegistry.getRegistry().getBees().values().forEach(FlowerSetup::setupFlowers);
    }

    private static void setupFlowers(CustomBeeData customBeeData) {
        String flower = customBeeData.getFlower();
        if (ValidatorUtils.ENTITY_RESOURCE_PATTERN.matcher(flower).matches()) {
            customBeeData.setEntityFlower(new ResourceLocation(flower.replace("entity:", "")));
        } else if (ValidatorUtils.TAG_RESOURCE_PATTERN.matcher(flower).matches()) {
            ITag<Block> blockTag = BeeInfoUtils.getBlockTag(flower.replace("tag:", ""));
            if (blockTag != null) {
                blockTag.func_230236_b_().forEach(customBeeData::addBlockFlower);
            } else {
                LOGGER.warn("Could not find Tag: {}, for bee: {}", (Object)flower, (Object)customBeeData.getName());
            }
        } else {
            switch (flower) {
                case "all": {
                    BlockTags.field_226149_I_.func_230236_b_().forEach(customBeeData::addBlockFlower);
                    break;
                }
                case "small": {
                    BlockTags.field_219746_E.func_230236_b_().forEach(customBeeData::addBlockFlower);
                    break;
                }
                case "tall": {
                    BlockTags.field_226148_H_.func_230236_b_().forEach(customBeeData::addBlockFlower);
                    break;
                }
                default: {
                    Block block = BeeInfoUtils.getBlock(flower);
                    if (!BeeInfoUtils.isValidBlock(block)) break;
                    customBeeData.addBlockFlower(block);
                }
            }
        }
    }
}

