/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.entity.passive;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.MutationData;
import com.resourcefulbees.resourcefulbees.api.beedata.TraitData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.BlockOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.EntityOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.goals.BeeAngerGoal;
import com.resourcefulbees.resourcefulbees.entity.goals.BeeBreedGoal;
import com.resourcefulbees.resourcefulbees.entity.goals.BeePollinateGoal;
import com.resourcefulbees.resourcefulbees.entity.goals.BeeTemptGoal;
import com.resourcefulbees.resourcefulbees.entity.goals.BeeWanderGoal;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModEffects;
import com.resourcefulbees.resourcefulbees.tileentity.TieredBeehiveTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ResourcefulBee
extends CustomBeeEntity {
    private boolean wasColliding;
    private int numberOfMutations;
    private BeePollinateGoal pollinateGoal;
    private int explosiveCooldown = 0;

    public ResourcefulBee(EntityType<? extends BeeEntity> type, World world, CustomBeeData beeData) {
        super(type, world, beeData);
    }

    protected void func_184651_r() {
        String namespaceID = this.func_70022_Q();
        assert (namespaceID != null);
        String beeType = namespaceID.substring(namespaceID.lastIndexOf(":") + 1, namespaceID.length() - 4);
        CustomBeeData customBeeData = BeeRegistry.getRegistry().getBeeData(beeType);
        if (!customBeeData.getCombatData().isPassive()) {
            this.field_70714_bg.func_75776_a(0, (Goal)new BeeEntity.StingGoal((BeeEntity)this, (CreatureEntity)this, 1.4, true));
            this.field_70715_bh.func_75776_a(1, (Goal)new BeeAngerGoal(this).func_220794_a(new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new BeeEntity.AttackPlayerGoal((BeeEntity)this));
        }
        this.field_70714_bg.func_75776_a(1, (Goal)new EnterBeehiveGoal2());
        if (customBeeData.getBreedData().isBreedable()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new BeeBreedGoal((AnimalEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        }
        this.field_70714_bg.func_75776_a(3, (Goal)new BeeTemptGoal(this, 1.25));
        this.pollinateGoal = new BeePollinateGoal(this);
        this.field_70714_bg.func_75776_a(4, (Goal)this.pollinateGoal);
        this.field_226370_bJ_ = new FakePollinateGoal();
        this.field_70714_bg.func_75776_a(5, (Goal)new UpdateBeehiveGoal2());
        this.field_226371_bK_ = new FindBeehiveGoal2();
        this.field_70714_bg.func_75776_a(5, (Goal)this.field_226371_bK_);
        this.field_226372_bL_ = new BeeEntity.FindFlowerGoal((BeeEntity)this);
        this.field_70714_bg.func_75776_a(6, (Goal)this.field_226372_bL_);
        if (customBeeData.getMutationData().hasMutation()) {
            this.field_70714_bg.func_75776_a(7, (Goal)new FindPollinationTargetGoal2());
        }
        if (!((Boolean)Config.MANUAL_MODE.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(8, (Goal)new BeeWanderGoal(this));
        }
        this.field_70714_bg.func_75776_a(9, (Goal)new SwimGoal((MobEntity)this));
    }

    public boolean func_226422_eP_() {
        if (!this.func_226409_eA_()) {
            return false;
        }
        BlockPos pos = this.field_226369_bI_;
        if (pos != null) {
            TileEntity blockEntity = this.field_70170_p.func_175625_s(this.field_226369_bI_);
            return blockEntity instanceof TieredBeehiveTileEntity && ((TieredBeehiveTileEntity)blockEntity).isAllowedBee() || blockEntity instanceof ApiaryTileEntity && ((ApiaryTileEntity)blockEntity).isAllowedBee() || blockEntity instanceof BeehiveTileEntity;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.explosiveCooldown > 0) {
            --this.explosiveCooldown;
        }
    }

    public void setExplosiveCooldown(int cooldown) {
        this.explosiveCooldown = cooldown;
    }

    public void func_226413_eG_() {
        super.func_226413_eG_();
        this.resetCropCounter();
    }

    public boolean func_226415_eI_() {
        if (this.field_226364_bD_ <= 0 && !this.pollinateGoal.isRunning() && !this.func_226412_eE_() && this.func_70638_az() == null) {
            boolean flag = this.func_226414_eH_() || this.func_226411_eD_();
            return flag && !this.func_226417_eK_();
        }
        return false;
    }

    private void resetCropCounter() {
        this.numberOfMutations = 0;
    }

    public void func_226421_eO_() {
        ++this.numberOfMutations;
    }

    public void applyPollinationEffect() {
        MutationData mutationData = this.getBeeData().getMutationData();
        if (mutationData.hasMutation()) {
            BlockPos beePosDown;
            BlockState state;
            if (mutationData.hasEntityMutations() && this.mutateEntity()) {
                return;
            }
            for (int i = 1; i <= 2 && !this.mutateBlock(mutationData, state = this.field_70170_p.func_180495_p(beePosDown = this.func_233580_cy_().func_177979_c(i)), beePosDown); ++i) {
            }
        }
    }

    public boolean mutateEntity() {
        Map<EntityType<?>, Pair<Double, RandomCollection<EntityOutput>>> entityMutations;
        Pair<Double, RandomCollection<EntityOutput>> output;
        AxisAlignedBB box = this.getMutationBoundingBox();
        List entityList = this.field_70170_p.func_175674_a((Entity)this, box, entity -> this.getBeeData().getMutationData().getEntityMutations().get(entity.func_200600_R()) != null);
        if (!entityList.isEmpty() && (output = (entityMutations = this.getBeeData().getMutationData().getEntityMutations()).get(((Entity)entityList.get(0)).func_200600_R())) != null) {
            if ((Double)output.getLeft() >= (double)this.field_70170_p.field_73012_v.nextFloat()) {
                EntityOutput entityOutput = (EntityOutput)((RandomCollection)output.getRight()).next();
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("EntityTag", (INBT)entityOutput.getCompoundNBT());
                entityOutput.getEntityType().func_220342_a((ServerWorld)this.field_70170_p, nbt, null, null, ((Entity)entityList.get(0)).func_233580_cy_(), SpawnReason.CONVERSION, false, false);
                ((Entity)entityList.get(0)).func_70106_y();
                this.field_70170_p.func_217379_c(2005, this.func_233580_cy_().func_177979_c(1), 0);
            }
            this.func_226421_eO_();
            return true;
        }
        return false;
    }

    public boolean mutateBlock(MutationData mutationData, BlockState state, BlockPos blockPos) {
        Block block = state.func_177230_c();
        if (mutationData.getBlockMutations().containsKey(block)) {
            this.mutateBlock(mutationData.getBlockMutations().get(block), blockPos);
            this.func_226421_eO_();
            return true;
        }
        if (mutationData.getItemMutations().containsKey(block)) {
            this.mutateItem(mutationData.getItemMutations().get(block), blockPos);
            this.func_226421_eO_();
            return true;
        }
        return false;
    }

    private void mutateBlock(Pair<Double, RandomCollection<BlockOutput>> output, BlockPos blockPos) {
        if ((Double)output.getLeft() >= (double)this.field_70170_p.field_73012_v.nextFloat()) {
            BlockOutput blockOutput = (BlockOutput)((RandomCollection)output.getRight()).next();
            this.field_70170_p.func_175656_a(blockPos, blockOutput.getBlock().func_176223_P());
            if (!blockOutput.getCompoundNBT().isEmpty()) {
                TileEntity tile = this.field_70170_p.func_175625_s(blockPos);
                CompoundNBT nbt = blockOutput.getCompoundNBT();
                if (tile != null) {
                    nbt.func_74768_a("x", blockPos.func_177958_n());
                    nbt.func_74768_a("y", blockPos.func_177956_o());
                    nbt.func_74768_a("z", blockPos.func_177952_p());
                    tile.func_230337_a_(blockOutput.getBlock().func_176223_P(), nbt);
                }
            }
        }
    }

    private void mutateItem(Pair<Double, RandomCollection<ItemOutput>> output, BlockPos blockPos) {
        if ((Double)output.getLeft() >= (double)this.field_70170_p.field_73012_v.nextFloat()) {
            ItemOutput itemOutput = (ItemOutput)((RandomCollection)output.getRight()).next();
            this.field_70170_p.func_217379_c(2005, blockPos, 0);
            this.field_70170_p.func_217377_a(blockPos, false);
            ItemStack stack = new ItemStack((IItemProvider)itemOutput.getItem());
            if (!itemOutput.getCompoundNBT().isEmpty()) {
                stack.func_77982_d(itemOutput.getCompoundNBT());
            }
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), stack));
        }
    }

    private AxisAlignedBB getMutationBoundingBox() {
        return this.func_174813_aQ().func_216361_a(new Vector3d(0.0, -2.0, 0.0));
    }

    public boolean func_226439_k_(@NotNull BlockPos pos) {
        if (this.getBeeData().hasEntityFlower()) {
            return this.field_70170_p.func_73045_a(this.getFlowerEntityID()) != null;
        }
        if (this.getBeeData().hasBlockFlowers()) {
            return this.field_70170_p.func_195588_v(pos) && this.getBeeData().getBlockFlowers().contains(this.field_70170_p.func_180495_p(pos).func_177230_c());
        }
        return false;
    }

    public void func_213295_a(BlockState state, @NotNull Vector3d vector) {
        boolean isSpider;
        TraitData info = this.getBeeData().getTraitData();
        boolean bl = isSpider = info.hasSpecialAbilities() && info.getSpecialAbilities().contains("spider");
        if (state.func_203425_a(Blocks.field_196553_aF) && isSpider) {
            return;
        }
        super.func_213295_a(state, vector);
    }

    protected void func_70619_bc() {
        TraitData info = this.getBeeData().getTraitData();
        if (info.hasTraits() && info.hasSpecialAbilities()) {
            info.getSpecialAbilities().forEach(ability -> {
                switch (ability) {
                    case "teleport": {
                        this.doTeleportEffect();
                        break;
                    }
                    case "flammable": {
                        this.doFlameEffect();
                        break;
                    }
                    case "slimy": {
                        this.doSlimeEffect();
                        break;
                    }
                    case "angry": {
                        this.doAngryEffect();
                        break;
                    }
                }
            });
        }
        super.func_70619_bc();
    }

    private void doAngryEffect() {
        if (this.func_70660_b((Effect)ModEffects.CALMING.get()) == null) {
            PlayerEntity player = this.field_70170_p.func_217362_a(this.getEntity(), 20.0);
            this.func_230259_a_(player != null ? player.func_110124_au() : null);
            this.func_230260_a__(1000);
        }
    }

    private void doTeleportEffect() {
        if (this.canTeleport() && !this.hasHiveInRange() && !this.getDisruptorInRange()) {
            this.teleportRandomly();
        }
    }

    private void doFlameEffect() {
        if (this.field_70173_aa % 150 == 0) {
            this.func_70015_d(3);
        }
    }

    private void doSlimeEffect() {
        if (!this.func_205019_a((IWorldReader)this.field_70170_p) && !this.wasColliding) {
            for (int j = 0; j < 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * 1.0f * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * 1.0f * 0.5f * f1;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(SoundEvents.field_187886_fs, this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.wasColliding = true;
        }
    }

    private boolean canTeleport() {
        return !this.func_145818_k_() && this.field_70173_aa % 150 == 0 && this.field_70170_p.func_72935_r() && !this.pollinateGoal.isRunning();
    }

    protected void teleportRandomly() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 4.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(4) - 2);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 4.0;
            this.teleportToPos(d0, d1, d2);
        }
    }

    private void teleportToPos(double x, double y, double z) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable(x, y, z);
        while (blockPos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockPos).func_185904_a().func_76230_c()) {
            blockPos.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockPos);
        boolean canMove = blockstate.func_185904_a().func_76230_c();
        boolean water = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (canMove && !water) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            boolean teleported = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (teleported) {
                this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
    }

    public boolean func_70652_k(@NotNull Entity entityIn) {
        float damage = (float)this.func_233637_b_(Attributes.field_233823_f_);
        TraitData info = this.getBeeData().getTraitData();
        boolean flag = entityIn.func_70097_a(DamageSource.func_226252_a_((LivingEntity)this), damage);
        if (flag && this.getBeeData().getCombatData().removeStingerOnAttack()) {
            this.func_174815_a((LivingEntity)this, entityIn);
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_226300_q_(((LivingEntity)entityIn).func_226297_df_() + 1);
            }
        }
        if (entityIn instanceof LivingEntity) {
            int i = this.getDifficultyModifier();
            if (info.hasTraits() && info.hasDamageTypes()) {
                info.getDamageTypes().forEach(stringIntegerPair -> {
                    if (((String)stringIntegerPair.getLeft()).equals("setOnFire")) {
                        entityIn.func_70015_d(i * (Integer)stringIntegerPair.getRight());
                    }
                    if (((String)stringIntegerPair.getLeft()).equals("explosive")) {
                        this.explode(i / (Integer)stringIntegerPair.getRight());
                    }
                });
            }
            if (i > 0 && info.hasTraits() && info.hasDamagePotionEffects()) {
                info.getPotionDamageEffects().forEach(effectIntegerPair -> ((LivingEntity)entityIn).func_195064_c(new EffectInstance((Effect)effectIntegerPair.getLeft(), i * 20, ((Integer)effectIntegerPair.getRight()).intValue())));
            }
            if (this.canPoison(info)) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 0));
            }
        }
        this.func_70624_b(null);
        this.func_226449_s_((Boolean)Config.BEE_DIES_FROM_STING.get() != false && this.getBeeData().getCombatData().removeStingerOnAttack());
        this.func_184185_a(SoundEvents.field_226128_ac_, 1.0f, 1.0f);
        return flag;
    }

    private int getDifficultyModifier() {
        switch (this.field_70170_p.func_175659_aa()) {
            case EASY: {
                return 5;
            }
            case NORMAL: {
                return 10;
            }
            case HARD: {
                return 18;
            }
        }
        return 0;
    }

    private boolean canPoison(TraitData info) {
        return (Boolean)Config.BEES_INFLICT_POISON.get() != false && this.getBeeData().getCombatData().inflictsPoison() && info.hasTraits() && !info.hasDamagePotionEffects() && !info.hasDamageTypes();
    }

    private void explode(int radius) {
        if (!this.field_70170_p.field_72995_K) {
            Explosion.Mode mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
            this.field_70729_aU = true;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70146_Z.nextFloat() * (float)radius, this.explosiveCooldown > 0 ? Explosion.Mode.NONE : mode);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    @Override
    public void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.numberOfMutations = compound.func_74762_e("mutationCount");
    }

    @Override
    public void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("mutationCount", this.numberOfMutations);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)this.beeData.getSpawnEggItemRegistryObject().get());
    }

    public class UpdateBeehiveGoal2
    extends BeeEntity.UpdateBeehiveGoal {
        public UpdateBeehiveGoal2() {
            super((BeeEntity)ResourcefulBee.this);
        }

        public boolean func_225506_g_() {
            if (!((Boolean)Config.MANUAL_MODE.get()).booleanValue()) {
                return super.func_225506_g_();
            }
            return false;
        }
    }

    public class FakePollinateGoal
    extends BeeEntity.PollinateGoal {
        public FakePollinateGoal() {
            super((BeeEntity)ResourcefulBee.this);
        }

        public boolean func_226503_k_() {
            return ResourcefulBee.this.pollinateGoal.isRunning();
        }

        public void func_226504_l_() {
            ResourcefulBee.this.pollinateGoal.cancel();
        }
    }

    public class FindBeehiveGoal2
    extends BeeEntity.FindBeehiveGoal {
        public FindBeehiveGoal2() {
            super((BeeEntity)ResourcefulBee.this);
        }

        public boolean func_225506_g_() {
            return ResourcefulBee.this.field_226369_bI_ != null && !ResourcefulBee.this.func_213394_dL() && ResourcefulBee.this.func_226415_eI_() && !this.func_226476_d_(ResourcefulBee.this.field_226369_bI_) && ResourcefulBee.this.func_226422_eP_();
        }

        public void func_226479_l_() {
            if (!((Boolean)Config.MANUAL_MODE.get()).booleanValue()) {
                super.func_226479_l_();
            }
        }
    }

    protected class FindPollinationTargetGoal2
    extends BeeEntity.FindPollinationTargetGoal {
        public FindPollinationTargetGoal2() {
            super((BeeEntity)ResourcefulBee.this);
        }

        public boolean func_225506_g_() {
            if (ResourcefulBee.this.numberOfMutations >= ResourcefulBee.this.getBeeData().getMutationData().getMutationCount()) {
                return false;
            }
            if (ResourcefulBee.this.field_70146_Z.nextFloat() < 0.3f) {
                return false;
            }
            return ResourcefulBee.this.func_226411_eD_();
        }

        public void func_75246_d() {
            MutationData mutationData;
            if (ResourcefulBee.this.field_70173_aa % 5 == 0 && (mutationData = ResourcefulBee.this.getBeeData().getMutationData()).hasMutation() && (mutationData.hasBlockMutations() || mutationData.hasItemMutations() || mutationData.hasEntityMutations())) {
                ResourcefulBee.this.applyPollinationEffect();
            }
        }
    }

    public class EnterBeehiveGoal2
    extends BeeEntity.EnterBeehiveGoal {
        public EnterBeehiveGoal2() {
            super((BeeEntity)ResourcefulBee.this);
        }

        public boolean func_225506_g_() {
            if (ResourcefulBee.this.func_226409_eA_() && ResourcefulBee.this.func_226415_eI_() && ResourcefulBee.this.field_226369_bI_ != null && ResourcefulBee.this.field_226369_bI_.func_218137_a((IPosition)ResourcefulBee.this.func_213303_ch(), 2.0)) {
                TileEntity tileentity = ResourcefulBee.this.field_70170_p.func_175625_s(ResourcefulBee.this.field_226369_bI_);
                if (tileentity instanceof BeehiveTileEntity) {
                    BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
                    if (!beehivetileentity.func_226970_h_()) {
                        return true;
                    }
                    ResourcefulBee.this.field_226369_bI_ = null;
                } else if (tileentity instanceof ApiaryTileEntity) {
                    ApiaryTileEntity beehivetileentity = (ApiaryTileEntity)tileentity;
                    if (!beehivetileentity.isFullOfBees()) {
                        return true;
                    }
                    ResourcefulBee.this.field_226369_bI_ = null;
                }
            }
            return false;
        }

        public boolean func_225507_h_() {
            return false;
        }

        public void func_75249_e() {
            TileEntity tileentity;
            if (ResourcefulBee.this.field_226369_bI_ != null && (tileentity = ResourcefulBee.this.field_70170_p.func_175625_s(ResourcefulBee.this.field_226369_bI_)) != null) {
                if (tileentity instanceof BeehiveTileEntity) {
                    BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileentity;
                    beehivetileentity.func_226961_a_((Entity)ResourcefulBee.this, ResourcefulBee.this.func_226411_eD_());
                } else if (tileentity instanceof ApiaryTileEntity) {
                    ApiaryTileEntity beehivetileentity = (ApiaryTileEntity)tileentity;
                    beehivetileentity.tryEnterHive((Entity)ResourcefulBee.this, ResourcefulBee.this.func_226411_eD_(), false);
                }
            }
        }
    }
}

