/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.entity.goals;

import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;

public class BeeTemptGoal
extends Goal {
    private static final EntityPredicate ENTITY_PREDICATE = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final CustomBeeEntity beeEntity;
    private final double speed;
    protected PlayerEntity closestPlayer;
    private int delayTemptCounter;

    public BeeTemptGoal(CustomBeeEntity beeEntity, double speedIn) {
        this.beeEntity = beeEntity;
        this.speed = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(beeEntity.func_70661_as() instanceof GroundPathNavigator) && !(beeEntity.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.closestPlayer = this.beeEntity.field_70170_p.func_217370_a(ENTITY_PREDICATE, (LivingEntity)this.beeEntity);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.func_184614_ca()) || this.isTempting(this.closestPlayer.func_184592_cb());
    }

    protected boolean isTempting(ItemStack stack) {
        return BeeInfoUtils.isValidBreedItem(stack, this.beeEntity.getBeeData().getBreedData());
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.closestPlayer = null;
        this.beeEntity.func_70661_as().func_75499_g();
        this.delayTemptCounter = 100;
    }

    public void func_75246_d() {
        this.beeEntity.func_70671_ap().func_75651_a((Entity)this.closestPlayer, (float)(this.beeEntity.func_184649_cE() + 20), (float)this.beeEntity.func_70646_bf());
        if (this.beeEntity.func_70068_e((Entity)this.closestPlayer) < 6.25) {
            this.beeEntity.func_70661_as().func_75499_g();
        } else {
            this.beeEntity.func_70661_as().func_75497_a((Entity)this.closestPlayer, this.speed);
        }
    }
}

