/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.entity.goals;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.mixin.BeeEntityAccessor;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class BeePollinateGoal
extends Goal {
    private int pollinationTicks;
    private int lastPollinationTick;
    private boolean running;
    private Vector3d nextTarget;
    private int ticks;
    private final CustomBeeEntity bee;
    private Vector3d boundingBox;
    private static final ArrayList<BlockPos> positionOffsets = new ArrayList();

    public BeePollinateGoal(CustomBeeEntity beeEntity) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.bee = beeEntity;
    }

    public boolean canBeeStart() {
        if (this.bee.field_226367_bG_ > 0) {
            return false;
        }
        if (this.bee.func_226411_eD_()) {
            return false;
        }
        if (this.bee.func_70681_au().nextFloat() < 0.7f) {
            return false;
        }
        if (!(((Boolean)Config.MANUAL_MODE.get()).booleanValue() && !this.bee.getBeeData().hasEntityFlower() || this.bee.field_226368_bH_ != null || this.bee.field_70173_aa >= 20 && this.bee.field_70173_aa % 5 != 0)) {
            Optional<BlockPos> optional = this.findFlower(5.0, this.bee.getBeeData().hasEntityFlower(), this.bee.getBeeData().getEntityFlower());
            if (optional.isPresent()) {
                this.bee.field_226368_bH_ = optional.get();
                this.bee.func_70661_as().func_75492_a((double)this.bee.field_226368_bH_.func_177958_n() + 0.5, (double)this.bee.field_226368_bH_.func_177956_o() + 0.5, (double)this.bee.field_226368_bH_.func_177952_p() + 0.5, 1.2);
                return true;
            }
            this.bee.field_226367_bG_ = 600;
        } else if (this.bee.field_226368_bH_ != null) {
            this.bee.func_70661_as().func_75492_a((double)this.bee.field_226368_bH_.func_177958_n() + 0.5, (double)this.bee.field_226368_bH_.func_177956_o() + 0.5, (double)this.bee.field_226368_bH_.func_177952_p() + 0.5, 1.2);
            return true;
        }
        return false;
    }

    public boolean canBeeContinue() {
        if (!this.running) {
            return false;
        }
        if (this.bee.field_226368_bH_ == null) {
            return false;
        }
        if (this.completedPollination()) {
            return this.bee.func_70681_au().nextFloat() < 0.2f;
        }
        if (!this.bee.func_226439_k_(this.bee.field_226368_bH_)) {
            this.bee.field_226368_bH_ = null;
            return false;
        }
        return true;
    }

    private boolean completedPollination() {
        return this.pollinationTicks > 400;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void cancel() {
        this.clearTask();
        this.running = false;
    }

    public boolean func_75250_a() {
        return !this.bee.func_233678_J__() && this.canBeeStart();
    }

    public boolean func_75253_b() {
        return !this.bee.func_233678_J__() && this.canBeeContinue();
    }

    public void func_75249_e() {
        this.pollinationTicks = 0;
        this.ticks = 0;
        this.lastPollinationTick = 0;
        this.running = true;
        this.bee.func_226426_eu_();
        super.func_75249_e();
    }

    public void func_75251_c() {
        if (this.completedPollination()) {
            this.bee.func_226426_eu_();
            ((BeeEntityAccessor)((Object)this.bee)).callSetFlag(8, true);
        }
        this.running = false;
        this.bee.func_70661_as().func_75499_g();
        this.bee.field_226367_bG_ = 200;
    }

    public void clearTask() {
        if (!((Boolean)Config.MANUAL_MODE.get()).booleanValue()) {
            this.bee.field_226368_bH_ = null;
            this.bee.setFlowerEntityID(-1);
            this.boundingBox = null;
        }
    }

    public void func_75246_d() {
        ++this.ticks;
        if (this.ticks > 600) {
            this.clearTask();
        } else if (!this.bee.getBeeData().hasEntityFlower() || this.bee.getFlowerEntityID() >= 0) {
            if (this.bee.field_70173_aa % 5 == 0 && this.bee.getBeeData().hasEntityFlower()) {
                Entity flowerEntity = this.bee.field_70170_p.func_73045_a(this.bee.getFlowerEntityID());
                if (flowerEntity != null) {
                    this.boundingBox = new Vector3d(flowerEntity.func_174813_aQ().func_189972_c().func_82615_a(), flowerEntity.func_174813_aQ().field_72337_e, flowerEntity.func_174813_aQ().func_189972_c().func_82616_c());
                    this.bee.func_226431_g_(flowerEntity.func_233580_cy_());
                } else {
                    this.clearTask();
                }
            }
            if (this.bee.field_226368_bH_ != null) {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)this.bee.field_226368_bH_).func_72441_c(0.0, (double)0.6f, 0.0);
                if (this.boundingBox != null) {
                    vector3d = this.boundingBox.func_72441_c(0.0, (double)0.4f, 0.0);
                }
                if (vector3d.func_72438_d(this.bee.func_213303_ch()) > 1.0) {
                    this.nextTarget = vector3d;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = vector3d;
                    }
                    boolean closeToTarget = this.bee.func_213303_ch().func_72438_d(this.nextTarget) <= 0.1;
                    boolean shouldMoveToNewTarget = true;
                    if (!closeToTarget && this.ticks > 600) {
                        this.clearTask();
                    } else {
                        if (closeToTarget) {
                            if (this.bee.func_70681_au().nextInt(25) == 0) {
                                this.nextTarget = new Vector3d(vector3d.func_82615_a() + this.getRandomOffset(), vector3d.func_82617_b(), vector3d.func_82616_c() + this.getRandomOffset());
                                this.bee.func_70661_as().func_75499_g();
                            } else {
                                shouldMoveToNewTarget = false;
                            }
                            this.bee.func_70671_ap().func_220679_a(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c());
                        }
                        if (shouldMoveToNewTarget) {
                            this.moveToNextTarget();
                        }
                        ++this.pollinationTicks;
                        if (this.bee.func_70681_au().nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                            this.lastPollinationTick = this.pollinationTicks;
                            this.bee.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }
    }

    private void moveToNextTarget() {
        this.bee.func_70605_aq().func_75642_a(this.nextTarget.func_82615_a(), this.nextTarget.func_82617_b(), this.nextTarget.func_82616_c(), 0.5);
    }

    private double getRandomOffset() {
        return ((double)this.bee.func_70681_au().nextFloat() * 2.0 - 1.0) * 0.33333334;
    }

    public Optional<BlockPos> findFlower(double range, boolean isEntity, ResourceLocation entityRegistryName) {
        BlockPos beePos = this.bee.func_233580_cy_();
        if (!isEntity) {
            BlockPos.Mutable flowerPos = beePos.func_239590_i_();
            for (BlockPos blockPos : positionOffsets) {
                flowerPos.func_239621_a_((Vector3i)beePos, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                if (!this.getFlowerBlockPredicate().test((BlockPos)flowerPos)) continue;
                return Optional.of(flowerPos);
            }
            return Optional.empty();
        }
        List entityList = this.bee.field_70170_p.func_175674_a((Entity)this.bee, new AxisAlignedBB(this.bee.func_233580_cy_()).func_186662_g(range), entity -> entity.func_70022_Q() != null && entity.func_70022_Q().equals(entityRegistryName.toString()));
        if (!entityList.isEmpty()) {
            Entity firstEntity = (Entity)entityList.get(0);
            this.bee.setFlowerEntityID(firstEntity.func_145782_y());
            return Optional.of(firstEntity.func_233580_cy_());
        }
        return Optional.empty();
    }

    public Predicate<BlockPos> getFlowerBlockPredicate() {
        return pos -> {
            if (this.bee.field_70170_p != null && this.bee.getBeeData().hasBlockFlowers()) {
                if (!MathUtils.inRangeInclusive(pos.func_177956_o(), 0, 256)) {
                    return false;
                }
                BlockState state = this.bee.field_70170_p.func_180495_p(pos);
                if (state.func_196958_f()) {
                    return false;
                }
                return this.bee.getBeeData().getBlockFlowers().contains(state.func_177230_c());
            }
            return false;
        };
    }

    static {
        int i = 0;
        while ((double)i <= 5.0) {
            int j = 0;
            while ((double)j < 5.0) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        positionOffsets.add(new BlockPos(k, i - 1, l));
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
    }
}

