/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.patchouli;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class AnimatedImageComponent
implements ICustomComponent {
    IVariable image;
    IVariable ticksPerFrame;
    IVariable texHeight;
    IVariable texWidth;
    IVariable height;
    IVariable width;
    IVariable scale;
    private transient ResourceLocation animatedImage;
    private transient int xOffset;
    private transient int yOffset;
    private transient int currentFrame = 0;
    private transient int textureHeight;
    private transient int textureWidth;
    private transient int imageHeight;
    private transient int imageWidth;
    private transient float imageScale;
    private int frames;

    public void build(int x, int y, int page) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void render(@NotNull MatrixStack matrixStack, @NotNull IComponentRenderContext context, float v, int i, int i1) {
        if (context.getTicksInBook() % 2 == 0) {
            ++this.currentFrame;
        }
        if (this.currentFrame >= this.frames) {
            this.currentFrame = 0;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.animatedImage);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)this.xOffset, (int)this.yOffset, (float)0.0f, (float)((float)this.imageHeight * (float)this.currentFrame), (int)((int)((float)this.imageWidth * this.imageScale)), (int)((int)((float)this.imageHeight * this.imageScale)), (int)this.textureWidth, (int)this.textureHeight);
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.image = (IVariable)lookup.apply(this.image);
        this.scale = (IVariable)lookup.apply(this.scale);
        this.ticksPerFrame = (IVariable)lookup.apply(this.ticksPerFrame);
        this.animatedImage = new ResourceLocation(this.image.asString());
        this.texHeight = (IVariable)lookup.apply(this.texHeight);
        this.texWidth = (IVariable)lookup.apply(this.texWidth);
        this.textureHeight = this.texHeight.asNumber().intValue();
        this.textureWidth = this.texWidth.asNumber().intValue();
        this.imageScale = this.scale.asNumber().floatValue();
        this.imageHeight = this.height.asNumber().intValue();
        this.imageWidth = this.width.asNumber().intValue();
        this.frames = this.textureHeight / this.imageHeight;
    }
}

