/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei.ingredients;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EntityIngredient {
    private final String beeType;
    private final CustomBeeData beeData;
    private final float rotation;

    public EntityIngredient(String beeType, float rotation) {
        this.beeType = beeType;
        this.beeData = BeeRegistry.getRegistry().getBeeData(beeType);
        this.rotation = rotation;
    }

    public String getBeeType() {
        return this.beeType;
    }

    public float getRotation() {
        return this.rotation;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("entity.resourcefulbees." + this.beeType + "_bee");
    }

    public List<ITextComponent> getTooltip() {
        String[] descTooltip;
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>(BeeInfoUtils.getBeeLore(this.beeData));
        String desc = I18n.func_135052_a((String)"tooltip.resourcefulbees.jei.click_bee_info", (Object[])new Object[0]);
        for (String s : descTooltip = desc.split("\\r?\\n")) {
            tooltip.add((ITextComponent)new StringTextComponent(s).func_240699_a_(TextFormatting.GOLD));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip.add((ITextComponent)new StringTextComponent(this.beeData.getEntityTypeRegistryID().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        return tooltip;
    }
}

