/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowersCategory
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beeflowers.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "bee_pollination_flowers");
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();

    public FlowersCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.bee_pollination_flowers", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 0, 24, 75).addPadding(0, 0, 0, 0).build(), guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.GOLD_FLOWER.get())), Recipe.class);
    }

    private static ItemStack getErrorItem(Block block) {
        return new ItemStack((IItemProvider)Items.field_221803_eL).func_200302_a((ITextComponent)new StringTextComponent(block.getRegistryName() != null ? block.getRegistryName().toString() : "Unknown Block ID"));
    }

    public static List<Recipe> getFlowersRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        BEE_REGISTRY.getBees().forEach((s, beeData) -> {
            if (beeData.hasBlockFlowers()) {
                if (beeData.getBlockFlowers().stream().allMatch(FlowingFluidBlock.class::isInstance)) {
                    Set<Fluid> fluids = beeData.getBlockFlowers().stream().map(b -> ((FlowingFluidBlock)b).getFluid().func_210198_f()).collect(Collectors.toSet());
                    recipes.add(new Recipe(fluids, null, beeData.getName()));
                } else {
                    List<ItemStack> items = beeData.getBlockFlowers().stream().map(b -> b.func_199767_j() != Items.field_190931_a ? new ItemStack((IItemProvider)b.func_199767_j()) : FlowersCategory.getErrorItem(b)).collect(Collectors.toList());
                    recipes.add(new Recipe(null, items, beeData.getName()));
                }
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(@NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.flowerItems != null) {
            ArrayList<List> items = new ArrayList<List>();
            items.add(recipe.flowerItems);
            ingredients.setInputLists(VanillaTypes.ITEM, items);
        } else if (recipe.flowerFluids != null) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (Fluid element : recipe.flowerFluids) {
                FluidStack fluid = new FluidStack(element, 1000);
                fluids.add(fluid);
            }
            ArrayList<ArrayList<FluidStack>> fluidFluids = new ArrayList<ArrayList<FluidStack>>();
            fluidFluids.add(fluids);
            ingredients.setInputLists(VanillaTypes.FLUID, fluidFluids);
        }
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @Override
    public void setRecipe(@NotNull IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.flowerFluids != null) {
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(1, true, 4, 58);
            fluidStacks.set(1, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        } else {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(1, true, 3, 57);
            itemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 4, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    public static class Recipe {
        private final Set<Fluid> flowerFluids;
        private final List<ItemStack> flowerItems;
        private final String beeType;

        public Recipe(@Nullable Set<Fluid> flowerFluids, @Nullable List<ItemStack> flowerItems, String beeType) {
            this.flowerFluids = flowerFluids;
            this.flowerItems = flowerItems;
            this.beeType = beeType;
        }

        public String getBeeType() {
            return this.beeType;
        }
    }
}

