/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.MutationData;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.RecipeUtils;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityToEntity
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beemutation.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "entity_to_entity_mutation");
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();
    private final IDrawable nonRegisteredEgg;
    private static final String DARK_PURPLE = "dark_purple";

    public EntityToEntity(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.entity_to_entity_mutation", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, -12, 0, 99, 75).addPadding(0, 0, 0, 0).build(), (IDrawable)guiHelper.createDrawable(ICONS, 0, 0, 16, 16), Recipe.class);
        this.nonRegisteredEgg = guiHelper.createDrawable(ICONS, 41, 0, 16, 16);
    }

    public static List<Recipe> getMutationRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        BEE_REGISTRY.getBees().forEach((s, beeData) -> {
            MutationData mutationData = beeData.getMutationData();
            if (mutationData.hasMutation() && mutationData.hasEntityMutations()) {
                beeData.getMutationData().getEntityMutations().forEach((entityType, doubleRandomCollectionPair) -> {
                    SpawnEggItem inputSpawnEgg = SpawnEggItem.func_200889_b((EntityType)entityType);
                    ItemStack inputEgg = inputSpawnEgg != null ? new ItemStack((IItemProvider)inputSpawnEgg) : null;
                    ((RandomCollection)doubleRandomCollectionPair.getRight()).forEach(entityOutput -> {
                        SpawnEggItem outputSpawnEgg = SpawnEggItem.func_200889_b(entityOutput.getEntityType());
                        ItemStack outputEgg = outputSpawnEgg != null ? new ItemStack((IItemProvider)outputSpawnEgg) : null;
                        double effectiveWeight = RecipeUtils.getEffectiveWeight((RandomCollection)doubleRandomCollectionPair.getRight(), entityOutput.getWeight());
                        recipes.add(new Recipe((EntityType<?>)entityType, entityOutput.getEntityType(), inputEgg, outputEgg, entityOutput.getCompoundNBT(), beeData.getName(), effectiveWeight, (Double)doubleRandomCollectionPair.getLeft()));
                    });
                });
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.input != null) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.input);
        }
        if (recipe.output != null) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
        }
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(Recipe recipe, double mouseX, double mouseY) {
        List<ITextComponent> list = RecipeUtils.getTooltipStrings(mouseX, mouseY, recipe.chance);
        if (!list.isEmpty()) {
            return list;
        }
        if (mouseX > 64.0 && mouseX < 84.0 && mouseY > 47.0 && mouseY < 66.0) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            this.addTooltip(recipe, tooltip);
            return tooltip;
        }
        if (mouseX > 15.0 && mouseX < 32.0 && mouseY > 57.0 && mouseY < 74.0) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            tooltip.add((ITextComponent)recipe.inputEntityType.func_212546_e().func_230531_f_());
            tooltip.addAll(BeeInfoUtils.getBeeLore(recipe.inputEntity));
            if (recipe.outputEntityType.getRegistryName() != null) {
                tooltip.add((ITextComponent)new StringTextComponent(recipe.outputEntityType.getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            return tooltip;
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }

    @Override
    public void setRecipe(@NotNull IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 16, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
        ingredientStacks.init(1, false, 15, 57);
    }

    @NotNull
    private ITooltipCallback<ItemStack> getItemStackTooltipCallback(@NotNull Recipe recipe) {
        return (slotIndex, isInputStack, stack, tooltip) -> {
            if (slotIndex == 0) {
                tooltip.clear();
                this.addTooltip(recipe, tooltip);
            }
        };
    }

    private void addTooltip(@NotNull Recipe recipe, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)recipe.outputEntityType.func_212546_e().func_230531_f_());
        tooltip.addAll(BeeInfoUtils.getBeeLore(recipe.ouputEntity));
        if (recipe.outputEntityType.getRegistryName() != null) {
            tooltip.add((ITextComponent)new StringTextComponent(recipe.outputEntityType.getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (!recipe.outputNBT.isEmpty()) {
            if (BeeInfoUtils.isShiftPressed()) {
                List<String> lore = BeeInfoUtils.getLoreLines(recipe.outputNBT);
                lore.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)DARK_PURPLE)))));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.resourcefulbees.jei.tooltip.show_nbt").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)DARK_PURPLE))));
            }
        }
    }

    public void draw(@NotNull Recipe recipe, @NotNull MatrixStack stack, double mouseX, double mouseY) {
        RecipeUtils.drawMutationScreen(stack, this.beeHive, this.info, recipe.weight, recipe.chance);
        RenderUtils.renderEntity(stack, recipe.inputEntity, (World)Minecraft.func_71410_x().field_71441_e, 14.0f, 55.0f, 45.0f, 1.0f);
        RenderUtils.renderEntity(stack, recipe.ouputEntity, (World)Minecraft.func_71410_x().field_71441_e, 64.0f, 45.0f, -45.0f, 1.0f);
    }

    public static class Recipe {
        private final EntityType<?> inputEntityType;
        private final EntityType<?> outputEntityType;
        private final ItemStack input;
        private final ItemStack output;
        private final String beeType;
        private Entity ouputEntity = null;
        private Entity inputEntity = null;
        private final double weight;
        private final double chance;
        public final CompoundNBT outputNBT;

        public Recipe(EntityType<?> inputEntityType, EntityType<?> outputEntityType, ItemStack inputEgg, ItemStack outputEgg, CompoundNBT outputNBT, String beeType, double weight, double chance) {
            this.inputEntityType = inputEntityType;
            this.outputEntityType = outputEntityType;
            this.input = inputEgg;
            this.output = outputEgg;
            this.outputNBT = outputNBT;
            this.beeType = beeType;
            this.weight = weight;
            this.chance = chance;
            this.ouputEntity = this.outputEntityType.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
            if (!this.outputNBT.isEmpty()) {
                CompoundNBT nbt = this.ouputEntity.func_189511_e(new CompoundNBT());
                nbt.func_197643_a(this.outputNBT);
                this.ouputEntity.func_70020_e(nbt);
            }
            this.inputEntity = this.inputEntityType.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        }
    }
}

