/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class EntityFlowerCategory
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beeentityflowers.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "bee_pollination_entity_flowers");
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();
    private final IDrawable nonRegisteredEgg;

    public EntityFlowerCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.bee_pollination_entity_flowers", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 0, 100, 75).addPadding(0, 0, 0, 0).build(), guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.GOLD_FLOWER.get())), Recipe.class);
        this.nonRegisteredEgg = guiHelper.createDrawable(ICONS, 41, 0, 16, 16);
    }

    public static List<Recipe> getFlowersRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        BEE_REGISTRY.getBees().forEach((s, beeData) -> {
            EntityType<?> entityType;
            if (beeData.hasEntityFlower() && (entityType = BeeInfoUtils.getEntityType(beeData.getEntityFlower())) != null) {
                SpawnEggItem spawnEggItem = SpawnEggItem.func_200889_b(entityType);
                recipes.add(new Recipe(beeData.getName(), entityType, spawnEggItem != null ? new ItemStack((IItemProvider)spawnEggItem) : null));
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.spawnEgg != null) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.spawnEgg);
        }
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @Override
    public void setRecipe(IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        if (recipe.spawnEgg != null) {
            itemStacks.init(0, false, 41, 55);
            itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            itemStacks.addTooltipCallback((slotIndex, isInputStack, stack, tooltip) -> {
                if (slotIndex == 0) {
                    tooltip.clear();
                    tooltip.add(recipe.entityType.func_212546_e().func_230531_f_());
                    if (recipe.entityType.getRegistryName() != null) {
                        tooltip.add(new StringTextComponent(recipe.entityType.getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
                    }
                }
            });
        }
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 41, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(@NotNull Recipe recipe, double mouseX, double mouseY) {
        if (recipe.spawnEgg == null && mouseX > 41.0 && mouseX < 57.0 && mouseY > 55.0 && mouseY < 71.0) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            tooltip.add((ITextComponent)recipe.entityType.func_212546_e().func_230531_f_());
            if (recipe.entityType.getRegistryName() != null) {
                tooltip.add((ITextComponent)new StringTextComponent(recipe.entityType.getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
            }
            return tooltip;
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }

    public void draw(@NotNull Recipe recipe, @NotNull MatrixStack stack, double mouseX, double mouseY) {
        if (recipe.spawnEgg == null) {
            this.nonRegisteredEgg.draw(stack, 42, 56);
        }
    }

    public static class Recipe {
        private final String beeType;
        private final EntityType<?> entityType;
        private final ItemStack spawnEgg;

        public Recipe(String beeType, EntityType<?> entityType, ItemStack spawnEgg) {
            this.beeType = beeType;
            this.entityType = entityType;
            this.spawnEgg = spawnEgg;
        }
    }
}

