/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.MutationData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.BlockOutput;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.RecipeUtils;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMutation
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beemutation.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "block_mutation");
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();

    public BlockMutation(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.block_mutation", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, -12, 0, 99, 75).addPadding(0, 0, 0, 0).build(), (IDrawable)guiHelper.createDrawable(ICONS, 0, 0, 16, 16), Recipe.class);
    }

    public static List<Recipe> getMutationRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        BEE_REGISTRY.getBees().forEach((s, beeData) -> {
            MutationData mutationData = beeData.getMutationData();
            if (mutationData.hasMutation()) {
                if (mutationData.hasBlockTagMutations()) {
                    mutationData.getJeiBlockTagMutations().forEach((iTag, doubleRandomCollectionPair) -> ((RandomCollection)doubleRandomCollectionPair.getRight()).forEach(blockOutput -> recipes.add(new Recipe(null, (ITag<?>)iTag, (BlockOutput)blockOutput, (Double)doubleRandomCollectionPair.getLeft(), RecipeUtils.getEffectiveWeight((RandomCollection)doubleRandomCollectionPair.getRight(), blockOutput.getWeight()), (String)s))));
                }
                if (mutationData.hasJeiBlockMutations()) {
                    mutationData.getJeiBlockMutations().forEach((block, doubleRandomCollectionPair) -> ((RandomCollection)doubleRandomCollectionPair.getRight()).forEach(blockOutput -> recipes.add(new Recipe((Block)block, null, (BlockOutput)blockOutput, (Double)doubleRandomCollectionPair.getLeft(), RecipeUtils.getEffectiveWeight((RandomCollection)doubleRandomCollectionPair.getRight(), blockOutput.getWeight()), (String)s))));
                }
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.blockInput instanceof FlowingFluidBlock || recipe.tagInput != null && recipe.tagInput.func_230236_b_().get(0) instanceof Fluid) {
            RecipeUtils.setFluidInput(ingredients, recipe.tagInput, recipe.blockInput);
        } else {
            RecipeUtils.setBlockInput(ingredients, recipe.tagInput, recipe.blockInput);
        }
        if (recipe.blockOutput.getBlock() instanceof FlowingFluidBlock) {
            RecipeUtils.setFluidOutput(recipe.blockOutput.getBlock(), recipe.blockOutput.getCompoundNBT(), ingredients);
        } else {
            RecipeUtils.setBlockOutput(recipe.blockOutput.getBlock(), recipe.blockOutput.getCompoundNBT(), ingredients);
        }
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(Recipe recipe, double mouseX, double mouseY) {
        List list = RecipeUtils.getTooltipStrings(mouseX, mouseY, recipe.chance);
        return list.isEmpty() ? super.getTooltipStrings((Object)recipe, mouseX, mouseY) : list;
    }

    @Override
    public void setRecipe(@NotNull IRecipeLayout iRecipeLayout, Recipe recipe, @NotNull IIngredients ingredients) {
        if (recipe.blockInput instanceof FlowingFluidBlock || recipe.tagInput != null && recipe.tagInput.func_230236_b_().get(0) instanceof Fluid) {
            if (recipe.blockOutput.getBlock() instanceof FlowingFluidBlock) {
                this.setFluidToFluidRecipe(iRecipeLayout, recipe, ingredients);
            } else {
                this.setFluidToBlockRecipe(iRecipeLayout, recipe, ingredients);
            }
        } else if (recipe.blockOutput.getBlock() instanceof FlowingFluidBlock) {
            this.setBlockToFluidRecipe(iRecipeLayout, recipe, ingredients);
        } else {
            this.setBlockToBlockRecipe(iRecipeLayout, recipe, ingredients);
        }
    }

    public void setBlockToBlockRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        RecipeUtils.addMutationToolTip(recipe, RecipeUtils.setGuiItemStacksGroup(iRecipeLayout, ingredients));
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 16, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    public void setBlockToFluidRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 66, 49);
        itemStacks.init(0, false, 15, 57);
        fluidStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        this.addMutationTooltip(recipe, itemStacks, fluidStacks);
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 16, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    public void setFluidToBlockRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
        fluidStacks.init(0, false, 16, 58);
        itemStacks.init(0, true, 65, 48);
        fluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        itemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        this.addMutationTooltip(recipe, itemStacks, fluidStacks);
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 16, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    private void addMutationTooltip(Recipe recipe, IGuiItemStackGroup itemStacks, IGuiFluidStackGroup fluidStacks) {
        RecipeUtils.addMutationToolTip(recipe, itemStacks);
        RecipeUtils.addMutationToolTip(recipe, fluidStacks);
    }

    public void setFluidToFluidRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
        fluidStacks.init(0, false, 66, 49);
        fluidStacks.init(1, true, 16, 58);
        fluidStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        fluidStacks.set(1, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        RecipeUtils.addMutationToolTip(recipe, fluidStacks);
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 16, 10);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    public void draw(Recipe recipe, @NotNull MatrixStack stack, double mouseX, double mouseY) {
        RecipeUtils.drawMutationScreen(stack, this.beeHive, this.info, recipe.weight, recipe.chance);
    }

    protected static class Recipe {
        @Nullable
        private final Block blockInput;
        @Nullable
        private final ITag<?> tagInput;
        @NotNull
        private final BlockOutput blockOutput;
        private final double chance;
        private final double weight;
        @NotNull
        private final String beeType;

        public Recipe(@Nullable Block blockInput, @Nullable ITag<?> tagInput, @NotNull BlockOutput blockOutput, double chance, double weight, @NotNull String beeType) {
            this.blockInput = blockInput;
            this.tagInput = tagInput;
            this.blockOutput = blockOutput;
            this.chance = chance;
            this.weight = weight;
            this.beeType = beeType;
        }

        @NotNull
        public BlockOutput getBlockOutput() {
            return this.blockOutput;
        }
    }
}

