/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BeeHiveCategory
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/beehive.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "hive");

    public BeeHiveCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.hive", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 26).addPadding(0, 0, 0, 0).build(), guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.T1_BEEHIVE_ITEM.get())), Recipe.class);
    }

    public static List<Recipe> getHoneycombRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        BeeRegistry.getRegistry().getBees().forEach((s, customBeeData) -> {
            if (customBeeData.hasHoneycomb()) {
                ItemStack honeyCombItemStack = new ItemStack((IItemProvider)customBeeData.getCombRegistryObject().get());
                recipes.add(new Recipe(honeyCombItemStack, customBeeData.getName()));
            }
        });
        return recipes;
    }

    @Override
    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>(Collections.singletonList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.T1_BEEHIVE_ITEM.get(), (IItemProvider)ModItems.T2_BEEHIVE_ITEM.get(), (IItemProvider)ModItems.T3_BEEHIVE_ITEM.get(), (IItemProvider)ModItems.T4_BEEHIVE_ITEM.get()})));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getComb());
        ingredients.setInputIngredients(list);
        ingredients.setInput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.beeType, -45.0f));
    }

    @Override
    public void setRecipe(IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, false, 138, 4);
        itemStacks.init(1, true, 62, 4);
        itemStacks.set(ingredients);
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 10, 2);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
    }

    public static class Recipe {
        private final ItemStack comb;
        private final String beeType;

        public Recipe(ItemStack comb, String beeType) {
            this.comb = comb;
            this.beeType = beeType;
        }

        public ItemStack getComb() {
            return this.comb;
        }

        public String getBeeType() {
            return this.beeType;
        }
    }
}

