/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.compat.jei;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.compat.jei.BaseCategory;
import com.resourcefulbees.resourcefulbees.compat.jei.JEICompat;
import com.resourcefulbees.resourcefulbees.compat.jei.ingredients.EntityIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class BeeBreedingCategory
extends BaseCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("resourcefulbees", "textures/gui/jei/breeding.png");
    public static final ResourceLocation ID = new ResourceLocation("resourcefulbees", "breeding");
    private static final IBeeRegistry beeRegistry = BeeRegistry.getRegistry();

    public BeeBreedingCategory(IGuiHelper guiHelper) {
        super(guiHelper, ID, I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.breeding", (Object[])new Object[0]), (IDrawable)guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 60).addPadding(0, 0, 0, 0).build(), guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.GOLD_FLOWER.get())), Recipe.class);
    }

    public static List<Recipe> getBreedingRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        beeRegistry.getSetOfBees().stream().filter(BeeBreedingCategory::isBreedable).forEach(beeData -> {
            if (BeeBreedingCategory.beeHasParents(beeData)) {
                Iterator<String> parent1 = Splitter.on((String)",").trimResults().split((CharSequence)beeData.getBreedData().getParent1()).iterator();
                Iterator<String> parent2 = Splitter.on((String)",").trimResults().split((CharSequence)beeData.getBreedData().getParent2()).iterator();
                while (parent1.hasNext() && parent2.hasNext()) {
                    Recipe parentsRecipe = BeeBreedingCategory.getParentsRecipe(beeData, parent1, parent2);
                    if (parentsRecipe == null) continue;
                    recipes.add(parentsRecipe);
                }
            }
            recipes.add(BeeBreedingCategory.getSelfRecipe(beeData));
        });
        return recipes;
    }

    private static boolean beeHasParents(CustomBeeData beeData) {
        return beeData.getBreedData().hasParents();
    }

    private static boolean isBreedable(CustomBeeData beeData) {
        return beeData.getBreedData().isBreedable();
    }

    private static Recipe getSelfRecipe(CustomBeeData beeData) {
        return new Recipe(beeData);
    }

    private static Recipe getParentsRecipe(CustomBeeData beeData, Iterator<String> parent1, Iterator<String> parent2) {
        String p1 = parent1.next();
        String p2 = parent2.next();
        if (beeRegistry.getBees().containsKey(p1) && beeRegistry.getBees().containsKey(p2)) {
            CustomBeeData p1Data = beeRegistry.getBeeData(p1);
            CustomBeeData p2Data = beeRegistry.getBeeData(p2);
            return new Recipe(p1Data, p2Data, beeData);
        }
        return null;
    }

    @Override
    public void setIngredients(@NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        ArrayList stackList;
        ArrayList list = new ArrayList();
        if (recipe.p1FeedItems != null) {
            stackList = new ArrayList();
            recipe.p1FeedItems.forEach(item -> stackList.add(new ItemStack((IItemProvider)item, recipe.p1FeedAmount)));
            list.add(stackList);
        }
        if (recipe.p2FeedItems != null) {
            stackList = new ArrayList();
            recipe.p2FeedItems.forEach(item -> stackList.add(new ItemStack((IItemProvider)item, recipe.p2FeedAmount)));
            list.add(stackList);
        }
        ingredients.setInputLists(VanillaTypes.ITEM, list);
        ArrayList<EntityIngredient> entities = new ArrayList<EntityIngredient>();
        entities.add(new EntityIngredient(recipe.parent1, -45.0f));
        entities.add(new EntityIngredient(recipe.parent2, 45.0f));
        ingredients.setInputs(JEICompat.ENTITY_INGREDIENT, entities);
        ingredients.setOutput(JEICompat.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.child, -45.0f));
    }

    @Override
    public void setRecipe(@NotNull IRecipeLayout iRecipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(JEICompat.ENTITY_INGREDIENT);
        ingredientStacks.init(0, true, 6, 6);
        ingredientStacks.init(1, true, 60, 6);
        ingredientStacks.init(2, false, 130, 18);
        ingredientStacks.set(0, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(0));
        ingredientStacks.set(1, (List)ingredients.getInputs(JEICompat.ENTITY_INGREDIENT).get(1));
        ingredientStacks.set(2, (List)ingredients.getOutputs(JEICompat.ENTITY_INGREDIENT).get(0));
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 6, 32);
        itemStacks.init(1, true, 60, 32);
        if (!ingredients.getInputs(VanillaTypes.ITEM).isEmpty()) {
            itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        if (ingredients.getInputs(VanillaTypes.ITEM).size() > 1) {
            itemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        }
    }

    public void draw(Recipe recipe, @NotNull MatrixStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        DecimalFormat decimalFormat = new DecimalFormat("##%");
        fontRenderer.func_238421_b_(matrix, decimalFormat.format(beeRegistry.getAdjustedWeightForChild(beeRegistry.getBeeData(recipe.child), recipe.parent1, recipe.parent2)), 90.0f, 35.0f, -8355712);
        if (recipe.chance < 1.0f) {
            fontRenderer.func_238421_b_(matrix, decimalFormat.format(recipe.chance), 130.0f, 40.0f, -8355712);
            this.info.draw(matrix, 115, 40);
        }
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(@NotNull Recipe recipe, double mouseX, double mouseY) {
        double infoX = 115.0;
        double infoY = 40.0;
        if (mouseX >= infoX && mouseX <= infoX + 9.0 && mouseY >= infoY && mouseY <= infoY + 9.0 && recipe.chance < 1.0f) {
            return Collections.singletonList(new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.jei.category.breed_chance.info", (Object[])new Object[0])));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }

    public static class Recipe {
        private final String parent1;
        private final String parent2;
        private final String child;
        private final float chance;
        private final Set<Item> p1FeedItems;
        private final Set<Item> p2FeedItems;
        private final int p1FeedAmount;
        private final int p2FeedAmount;

        public Recipe(CustomBeeData data) {
            this(data, data, data);
        }

        public Recipe(CustomBeeData parent1, CustomBeeData parent2, CustomBeeData child) {
            this.parent1 = parent1.getName();
            this.parent2 = parent2.getName();
            this.child = child.getName();
            this.chance = child.getBreedData().getBreedChance();
            this.p1FeedItems = parent1.getBreedData().hasFeedItems() ? parent1.getBreedData().getFeedItems() : null;
            this.p2FeedItems = parent2.getBreedData().hasFeedItems() ? parent2.getBreedData().getFeedItems() : null;
            this.p1FeedAmount = parent1.getBreedData().getFeedAmount();
            this.p2FeedAmount = parent2.getBreedData().getFeedAmount();
        }
    }
}

