/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.tileentity.EnderBeeconTileEntity;
import com.resourcefulbees.resourcefulbees.utils.CubeModel;
import com.resourcefulbees.resourcefulbees.utils.RenderCuboid;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RenderEnderBeecon
extends TileEntityRenderer<EnderBeeconTileEntity> {
    public static final ResourceLocation TEXTURE_BEACON_BEAM = new ResourceLocation("textures/entity/beacon_beam.png");

    public RenderEnderBeecon(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    public void render(EnderBeeconTileEntity tile, float partialTick, @NotNull MatrixStack matrix, @NotNull IRenderTypeBuffer renderer, int light, int overlayLight) {
        if (tile.func_145831_w() == null) {
            return;
        }
        FluidStack stack = tile.getFluidTank().getFluid();
        long gameTime = tile.func_145831_w().func_82737_E();
        if (!stack.isEmpty()) {
            int level = tile.getFluidLevel();
            int color = stack.getFluid().getAttributes().getColor();
            ResourceLocation stillTexture = stack.getFluid().getAttributes().getStillTexture();
            IVertexBuilder builder = renderer.getBuffer(Atlases.func_228785_j_());
            Vector3f start = new Vector3f(0.26f, 0.25f, 0.26f);
            Vector3f end = new Vector3f(0.74f, 0.25f + (float)level / 100.0f * 0.375f, 0.74f);
            CubeModel model = new CubeModel(start, end);
            model.setTextures(stillTexture);
            RenderCuboid.INSTANCE.renderCube(model, matrix, builder, color, light, overlayLight);
            if (!tile.isShowBeam()) {
                return;
            }
            float red = RenderCuboid.getRed(color);
            float green = RenderCuboid.getGreen(color);
            float blue = RenderCuboid.getBlue(color);
            float alpha = RenderCuboid.getAlpha(color);
            float[] afloats = new float[]{red, green, blue, alpha};
            BeaconTileEntityRenderer.func_228842_a_((MatrixStack)matrix, (IRenderTypeBuffer)renderer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTick, (float)1.0f, (long)gameTime, (int)0, (int)1024, (float[])afloats, (float)0.2f, (float)0.25f);
        }
    }

    public boolean shouldRenderOffScreen(@NotNull EnderBeeconTileEntity tile) {
        return true;
    }
}

