/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.patreon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.patreon.BeeRewardData;
import com.resourcefulbees.resourcefulbees.patreon.PatreonInfo;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;

public class BeeRewardRender
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final ModelRenderer body = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer leftAntenna;
    private final ModelRenderer rightAntenna;
    private final ModelRenderer rightWing;
    private final ModelRenderer leftWing;
    private final ModelRenderer frontLegs;
    private final ModelRenderer middleLegs;
    private final ModelRenderer backLegs;

    public BeeRewardRender(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRenderer) {
        super(entityRenderer);
        ModelRenderer torso = new ModelRenderer(64, 64, 0, 0);
        ModelRenderer stinger = new ModelRenderer(64, 64, 26, 7);
        this.leftAntenna = new ModelRenderer(64, 64, 2, 0);
        this.rightAntenna = new ModelRenderer(64, 64, 2, 3);
        this.rightWing = new ModelRenderer(64, 64, 0, 18);
        this.leftWing = new ModelRenderer(64, 64, 0, 18);
        this.frontLegs = new ModelRenderer(64, 64, 0, 0);
        this.middleLegs = new ModelRenderer(64, 64, 0, 0);
        this.backLegs = new ModelRenderer(64, 64, 0, 0);
        this.body.func_78793_a(0.0f, 19.0f, 0.0f);
        torso.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(torso);
        torso.func_78784_a(0, 0).func_228301_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.0f);
        stinger.func_228301_a_(0.0f, -1.0f, 5.0f, 0.0f, 1.0f, 2.0f, 0.0f);
        torso.func_78792_a(stinger);
        this.leftAntenna.func_78793_a(0.0f, -2.0f, -5.0f);
        this.leftAntenna.func_228301_a_(1.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f, 0.0f);
        this.rightAntenna.func_78793_a(0.0f, -2.0f, -5.0f);
        this.rightAntenna.func_228301_a_(-2.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f, 0.0f);
        torso.func_78792_a(this.leftAntenna);
        torso.func_78792_a(this.rightAntenna);
        this.rightWing.func_78793_a(-1.5f, -4.0f, -3.0f);
        this.setRotationAngle(this.rightWing, -0.2618f);
        this.body.func_78792_a(this.rightWing);
        this.rightWing.func_228301_a_(-9.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, 0.001f);
        this.leftWing.func_78793_a(1.5f, -4.0f, -3.0f);
        this.setRotationAngle(this.leftWing, 0.2618f);
        this.leftWing.field_78809_i = true;
        this.body.func_78792_a(this.leftWing);
        this.leftWing.func_228301_a_(0.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, 0.001f);
        this.frontLegs.func_78793_a(1.5f, 3.0f, -2.0f);
        this.body.func_78792_a(this.frontLegs);
        this.frontLegs.func_217178_a("frontLegBox", -5.0f, 0.0f, 0.0f, 7, 2, 0, 0.0f, 26, 1);
        this.middleLegs.func_78793_a(1.5f, 3.0f, 0.0f);
        this.body.func_78792_a(this.middleLegs);
        this.middleLegs.func_217178_a("midLegBox", -5.0f, 0.0f, 0.0f, 7, 2, 0, 0.0f, 26, 3);
        this.backLegs.func_78793_a(1.5f, 3.0f, 2.0f);
        this.body.func_78792_a(this.backLegs);
        this.backLegs.func_217178_a("backLegBox", -5.0f, 0.0f, 0.0f, 7, 2, 0, 0.0f, 26, 5);
    }

    private void setRotationAngle(ModelRenderer modelRenderer, float y) {
        modelRenderer.field_78795_f = 0.0f;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = 0.0f;
    }

    private void updateAngles(float ticks) {
        this.leftAntenna.field_78795_f = 0.0f;
        this.rightAntenna.field_78795_f = 0.0f;
        this.body.field_78795_f = 0.0f;
        this.body.field_78797_d = 19.0f;
        this.rightWing.field_78796_g = 0.0f;
        this.rightWing.field_78808_h = MathHelper.func_76134_b((float)(ticks % 98000.0f * 2.1f)) * (float)Math.PI * 0.15f;
        this.leftWing.field_78795_f = this.rightWing.field_78795_f;
        this.leftWing.field_78796_g = this.rightWing.field_78796_g;
        this.leftWing.field_78808_h = -this.rightWing.field_78808_h;
        this.frontLegs.field_78795_f = 0.7853982f;
        this.middleLegs.field_78795_f = 0.7853982f;
        this.backLegs.field_78795_f = 0.7853982f;
        this.setRotationAngle(this.body, 0.0f);
        float f1 = MathHelper.func_76134_b((float)(ticks % 1143333.0f * 0.18f));
        this.body.field_78795_f = 0.1f + f1 * (float)Math.PI * 0.025f;
        this.leftAntenna.field_78795_f = f1 * (float)Math.PI * 0.03f;
        this.rightAntenna.field_78795_f = f1 * (float)Math.PI * 0.03f;
        this.frontLegs.field_78795_f = -f1 * (float)Math.PI * 0.1f + 0.3926991f;
        this.backLegs.field_78795_f = -f1 * (float)Math.PI * 0.05f + 0.7853982f;
        this.body.field_78797_d = 19.0f - MathHelper.func_76134_b((float)(ticks % 1143333.0f * 0.18f)) * 0.9f;
    }

    public void render(@NotNull MatrixStack stack, @NotNull IRenderTypeBuffer buffer, int packedLightIn, @NotNull AbstractClientPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!PatreonInfo.isPatreon(playerEntity.func_110124_au())) {
            return;
        }
        BeeRewardData data = PatreonInfo.getPatreon(playerEntity.func_110124_au());
        this.updateAngles(ageInTicks);
        stack.func_227860_a_();
        stack.func_227862_a_(0.25f, 0.25f, 0.25f);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ageInTicks * 0.01f / 2.0f * 360.0f));
        stack.func_227861_a_(0.0, 1.5 * (double)MathHelper.func_76126_a((float)(ageInTicks / 10.0f - 30.0f)), 3.0);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        stack.func_227860_a_();
        IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)data.getTextures().getResourceLocation()));
        this.body.func_228308_a_(stack, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_);
        stack.func_227865_b_();
        if (data.getTextures().hasSecondaryLayer()) {
            stack.func_227860_a_();
            IVertexBuilder ivertexbuilder2 = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)data.getTextures().getSecondaryResourceLocation()));
            float r = data.isRainbow() ? RainbowColor.getColorFloats()[0] : data.getColor().getR();
            float g = data.isRainbow() ? RainbowColor.getColorFloats()[1] : data.getColor().getG();
            float b = data.isRainbow() ? RainbowColor.getColorFloats()[2] : data.getColor().getB();
            this.body.func_228309_a_(stack, ivertexbuilder2, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)playerEntity, (float)0.0f), r, g, b, 1.0f);
            stack.func_227865_b_();
        }
        stack.func_227865_b_();
    }
}

