/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.entity.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.BaseModelTypes;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.ModelUtils;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CustomBeeModel<T extends CustomBeeEntity>
extends AgeableModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer torso;
    private final ModelRenderer rightWing;
    private final ModelRenderer leftWing;
    private final ModelRenderer frontLegs;
    private final ModelRenderer middleLegs;
    private final ModelRenderer backLegs;
    private final ModelRenderer stinger;
    private final ModelRenderer leftAntenna;
    private final ModelRenderer rightAntenna;
    private float bodyPitch;
    private float sizeModifier = 0.0f;

    public CustomBeeModel(ModelTypes modelType) {
        this();
        switch (modelType) {
            case GELATINOUS: {
                break;
            }
            case ORE: {
                break;
            }
            case DRAGON: {
                super.addDragonParts();
                break;
            }
            case QUEEN: {
                super.addQueenParts();
                break;
            }
            case VILLAGER: {
                super.addVillagerNose();
                break;
            }
            case MUSHROOM: {
                super.addMushrooms();
                break;
            }
            case ARMORED: {
                super.addArmor();
                break;
            }
            case CROP: {
                super.addCrops();
                break;
            }
            case GUARDIAN: {
                super.addSpikes();
                break;
            }
            case YETI: {
                super.addYetiHorns();
                break;
            }
            case DEFAULT: {
                super.addDefaultParts();
            }
        }
    }

    public CustomBeeModel(BaseModelTypes modelType) {
        this();
        if (modelType.equals((Object)BaseModelTypes.KITTEN)) {
        } else if (modelType.equals((Object)BaseModelTypes.DEFAULT)) {
        }
    }

    public CustomBeeModel() {
        super(false, 24.0f, 0.0f);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this);
        this.torso = new ModelRenderer((Model)this);
        this.stinger = new ModelRenderer((Model)this, 26, 7);
        this.leftAntenna = new ModelRenderer((Model)this, 2, 0);
        this.rightAntenna = new ModelRenderer((Model)this, 2, 3);
        this.rightWing = new ModelRenderer((Model)this, 0, 18);
        this.leftWing = new ModelRenderer((Model)this, 0, 18);
        this.frontLegs = new ModelRenderer((Model)this);
        this.middleLegs = new ModelRenderer((Model)this);
        this.backLegs = new ModelRenderer((Model)this);
    }

    public void prepareMobModel(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.bodyPitch = entityIn.func_226455_v_(partialTick);
        this.stinger.field_78806_j = !entityIn.func_226412_eE_();
    }

    public void setupAnim(CustomBeeEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftAntenna.field_78795_f = 0.0f;
        this.rightAntenna.field_78795_f = 0.0f;
        this.body.field_78795_f = 0.0f;
        this.body.field_78797_d = 19.0f;
        this.rightWing.field_78796_g = 0.0f;
        this.rightWing.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks % 98000.0f * 2.1f)) * (float)Math.PI * 0.15f;
        this.leftWing.field_78795_f = this.rightWing.field_78795_f;
        this.leftWing.field_78796_g = this.rightWing.field_78796_g;
        this.leftWing.field_78808_h = -this.rightWing.field_78808_h;
        this.frontLegs.field_78795_f = 0.7853982f;
        this.middleLegs.field_78795_f = 0.7853982f;
        this.backLegs.field_78795_f = 0.7853982f;
        this.setRotationAngle(this.body, 0.0f, 0.0f, 0.0f);
        if (!entityIn.func_233678_J__()) {
            float f1 = MathHelper.func_76134_b((float)(ageInTicks * 0.18f));
            this.body.field_78795_f = 0.1f + f1 * (float)Math.PI * 0.025f;
            this.leftAntenna.field_78795_f = f1 * (float)Math.PI * 0.03f;
            this.rightAntenna.field_78795_f = f1 * (float)Math.PI * 0.03f;
            this.frontLegs.field_78795_f = -f1 * (float)Math.PI * 0.1f + 0.3926991f;
            this.backLegs.field_78795_f = -f1 * (float)Math.PI * 0.05f + 0.7853982f;
            this.body.field_78797_d = 19.0f - MathHelper.func_76134_b((float)(ageInTicks * 0.18f)) * 0.9f;
        }
        if (this.bodyPitch > 0.0f) {
            this.body.field_78795_f = ModelUtils.func_228283_a_((float)this.body.field_78795_f, (float)3.0915928f, (float)this.bodyPitch);
        }
        this.sizeModifier = entityIn.getBeeData().getSizeModifier();
        if (this.field_217114_e) {
            this.sizeModifier = (float)((double)this.sizeModifier * (Double)Config.CHILD_SIZE_MODIFIER.get());
        }
    }

    @NotNull
    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    @NotNull
    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void func_225598_a_(@NotNull MatrixStack matrixStackIn, @NotNull IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 1.5 - (double)this.sizeModifier * 1.5, 0.0);
        matrixStackIn.func_227862_a_(this.sizeModifier, this.sizeModifier, this.sizeModifier);
        super.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.func_227865_b_();
    }

    private void addDefaultParts() {
        this.body.func_78793_a(0.0f, 19.0f, 0.0f);
        this.torso.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.torso);
        this.torso.func_78784_a(0, 0).func_228301_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.0f);
        this.stinger.func_228301_a_(0.0f, -1.0f, 5.0f, 0.0f, 1.0f, 2.0f, 0.0f);
        this.torso.func_78792_a(this.stinger);
        this.leftAntenna.func_78793_a(0.0f, -2.0f, -5.0f);
        this.leftAntenna.func_228301_a_(1.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f, 0.0f);
        this.rightAntenna.func_78793_a(0.0f, -2.0f, -5.0f);
        this.rightAntenna.func_228301_a_(-2.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f, 0.0f);
        this.torso.func_78792_a(this.leftAntenna);
        this.torso.func_78792_a(this.rightAntenna);
        this.rightWing.func_78793_a(-1.5f, -4.0f, -3.0f);
        this.setRotationAngle(this.rightWing, 0.0f, -0.2618f, 0.0f);
        this.body.func_78792_a(this.rightWing);
        this.rightWing.func_228301_a_(-9.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, 0.001f);
        this.leftWing.func_78793_a(1.5f, -4.0f, -3.0f);
        this.setRotationAngle(this.leftWing, 0.0f, 0.2618f, 0.0f);
        this.leftWing.field_78809_i = true;
        this.body.func_78792_a(this.leftWing);
        this.leftWing.func_228301_a_(0.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, 0.001f);
        this.frontLegs.func_78793_a(1.5f, 3.0f, -2.0f);
        this.body.func_78792_a(this.frontLegs);
        this.frontLegs.func_217178_a("frontLegBox", -5.0f, 0.0f, 0.0f, 7, 2, 0, 0.0f, 26, 1);
        this.middleLegs.func_78793_a(1.5f, 3.0f, 0.0f);
        this.body.func_78792_a(this.middleLegs);
        this.middleLegs.func_217178_a("midLegBox", -5.0f, 0.0f, 0.0f, 7, 2, 0, 0.0f, 26, 3);
        this.backLegs.func_78793_a(1.5f, 3.0f, 2.0f);
        this.body.func_78792_a(this.backLegs);
        this.backLegs.func_217178_a("backLegBox", -5.0f, 0.0f, 0.0f, 7, 2, 0, 0.0f, 26, 5);
    }

    private void addKittenParts() {
        this.body.func_78793_a(0.0f, 19.0f, 0.0f);
        this.torso.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.torso);
        this.torso.func_78784_a(24, 6).func_228303_a_(-1.5f, 1.0f, -6.0f, 3.0f, 2.0f, 1.0f, 0.0f, false);
        this.torso.func_78784_a(24, 3).func_228303_a_(-2.5f, -5.0f, -4.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
        this.torso.func_78784_a(24, 3).func_228303_a_(1.5f, -5.0f, -4.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
        this.torso.func_78784_a(0, 0).func_228303_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.0f, false);
        this.stinger.func_78793_a(0.0f, 0.0f, 0.0f);
        this.torso.func_78792_a(this.stinger);
        this.stinger.func_228301_a_(0.0f, -1.0f, 5.0f, 0.0f, 1.0f, 2.0f, 0.0f);
        this.leftAntenna.func_78793_a(0.0f, -2.0f, -5.0f);
        this.torso.func_78792_a(this.leftAntenna);
        this.leftAntenna.func_78784_a(2, 0).func_228303_a_(1.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f, 0.0f, false);
        this.rightAntenna.func_78793_a(0.0f, -2.0f, -5.0f);
        this.torso.func_78792_a(this.rightAntenna);
        this.rightAntenna.func_78784_a(2, 3).func_228303_a_(-2.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f, 0.0f, false);
        this.rightWing.func_78793_a(-1.5f, -4.0f, -3.0f);
        this.body.func_78792_a(this.rightWing);
        this.rightWing.func_78784_a(0, 18).func_228303_a_(-9.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, 0.0f, false);
        this.leftWing.func_78793_a(1.5f, -4.0f, -3.0f);
        this.body.func_78792_a(this.leftWing);
        this.leftWing.func_78784_a(0, 18).func_228303_a_(0.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, 0.0f, true);
        this.frontLegs.func_78793_a(1.5f, 3.0f, -2.0f);
        this.body.func_78792_a(this.frontLegs);
        this.frontLegs.func_78784_a(24, 0).func_228303_a_(-3.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.frontLegs.func_78784_a(24, 0).func_228303_a_(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.middleLegs.func_78793_a(1.5f, 3.0f, 0.0f);
        this.body.func_78792_a(this.middleLegs);
        this.middleLegs.func_78784_a(24, 0).func_228303_a_(-4.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.middleLegs.func_78784_a(24, 0).func_228303_a_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.backLegs.func_78793_a(1.5f, 3.0f, 2.0f);
        this.body.func_78792_a(this.backLegs);
        this.backLegs.func_78784_a(24, 0).func_228303_a_(-4.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.backLegs.func_78784_a(24, 0).func_228303_a_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
    }

    private void addGelatinousParts() {
        this.body.func_78793_a(0.0f, 19.0f, 0.0f);
        this.torso.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.torso);
        this.torso.func_78784_a(0, 25).func_228301_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.7f);
    }

    private void addOreCrystals() {
        ModelRenderer crystals = new ModelRenderer((Model)this);
        crystals.func_78793_a(-0.25f, 1.0f, -6.5f);
        this.body.func_78792_a(crystals);
        this.setRotationAngle(crystals, 0.3927f, 0.0f, 0.0f);
        crystals.func_78784_a(48, 48).func_228303_a_(1.0f, -3.8582f, 5.7674f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        crystals.func_78784_a(48, 52).func_228303_a_(-1.0f, -6.0f, 4.0f, 2.0f, 3.0f, 2.0f, 0.0f, false);
        ModelRenderer bone = new ModelRenderer((Model)this);
        bone.func_78793_a(0.0f, 0.2242f, 3.1543f);
        crystals.func_78792_a(bone);
        this.setRotationAngle(bone, -0.3927f, 0.0f, 0.0f);
        bone.func_78784_a(48, 57).func_228303_a_(-2.0f, -7.7242f, 1.8457f, 3.0f, 4.0f, 3.0f, 0.0f, true);
        ModelRenderer bone2 = new ModelRenderer((Model)this);
        bone2.func_78793_a(-1.0f, -0.5412f, 1.45f);
        crystals.func_78792_a(bone2);
        this.setRotationAngle(bone2, -0.3927f, 0.0f, 0.0f);
        bone2.func_78784_a(48, 48).func_228303_a_(-1.5f, -5.8588f, 2.6934f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        bone2.func_78784_a(48, 52).func_228303_a_(1.0f, -6.8588f, 5.6934f, 2.0f, 3.0f, 2.0f, 0.0f, true);
        ModelRenderer bone5 = new ModelRenderer((Model)this);
        bone5.func_78793_a(2.0f, 0.0f, 0.0f);
        bone2.func_78792_a(bone5);
        this.setRotationAngle(bone5, 0.0f, 0.0f, -0.3927f);
        bone5.func_78784_a(48, 52).func_228303_a_(-1.5f, -6.6588f, 5.6934f, 2.0f, 3.0f, 2.0f, 0.0f, true);
        ModelRenderer bone3 = new ModelRenderer((Model)this);
        bone3.func_78793_a(3.0f, -4.4588f, -3.3066f);
        bone2.func_78792_a(bone3);
        this.setRotationAngle(bone3, 0.0f, 0.0f, 0.5236f);
        bone3.func_78784_a(56, 51).func_228303_a_(-0.7321f, -2.0f, 10.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        ModelRenderer bone4 = new ModelRenderer((Model)this);
        bone4.func_78793_a(-5.0981f, 0.634f, 0.0f);
        bone3.func_78792_a(bone4);
        this.setRotationAngle(bone4, 0.0f, 0.0f, -1.3963f);
        bone4.func_78784_a(56, 51).func_228303_a_(-1.1252f, 1.9f, 11.0f, 2.0f, 4.0f, 2.0f, 0.0f, true);
    }

    private void addDragonParts() {
        ModelRenderer dragon = new ModelRenderer((Model)this);
        dragon.func_78793_a(0.0f, -4.0f, -4.0f);
        this.body.func_78792_a(dragon);
        dragon.func_78784_a(0, 61).func_228303_a_(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
        dragon.func_78784_a(6, 61).func_228303_a_(-0.5f, -1.0f, 3.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
        dragon.func_78784_a(12, 61).func_228303_a_(-0.5f, -1.0f, 6.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
        ModelRenderer horns = new ModelRenderer((Model)this);
        horns.func_78793_a(0.0f, 1.0f, -2.0f);
        dragon.func_78792_a(horns);
        this.setRotationAngle(horns, -0.6109f, 0.0f, 0.0f);
        horns.func_78784_a(6, 55).func_228303_a_(1.75f, -6.0f, 1.5f, 1.0f, 4.0f, 2.0f, 0.0f, false);
        horns.func_78784_a(0, 55).func_228303_a_(-2.75f, -6.0f, 1.5f, 1.0f, 4.0f, 2.0f, 0.0f, false);
    }

    private void addQueenParts() {
        ModelRenderer queen = new ModelRenderer((Model)this);
        queen.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(queen);
        queen.func_78784_a(0, 42).func_228303_a_(-2.5f, -5.0f, -4.0f, 5.0f, 1.0f, 5.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(-2.5f, -6.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(1.5f, -6.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(1.5f, -6.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(-0.5f, -6.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(-2.5f, -6.0f, -2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(1.5f, -6.0f, -2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 45).func_228303_a_(-2.5f, -6.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        queen.func_78784_a(0, 42).func_228303_a_(-0.5f, -6.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
    }

    private void addVillagerNose() {
        ModelRenderer nose = new ModelRenderer((Model)this);
        nose.func_78793_a(0.0f, -21.0f, 0.0f);
        this.body.func_78792_a(nose);
        nose.func_78784_a(26, 25).func_228303_a_(-1.0f, 21.0f, -6.5f, 2.0f, 4.0f, 2.0f, 0.0f, false);
    }

    private void addMushrooms() {
        ModelRenderer mushroom = new ModelRenderer((Model)this);
        mushroom.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(mushroom);
        mushroom.func_78784_a(0, 25).func_228303_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.4f, false);
        ModelRenderer frontMushroom1 = new ModelRenderer((Model)this);
        frontMushroom1.func_78793_a(-1.5f, -4.0f, 0.0f);
        mushroom.func_78792_a(frontMushroom1);
        frontMushroom1.func_78784_a(32, 48).func_228303_a_(-8.0f, -14.0f, -4.0f, 16.0f, 16.0f, 0.0f, -2.0f, false);
        ModelRenderer frontMushroom2 = new ModelRenderer((Model)this);
        frontMushroom2.func_78793_a(0.0f, 0.0f, -2.0f);
        frontMushroom1.func_78792_a(frontMushroom2);
        this.setRotationAngle(frontMushroom2, 0.0f, -1.5708f, 0.0f);
        frontMushroom2.func_78784_a(32, 48).func_228303_a_(-8.0f, -14.0f, -2.0f, 16.0f, 16.0f, 0.0f, -2.0f, false);
        ModelRenderer backMushroom1 = new ModelRenderer((Model)this);
        backMushroom1.func_78793_a(2.5f, -4.0f, 4.0f);
        mushroom.func_78792_a(backMushroom1);
        this.setRotationAngle(backMushroom1, 0.0f, -0.7854f, 0.0f);
        backMushroom1.func_78784_a(0, 48).func_228303_a_(-8.0f, -14.0f, -2.0f, 16.0f, 16.0f, 0.0f, -2.0f, false);
        ModelRenderer backMushroom2 = new ModelRenderer((Model)this);
        backMushroom2.func_78793_a(0.0f, 0.0f, 0.0f);
        backMushroom1.func_78792_a(backMushroom2);
        this.setRotationAngle(backMushroom2, 0.0f, -1.5708f, 0.0f);
        backMushroom2.func_78784_a(0, 48).func_228303_a_(-8.0f, -14.0f, -2.0f, 16.0f, 16.0f, 0.0f, -2.0f, false);
    }

    private void addCrops() {
        ModelRenderer crop = new ModelRenderer((Model)this);
        crop.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(crop);
        crop.func_78784_a(0, 25).func_228303_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.4f, false);
        ModelRenderer crop2 = new ModelRenderer((Model)this);
        crop2.func_78793_a(-1.6f, -4.0f, 1.5f);
        crop.func_78792_a(crop2);
        ModelRenderer crop3 = new ModelRenderer((Model)this);
        crop3.func_78793_a(0.0f, -9.0f, -2.0f);
        crop2.func_78792_a(crop3);
        this.setRotationAngle(crop3, 0.0f, -1.5708f, 0.0f);
        crop3.func_78784_a(0, 46).func_228303_a_(-8.3f, -3.9f, -7.9f, 18.0f, 18.0f, 0.0f, -4.0f, true);
        crop3.func_78784_a(0, 46).func_228303_a_(-8.3f, -3.9f, -3.4f, 18.0f, 18.0f, 0.0f, -4.0f, true);
        ModelRenderer crop4 = new ModelRenderer((Model)this);
        crop4.func_78793_a(2.5f, 5.1f, -1.625f);
        crop3.func_78792_a(crop4);
        this.setRotationAngle(crop4, 0.0f, -1.5708f, 0.0f);
        crop4.func_78784_a(0, 46).func_228303_a_(-9.0f, -9.0f, 0.0f, 18.0f, 18.0f, 0.0f, -4.0f, true);
        ModelRenderer crop5 = new ModelRenderer((Model)this);
        crop5.func_78793_a(6.85f, 5.1f, -1.625f);
        crop3.func_78792_a(crop5);
        this.setRotationAngle(crop5, 0.0f, -1.5708f, 0.0f);
        crop5.func_78784_a(0, 46).func_228303_a_(-9.0f, -9.0f, 0.0f, 18.0f, 18.0f, 0.0f, -4.0f, true);
    }

    private void addArmor() {
        ModelRenderer armored = new ModelRenderer((Model)this);
        armored.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(armored);
        armored.func_78784_a(34, 3).func_228303_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 7.0f, 0.6f, false);
        armored.func_78784_a(0, 25).func_228303_a_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.25f, false);
    }

    private void addSpikes() {
        ModelRenderer guardian = new ModelRenderer((Model)this);
        guardian.func_78793_a(0.0f, 5.0f, 0.0f);
        this.body.func_78792_a(guardian);
        guardian.func_78784_a(0, 25).func_228303_a_(-3.5f, -9.0f, -5.0f, 7.0f, 7.0f, 10.0f, 0.4f, false);
        ModelRenderer spike1 = new ModelRenderer((Model)this);
        spike1.func_78793_a(3.5f, -5.5f, 5.0f);
        guardian.func_78792_a(spike1);
        this.setRotationAngle(spike1, 0.0f, 2.3562f, 0.0f);
        spike1.func_78784_a(40, 24).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike2 = new ModelRenderer((Model)this);
        spike2.func_78793_a(-3.5f, -5.5f, -5.0f);
        guardian.func_78792_a(spike2);
        this.setRotationAngle(spike2, 0.0f, -0.7854f, 0.0f);
        spike2.func_78784_a(40, 22).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike3 = new ModelRenderer((Model)this);
        spike3.func_78793_a(3.5f, -5.5f, -4.75f);
        guardian.func_78792_a(spike3);
        this.setRotationAngle(spike3, 0.0f, -2.3562f, 0.0f);
        spike3.func_78784_a(40, 20).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike4 = new ModelRenderer((Model)this);
        spike4.func_78793_a(-3.5f, -5.5f, 5.0f);
        guardian.func_78792_a(spike4);
        this.setRotationAngle(spike4, 0.0f, 0.7854f, 0.0f);
        spike4.func_78784_a(40, 18).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike5 = new ModelRenderer((Model)this);
        spike5.func_78793_a(-3.5f, -2.0f, 0.0f);
        guardian.func_78792_a(spike5);
        this.setRotationAngle(spike5, 0.0f, 0.0f, -0.7854f);
        spike5.func_78784_a(32, 24).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike6 = new ModelRenderer((Model)this);
        spike6.func_78793_a(0.0f, -2.0f, 5.0f);
        guardian.func_78792_a(spike6);
        this.setRotationAngle(spike6, 1.5708f, 2.3562f, 1.5708f);
        spike6.func_78784_a(32, 22).func_228303_a_(-2.5f, -0.75f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike7 = new ModelRenderer((Model)this);
        spike7.func_78793_a(0.0f, -2.0f, -5.0f);
        guardian.func_78792_a(spike7);
        this.setRotationAngle(spike7, -1.5708f, -2.3562f, 1.5708f);
        spike7.func_78784_a(32, 20).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike8 = new ModelRenderer((Model)this);
        spike8.func_78793_a(3.5f, -2.0f, 0.0f);
        guardian.func_78792_a(spike8);
        this.setRotationAngle(spike8, 0.0f, 3.1416f, 0.7854f);
        spike8.func_78784_a(32, 18).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike9 = new ModelRenderer((Model)this);
        spike9.func_78793_a(0.0f, -9.0f, 5.0f);
        guardian.func_78792_a(spike9);
        this.setRotationAngle(spike9, 1.5708f, 0.7854f, 1.5708f);
        spike9.func_78784_a(24, 24).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike10 = new ModelRenderer((Model)this);
        spike10.func_78793_a(0.0f, -9.0f, -5.0f);
        guardian.func_78792_a(spike10);
        this.setRotationAngle(spike10, -1.5708f, -0.7854f, 1.5708f);
        spike10.func_78784_a(24, 22).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike11 = new ModelRenderer((Model)this);
        spike11.func_78793_a(3.5f, -9.0f, 0.0f);
        guardian.func_78792_a(spike11);
        this.setRotationAngle(spike11, 3.1416f, 0.0f, 2.3562f);
        spike11.func_78784_a(24, 20).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
        ModelRenderer spike12 = new ModelRenderer((Model)this);
        spike12.func_78793_a(-3.5f, -9.0f, 0.0f);
        guardian.func_78792_a(spike12);
        this.setRotationAngle(spike12, 0.0f, 0.0f, 0.7854f);
        spike12.func_78784_a(24, 18).func_228303_a_(-2.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, 0.25f, false);
    }

    private void addYetiHorns() {
        ModelRenderer yetiHorns = new ModelRenderer((Model)this);
        yetiHorns.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(yetiHorns);
        ModelRenderer rightHorn = new ModelRenderer((Model)this);
        rightHorn.func_78793_a(-2.0f, -4.0f, -4.0f);
        yetiHorns.func_78792_a(rightHorn);
        this.setRotationAngle(rightHorn, 0.0f, 0.0f, -0.9599f);
        rightHorn.func_78784_a(34, 12).func_228303_a_(-2.0f, -3.0f, -0.5f, 2.0f, 3.0f, 2.0f, 0.0f, true);
        ModelRenderer leftHorn = new ModelRenderer((Model)this);
        leftHorn.func_78793_a(2.0f, -4.0f, -4.0f);
        yetiHorns.func_78792_a(leftHorn);
        this.setRotationAngle(leftHorn, 0.0f, 0.0f, 0.9599f);
        leftHorn.func_78784_a(34, 12).func_228303_a_(0.0f, -3.0f, -0.5f, 2.0f, 3.0f, 2.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

