/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.client.render.entity.CustomBeeRenderer;
import com.resourcefulbees.resourcefulbees.client.render.entity.models.CustomBeeModel;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.BeeConstants;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BeeLayer
extends LayerRenderer<CustomBeeEntity, CustomBeeModel<CustomBeeEntity>> {
    private static final String PNG_SUFFIX = ".png";
    private static final String ANGRY_PNG_SUFFIX = "_angry.png";
    private final boolean isEmissive;
    private final int glowingPulse;
    private final boolean isEnchanted;
    private final CustomBeeModel<CustomBeeEntity> additionModel;
    private ResourceLocation layerTexture;
    private ResourceLocation angerLayerTexture;
    private float[] color;
    private final boolean isRainbowBee;

    public BeeLayer(IEntityRenderer<CustomBeeEntity, CustomBeeModel<CustomBeeEntity>> renderer, CustomBeeRenderer.LayerType layerType, ModelTypes addition, ColorData colorData) {
        super(renderer);
        this.additionModel = addition == ModelTypes.DEFAULT ? null : new CustomBeeModel(addition);
        this.isRainbowBee = colorData.isRainbowBee();
        this.isEnchanted = colorData.isEnchanted();
        this.glowingPulse = colorData.getGlowingPulse();
        switch (layerType) {
            case PRIMARY: {
                this.isEmissive = false;
                this.layerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getPrimaryLayerTexture() + PNG_SUFFIX));
                this.angerLayerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getPrimaryLayerTexture() + ANGRY_PNG_SUFFIX));
                this.color = this.isRainbowBee ? RainbowColor.getColorFloats() : colorData.getPrimaryColorFloats();
                break;
            }
            case SECONDARY: {
                this.isEmissive = false;
                this.layerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getSecondaryLayerTexture() + PNG_SUFFIX));
                this.angerLayerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getSecondaryLayerTexture() + ANGRY_PNG_SUFFIX));
                this.color = this.isRainbowBee ? RainbowColor.getColorFloats() : colorData.getSecondaryColorFloats();
                break;
            }
            case EMISSIVE: {
                this.isEmissive = true;
                this.layerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getEmissiveLayerTexture() + PNG_SUFFIX));
                this.angerLayerTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + colorData.getEmissiveLayerTexture() + ANGRY_PNG_SUFFIX));
                this.color = this.isRainbowBee ? RainbowColor.getColorFloats() : colorData.getGlowColorFloats();
                break;
            }
            default: {
                throw new IllegalStateException("You dun screwed up, did you add a new layer?");
            }
        }
        if (!BeeLayer.textureExists(this.layerTexture)) {
            this.layerTexture = BeeConstants.MISSING_TEXTURE;
        }
        if (!BeeLayer.textureExists(this.angerLayerTexture)) {
            this.angerLayerTexture = this.layerTexture;
        }
    }

    public static boolean textureExists(ResourceLocation texture) {
        try {
            Minecraft.func_71410_x().func_195551_G().func_199002_a(texture);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void render(@NotNull MatrixStack matrixStackIn, @NotNull IRenderTypeBuffer bufferIn, int packedLightIn, @NotNull CustomBeeEntity customBeeEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture;
        if (this.isRainbowBee) {
            this.color = RainbowColor.getColorFloats();
        }
        ResourceLocation resourceLocation = texture = customBeeEntity.func_233678_J__() ? this.angerLayerTexture : this.layerTexture;
        if (this.additionModel != null) {
            ((CustomBeeModel)this.func_215332_c()).func_217111_a((EntityModel)this.additionModel);
            this.additionModel.prepareMobModel(customBeeEntity, limbSwing, limbSwingAmount, partialTicks);
            this.additionModel.setupAnim(customBeeEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        if (this.isEmissive) {
            this.renderGlowingLayer(matrixStackIn, bufferIn, packedLightIn, customBeeEntity, texture);
        } else {
            BeeLayer.func_229141_a_((EntityModel)this.func_215332_c(), (ResourceLocation)texture, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)customBeeEntity, (float)this.color[0], (float)this.color[1], (float)this.color[2]);
            if (this.additionModel != null) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
                this.additionModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)customBeeEntity, (float)0.0f), this.color[0], this.color[1], this.color[2], 1.0f);
            }
        }
    }

    private void renderGlowingLayer(@NotNull MatrixStack matrixStackIn, @NotNull IRenderTypeBuffer bufferIn, int packedLightIn, @NotNull CustomBeeEntity customBeeEntity, ResourceLocation texture) {
        if (this.isEnchanted) {
            ((CustomBeeModel)this.func_215332_c()).func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228655_k_()), packedLightIn, OverlayTexture.field_229196_a_, 0.0f, 0.0f, 0.0f, 0.0f);
            if (this.additionModel != null) {
                this.additionModel.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228655_k_()), packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)customBeeEntity, (float)0.0f), 0.0f, 0.0f, 0.0f, 0.0f);
            }
        } else {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)texture));
            if (this.glowingPulse == 0 || customBeeEntity.field_70173_aa / 5 % this.glowingPulse == 0) {
                ((CustomBeeModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, this.color[0], this.color[1], this.color[2], 1.0f);
                if (this.additionModel != null) {
                    this.additionModel.func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, LivingRenderer.func_229117_c_((LivingEntity)customBeeEntity, (float)0.0f), this.color[0], this.color[1], this.color[2], 1.0f);
                }
            }
        }
    }
}

