/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.client.render.entity.layers.BeeLayer;
import com.resourcefulbees.resourcefulbees.client.render.entity.models.CustomBeeModel;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.BeeConstants;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AdditionLayer<T extends CustomBeeEntity>
extends LayerRenderer<T, CustomBeeModel<T>> {
    private final CustomBeeModel<T> additionModel;
    private ResourceLocation baseTexture;
    private ResourceLocation angryTexture;

    public AdditionLayer(IEntityRenderer<T, CustomBeeModel<T>> rendererIn, ModelTypes type, ResourceLocation angryTexture, ResourceLocation baseTexture) {
        super(rendererIn);
        this.additionModel = new CustomBeeModel(type);
        this.baseTexture = baseTexture;
        this.angryTexture = angryTexture;
        if (!BeeLayer.textureExists(baseTexture) || baseTexture == null) {
            this.baseTexture = BeeConstants.MISSING_TEXTURE;
        }
        if (!BeeLayer.textureExists(angryTexture) || angryTexture == null) {
            this.angryTexture = this.baseTexture;
        }
    }

    public void render(@NotNull MatrixStack matrixStackIn, @NotNull IRenderTypeBuffer bufferIn, int packedLightIn, @NotNull T customBeeEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture = customBeeEntity.func_233678_J__() ? this.angryTexture : this.baseTexture;
        ((CustomBeeModel)this.func_215332_c()).func_217111_a((EntityModel)this.additionModel);
        this.additionModel.prepareMobModel(customBeeEntity, limbSwing, limbSwingAmount, partialTicks);
        this.additionModel.setupAnim((CustomBeeEntity)customBeeEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture));
        this.additionModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_(customBeeEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

