/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.render.entity;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.render.entity.layers.AdditionLayer;
import com.resourcefulbees.resourcefulbees.client.render.entity.layers.BeeLayer;
import com.resourcefulbees.resourcefulbees.client.render.entity.models.CustomBeeModel;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.BaseModelTypes;
import com.resourcefulbees.resourcefulbees.lib.BeeConstants;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CustomBeeRenderer
extends MobRenderer<CustomBeeEntity, CustomBeeModel<CustomBeeEntity>> {
    private ResourceLocation angryTexture;
    private ResourceLocation baseTexture;

    public CustomBeeRenderer(BaseModelTypes modelType, EntityRendererManager manager, CustomBeeData beeData) {
        super(manager, new CustomBeeModel(modelType), 0.4f * beeData.getSizeModifier());
        this.angryTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + beeData.getBaseLayerTexture() + "_angry.png"));
        this.baseTexture = ResourceLocation.func_208304_a((String)("resourcefulbees:textures/entity/" + beeData.getBaseLayerTexture() + ".png"));
        if (beeData.getColorData().getModelType() != ModelTypes.DEFAULT) {
            this.func_177094_a(new AdditionLayer(this, beeData.getColorData().getModelType(), this.angryTexture, this.baseTexture));
        }
        if (beeData.getColorData().isBeeColored()) {
            this.func_177094_a(new BeeLayer((IEntityRenderer<CustomBeeEntity, CustomBeeModel<CustomBeeEntity>>)this, LayerType.PRIMARY, beeData.getColorData().getModelType(), beeData.getColorData()));
            this.func_177094_a(new BeeLayer((IEntityRenderer<CustomBeeEntity, CustomBeeModel<CustomBeeEntity>>)this, LayerType.SECONDARY, beeData.getColorData().getModelType(), beeData.getColorData()));
        }
        if (beeData.getColorData().isGlowing() || beeData.getColorData().isEnchanted()) {
            this.func_177094_a(new BeeLayer((IEntityRenderer<CustomBeeEntity, CustomBeeModel<CustomBeeEntity>>)this, LayerType.EMISSIVE, beeData.getColorData().getModelType(), beeData.getColorData()));
        }
        if (!BeeLayer.textureExists(this.baseTexture)) {
            this.baseTexture = BeeConstants.MISSING_TEXTURE;
        }
        if (!BeeLayer.textureExists(this.angryTexture)) {
            this.angryTexture = this.baseTexture;
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(CustomBeeEntity entity) {
        return entity.func_233678_J__() ? this.angryTexture : this.baseTexture;
    }

    public static enum LayerType {
        PRIMARY,
        SECONDARY,
        EMISSIVE;

    }
}

