/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.models;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import org.jetbrains.annotations.NotNull;

public class ModelHandler {
    private static final Multimap<ResourceLocation, ResourceLocation> MODEL_MAP = LinkedHashMultimap.create();
    private static final String MODEL_INVENTORY_TAG = "inventory";
    private static final String ITEM_MODEL_PATH = "item/models/";
    private static final String JSON_FILE_EXTENSION = ".json";

    private ModelHandler() {
        throw new IllegalStateException("Utility Class");
    }

    private static void registerHoneycombBlockstate(@NotNull CustomBeeData customBeeData, IResourceManager resourceManager) {
        Block honeycombBlock;
        Block block = honeycombBlock = customBeeData.getCombBlockRegistryObject() != null ? (Block)customBeeData.getCombBlockRegistryObject().get() : null;
        if (honeycombBlock != null && honeycombBlock.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", "blockstates/" + honeycombBlock.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            honeycombBlock.func_176194_O().func_177619_a().forEach(state -> {
                String propertyMapString = BlockModelShapes.func_209552_a((Map)state.func_206871_b());
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:honeycomb_block", propertyMapString);
                ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
                MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeycombBlock.getRegistryName(), propertyMapString));
            });
        }
    }

    private static void registerHoneycombBlockItem(@NotNull CustomBeeData customBeeData, IResourceManager resourceManager) {
        Item honeycombBlockItem;
        Item item = honeycombBlockItem = customBeeData.getCombBlockItemRegistryObject() != null ? (Item)customBeeData.getCombBlockItemRegistryObject().get() : null;
        if (honeycombBlockItem != null && honeycombBlockItem.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", ITEM_MODEL_PATH + honeycombBlockItem.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:honeycomb_block", MODEL_INVENTORY_TAG);
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeycombBlockItem.getRegistryName(), MODEL_INVENTORY_TAG));
        }
    }

    private static void registerHoneycombItem(@NotNull CustomBeeData customBeeData, IResourceManager resourceManager) {
        Item honeycomb;
        Item item = honeycomb = customBeeData.getCombRegistryObject() != null ? (Item)customBeeData.getCombRegistryObject().get() : null;
        if (honeycomb != null && honeycomb.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", ITEM_MODEL_PATH + honeycomb.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:honeycomb", MODEL_INVENTORY_TAG);
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeycomb.getRegistryName(), MODEL_INVENTORY_TAG));
        }
    }

    private static void registerBeeSpawnegg(@NotNull CustomBeeData customBeeData, IResourceManager resourceManager) {
        Item spawnEgg;
        Item item = spawnEgg = customBeeData.getSpawnEggItemRegistryObject() != null ? (Item)customBeeData.getSpawnEggItemRegistryObject().get() : null;
        if (spawnEgg != null && spawnEgg.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", ITEM_MODEL_PATH + spawnEgg.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            ModelResourceLocation defaultModelLocation = new ModelResourceLocation("minecraft:template_spawn_egg", MODEL_INVENTORY_TAG);
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(spawnEgg.getRegistryName(), MODEL_INVENTORY_TAG));
        }
    }

    private static void registerHoneyBottleItem(@NotNull HoneyBottleData honeyBottleData, IResourceManager resourceManager) {
        Item honeyBottleItem;
        Item item = honeyBottleItem = honeyBottleData.getHoneyBottleRegistryObject() != null ? (Item)honeyBottleData.getHoneyBottleRegistryObject().get() : null;
        if (honeyBottleItem != null && honeyBottleItem.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", ITEM_MODEL_PATH + honeyBottleItem.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:honey_bottle", MODEL_INVENTORY_TAG);
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeyBottleItem.getRegistryName(), MODEL_INVENTORY_TAG));
        }
    }

    private static void registerHoneyBlockItem(@NotNull HoneyBottleData honeyBottleData, IResourceManager resourceManager) {
        Item honeyBlockItem;
        Item item = honeyBlockItem = honeyBottleData.getHoneyBlockItemRegistryObject() != null ? (Item)honeyBottleData.getHoneyBlockItemRegistryObject().get() : null;
        if (honeyBlockItem != null && honeyBlockItem.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", ITEM_MODEL_PATH + honeyBlockItem.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:honey_block", MODEL_INVENTORY_TAG);
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeyBlockItem.getRegistryName(), MODEL_INVENTORY_TAG));
        }
    }

    private static void registerHoneyBucketItem(@NotNull HoneyBottleData honeyBottleData, IResourceManager resourceManager) {
        Item honeyBucketItem;
        Item item = honeyBucketItem = honeyBottleData.getHoneyBucketItemRegistryObject() != null ? (Item)honeyBottleData.getHoneyBucketItemRegistryObject().get() : null;
        if (honeyBucketItem != null && honeyBucketItem.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", ITEM_MODEL_PATH + honeyBucketItem.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
            ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:custom_honey_fluid_bucket", MODEL_INVENTORY_TAG);
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeyBucketItem.getRegistryName(), MODEL_INVENTORY_TAG));
        }
    }

    private static void registerHoneyBlock(@NotNull HoneyBottleData honeyBottleData, IResourceManager resourceManager) {
        Block honeyBlock;
        Block block = honeyBlock = honeyBottleData.getHoneyBlockRegistryObject() != null ? (Block)honeyBottleData.getHoneyBlockRegistryObject().get() : null;
        if (honeyBlock != null) {
            RenderTypeLookup.setRenderLayer((Block)honeyBlock, (RenderType)RenderType.func_228645_f_());
            if (honeyBlock.getRegistryName() != null && !resourceManager.func_219533_b(new ResourceLocation("resourcefulbees", "blockstates/" + honeyBlock.getRegistryName().func_110623_a() + JSON_FILE_EXTENSION))) {
                honeyBlock.func_176194_O().func_177619_a().forEach(state -> {
                    String propertyMapString = BlockModelShapes.func_209552_a((Map)state.func_206871_b());
                    ModelResourceLocation defaultModelLocation = new ModelResourceLocation("resourcefulbees:honey_block", propertyMapString);
                    ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
                    MODEL_MAP.put((Object)defaultModelLocation, (Object)new ModelResourceLocation(honeyBlock.getRegistryName(), propertyMapString));
                });
            }
        }
    }

    private static void registerHoneyFluid(@NotNull HoneyBottleData honeyBottleData) {
        FlowingFluid honeyFlowingFluid;
        FlowingFluidBlock honeyFluidBlock = honeyBottleData.getHoneyFluidBlockRegistryObject() != null ? (FlowingFluidBlock)honeyBottleData.getHoneyFluidBlockRegistryObject().get() : null;
        FlowingFluid honeyStillFluid = honeyBottleData.getHoneyStillFluidRegistryObject() != null ? (FlowingFluid)honeyBottleData.getHoneyStillFluidRegistryObject().get() : null;
        FlowingFluid flowingFluid = honeyFlowingFluid = honeyBottleData.getHoneyFlowingFluidRegistryObject() != null ? (FlowingFluid)honeyBottleData.getHoneyFlowingFluidRegistryObject().get() : null;
        if (honeyStillFluid != null) {
            RenderTypeLookup.setRenderLayer((Fluid)honeyStillFluid, (RenderType)RenderType.func_228645_f_());
        }
        if (honeyFlowingFluid != null) {
            RenderTypeLookup.setRenderLayer((Fluid)honeyFlowingFluid, (RenderType)RenderType.func_228645_f_());
        }
        if (honeyFluidBlock != null) {
            RenderTypeLookup.setRenderLayer((Block)honeyFluidBlock, (RenderType)RenderType.func_228645_f_());
        }
    }

    public static void registerModels(ModelRegistryEvent event) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        BeeRegistry.getRegistry().getBees().forEach((string, customBee) -> {
            if (customBee.shouldResourcefulBeesDoForgeRegistration()) {
                if (customBee.hasHoneycomb() && !customBee.hasCustomDrop()) {
                    ModelHandler.registerHoneycombBlockstate(customBee, resourceManager);
                    ModelHandler.registerHoneycombBlockItem(customBee, resourceManager);
                    ModelHandler.registerHoneycombItem(customBee, resourceManager);
                }
                ModelHandler.registerBeeSpawnegg(customBee, resourceManager);
            }
        });
        BeeRegistry.getRegistry().getHoneyBottles().forEach((string, honeyData) -> {
            if (honeyData.shouldResourcefulBeesDoForgeRegistration()) {
                ModelHandler.registerHoneyFluid(honeyData);
                ModelHandler.registerHoneyBottleItem(honeyData, resourceManager);
                ModelHandler.registerHoneyBlockItem(honeyData, resourceManager);
                ModelHandler.registerHoneyBucketItem(honeyData, resourceManager);
                ModelHandler.registerHoneyBlock(honeyData, resourceManager);
            }
        });
    }

    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        IBakedModel missingModel = (IBakedModel)modelRegistry.get(ModelBakery.field_177604_a);
        MODEL_MAP.asMap().forEach((resourceLocation, resourceLocations) -> {
            IBakedModel defaultModel = modelRegistry.getOrDefault(resourceLocation, missingModel);
            resourceLocations.forEach(modelLocation -> modelRegistry.put(modelLocation, defaultModel));
        });
    }
}

