/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.widget;

import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.widget.SubButtonList;
import com.resourcefulbees.resourcefulbees.client.gui.widget.TabImageButton;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ButtonList {
    public final int xPos;
    public final int yPos;
    private final int defaultHeight;
    protected int height;
    public final int width;
    public final int itemHeight;
    protected int scrollPos = 0;
    public final TabImageButton button;
    protected boolean active = false;
    Map<String, ? extends BeepediaPage> list;
    SortedMap<String, BeepediaPage> reducedList = new TreeMap<String, BeepediaPage>();

    public ButtonList(int xPos, int yPos, int width, int height, int itemHeight, TabImageButton button, Map<String, ? extends BeepediaPage> list) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.height = this.defaultHeight = height;
        this.width = width;
        this.itemHeight = itemHeight;
        this.list = list;
        this.button = button;
        if (this instanceof SubButtonList) {
            return;
        }
        this.updateReducedList(null, true);
        list.forEach((s, b) -> b.listButton.setParent(this));
    }

    public void setSearchHeight() {
        this.height = this.defaultHeight - 12;
    }

    public void resetHeight() {
        this.height = this.defaultHeight;
    }

    public int getScrollPos() {
        return this.scrollPos;
    }

    public void updateReducedList(String search, boolean resetHeight) {
        if (resetHeight) {
            this.scrollPos = 0;
        }
        this.reducedList.clear();
        if (search != null && !search.isEmpty()) {
            this.list.forEach((s, b) -> this.reduceList(search, (String)s, (BeepediaPage)b));
        } else {
            if (this.active) {
                this.list.forEach((s, b) -> {
                    b.listButton.field_230694_p_ = true;
                });
            }
            this.reducedList = new TreeMap<String, BeepediaPage>(this.list);
        }
    }

    private void reduceList(String search, String s, BeepediaPage b) {
        if (s.contains(search.toLowerCase()) || b.getSearch().toLowerCase().contains(search.toLowerCase())) {
            this.reducedList.put(s, b);
            if (this.active) {
                b.listButton.field_230694_p_ = true;
            }
        } else if (this.active) {
            b.listButton.field_230694_p_ = false;
        }
    }

    public void updatePos(int newPos) {
        if (this.height > this.reducedList.size() * this.itemHeight) {
            return;
        }
        this.scrollPos += newPos;
        if (this.scrollPos > 0) {
            this.scrollPos = 0;
        } else if (this.scrollPos < -(this.reducedList.size() * this.itemHeight - this.height)) {
            this.scrollPos = -(this.reducedList.size() * this.itemHeight - this.height);
        }
    }

    public void updateList() {
        AtomicInteger counter = new AtomicInteger();
        this.reducedList.forEach((s, b) -> {
            b.updateListPosition(this.xPos, this.yPos + this.scrollPos + counter.get() * this.itemHeight);
            counter.getAndIncrement();
        });
    }

    public void setActive(boolean active) {
        this.setActive(active, false);
    }

    public void setActive(boolean active, boolean forceRedraw) {
        boolean doUpdateList;
        this.active = active;
        if (this.button != null) {
            boolean bl = this.button.field_230693_o_ = !active;
        }
        if (!BeepediaScreen.listChanged() && !forceRedraw) {
            return;
        }
        this.list.forEach((s, b) -> {
            if (b.listButton != null) {
                b.listButton.field_230694_p_ = active;
            }
        });
        boolean searchVisible = BeepediaScreen.isSearchVisible();
        boolean bl = doUpdateList = active && searchVisible;
        if (doUpdateList) {
            this.updateReducedList(BeepediaScreen.getSearch(), BeepediaScreen.searchUpdated());
        }
    }

    public void setScrollPos(int scrollPos) {
        if (this.height > this.reducedList.size() * this.itemHeight) {
            return;
        }
        this.scrollPos = scrollPos;
        if (this.scrollPos > 0) {
            this.scrollPos = 0;
        } else if (this.scrollPos < -(this.reducedList.size() * this.itemHeight - this.height)) {
            this.scrollPos = -(this.reducedList.size() * this.itemHeight - this.height);
        }
    }
}

